/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.tools.Annotations;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionCallingUtils;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.FunctionDeclaration;
import com.google.protobuf.InvalidProtocolBufferException;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionTool
extends BaseTool {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(FunctionTool.class);
    private final Method func;
    private FunctionDeclaration funcDeclaration;

    public static FunctionTool create(Method func) {
        if (!FunctionTool.areParametersAnnotatedWithSchema(func) && FunctionTool.wasCompiledWithDefaultParameterNames(func)) {
            logger.error("Functions used in tools must have their parameters annotated with @Schema or at least the code must be compiled with the -parameters flag as a fallback. Your function tool will likely not work as expected and exit at runtime.");
        }
        return new FunctionTool(func, false);
    }

    private static boolean areParametersAnnotatedWithSchema(Method func) {
        for (Parameter parameter : func.getParameters()) {
            if (parameter.isAnnotationPresent(Annotations.Schema.class) && !parameter.getAnnotation(Annotations.Schema.class).name().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean wasCompiledWithDefaultParameterNames(Method func) {
        for (Parameter parameter : func.getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName.matches("arg\\d+")) continue;
            return false;
        }
        return true;
    }

    public static FunctionTool create(Class<?> cls, String methodName) {
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return FunctionTool.create(method);
        }
        throw new IllegalArgumentException(String.format("Method %s not found in class %s.", methodName, cls.getName()));
    }

    protected FunctionTool(Method func, boolean isLongRunning) {
        super(func.getAnnotation(Annotations.Schema.class) != null && !func.getAnnotation(Annotations.Schema.class).name().isEmpty() ? func.getAnnotation(Annotations.Schema.class).name() : func.getName(), func.getAnnotation(Annotations.Schema.class) != null ? func.getAnnotation(Annotations.Schema.class).description() : "", isLongRunning);
        if (!Modifier.isStatic(func.getModifiers())) {
            throw new IllegalArgumentException("Function tool only supports static methods.");
        }
        this.func = func;
        this.funcDeclaration = FunctionCallingUtils.buildFunctionDeclaration(this.func, (List<String>)ImmutableList.of((Object)"toolContext"));
    }

    @Override
    public Optional<FunctionDeclaration> declaration() {
        return Optional.of(this.funcDeclaration);
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        try {
            return this.call(args, toolContext).defaultIfEmpty((Object)ImmutableMap.of());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Single.just((Object)ImmutableMap.of());
        }
    }

    private Maybe<Map<String, Object>> call(Map<String, Object> args, ToolContext toolContext) throws InvalidProtocolBufferException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, JsonProcessingException {
        Parameter[] parameters = this.func.getParameters();
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String paramName;
            String string = paramName = parameters[i].getAnnotation(Annotations.Schema.class) != null && !parameters[i].getAnnotation(Annotations.Schema.class).name().isEmpty() ? parameters[i].getAnnotation(Annotations.Schema.class).name() : parameters[i].getName();
            if (paramName.equals("toolContext")) {
                arguments[i] = toolContext;
                continue;
            }
            if (!args.containsKey(paramName)) {
                throw new IllegalArgumentException(String.format("The parameter '%s' was not found in the arguments provided by the model.", paramName));
            }
            Class<?> paramType = parameters[i].getType();
            Object argValue = args.get(paramName);
            if (paramType.equals(List.class)) {
                if (argValue instanceof List) {
                    Type type = ((ParameterizedType)parameters[i].getParameterizedType()).getActualTypeArguments()[0];
                    arguments[i] = FunctionTool.createList((List)argValue, paramName, (Class)type);
                    continue;
                }
            } else if (argValue instanceof Map) {
                arguments[i] = OBJECT_MAPPER.convertValue((Object)((Map)argValue), paramType);
                continue;
            }
            arguments[i] = FunctionTool.castValue(argValue, paramName, paramType);
        }
        Object result = this.func.invoke(null, arguments);
        if (result == null) {
            return Maybe.empty();
        }
        if (result instanceof Maybe) {
            return (Maybe)result;
        }
        return Maybe.just((Object)((Map)result));
    }

    private static List<Object> createList(List<Object> values, String name, Class<?> type) throws JsonProcessingException, InvalidProtocolBufferException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!(type instanceof Class)) {
            return list;
        }
        Class<?> cls = type;
        for (Object value : values) {
            if (cls == Integer.class || cls == Long.class || cls == Double.class || cls == Float.class || cls == Boolean.class || cls == String.class) {
                list.add(FunctionTool.castValue(value, name, cls));
                continue;
            }
            list.add(OBJECT_MAPPER.convertValue((Object)((Map)value), type));
        }
        return list;
    }

    private static Object castValue(Object value, String name, Class<?> type) {
        if ((type.equals(Integer.class) || type.equals(Integer.TYPE)) && value instanceof Integer) {
            return value;
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            if (value instanceof Long || value instanceof Integer) {
                return value;
            }
        } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            if (value instanceof Double) {
                return (double)((Double)value);
            }
            if (value instanceof Float) {
                return ((Float)value).doubleValue();
            }
            if (value instanceof Integer) {
                return ((Integer)value).doubleValue();
            }
            if (value instanceof Long) {
                return ((Long)value).doubleValue();
            }
        } else if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            if (value instanceof Double) {
                return Float.valueOf(((Double)value).floatValue());
            }
            if (value instanceof Float) {
                return Float.valueOf(((Float)value).floatValue());
            }
            if (value instanceof Integer) {
                return Float.valueOf(((Integer)value).floatValue());
            }
            if (value instanceof Long) {
                return Float.valueOf(((Long)value).floatValue());
            }
        } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE) ? value instanceof Boolean : type.equals(String.class) && value instanceof String) {
            return value;
        }
        return OBJECT_MAPPER.convertValue(value, type);
    }
}

