/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.google.adk.tools.mcp.SseServerParameters;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_SseServerParameters
extends SseServerParameters {
    private final String url;
    @Nullable
    private final ImmutableMap<String, Object> headers;
    private final Duration timeout;
    private final Duration sseReadTimeout;

    private AutoValue_SseServerParameters(String url, @Nullable ImmutableMap<String, Object> headers, Duration timeout, Duration sseReadTimeout) {
        this.url = url;
        this.headers = headers;
        this.timeout = timeout;
        this.sseReadTimeout = sseReadTimeout;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public ImmutableMap<String, Object> headers() {
        return this.headers;
    }

    @Override
    public Duration timeout() {
        return this.timeout;
    }

    @Override
    public Duration sseReadTimeout() {
        return this.sseReadTimeout;
    }

    public String toString() {
        return "SseServerParameters{url=" + this.url + ", headers=" + String.valueOf(this.headers) + ", timeout=" + String.valueOf(this.timeout) + ", sseReadTimeout=" + String.valueOf(this.sseReadTimeout) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SseServerParameters) {
            SseServerParameters that = (SseServerParameters)o;
            return this.url.equals(that.url()) && (this.headers == null ? that.headers() == null : this.headers.equals(that.headers())) && this.timeout.equals(that.timeout()) && this.sseReadTimeout.equals(that.sseReadTimeout());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.url.hashCode();
        h$ *= 1000003;
        h$ ^= this.headers == null ? 0 : this.headers.hashCode();
        h$ *= 1000003;
        h$ ^= this.timeout.hashCode();
        h$ *= 1000003;
        return h$ ^= this.sseReadTimeout.hashCode();
    }

    static final class Builder
    extends SseServerParameters.Builder {
        private String url;
        private ImmutableMap<String, Object> headers;
        private Duration timeout;
        private Duration sseReadTimeout;

        Builder() {
        }

        @Override
        public SseServerParameters.Builder url(String url) {
            if (url == null) {
                throw new NullPointerException("Null url");
            }
            this.url = url;
            return this;
        }

        @Override
        public SseServerParameters.Builder headers(@Nullable Map<String, Object> headers) {
            this.headers = headers == null ? null : ImmutableMap.copyOf(headers);
            return this;
        }

        @Override
        public SseServerParameters.Builder timeout(Duration timeout) {
            if (timeout == null) {
                throw new NullPointerException("Null timeout");
            }
            this.timeout = timeout;
            return this;
        }

        @Override
        public SseServerParameters.Builder sseReadTimeout(Duration sseReadTimeout) {
            if (sseReadTimeout == null) {
                throw new NullPointerException("Null sseReadTimeout");
            }
            this.sseReadTimeout = sseReadTimeout;
            return this;
        }

        @Override
        public SseServerParameters build() {
            if (this.url == null || this.timeout == null || this.sseReadTimeout == null) {
                StringBuilder missing = new StringBuilder();
                if (this.url == null) {
                    missing.append(" url");
                }
                if (this.timeout == null) {
                    missing.append(" timeout");
                }
                if (this.sseReadTimeout == null) {
                    missing.append(" sseReadTimeout");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_SseServerParameters(this.url, this.headers, this.timeout, this.sseReadTimeout);
        }
    }
}

