/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.google.adk.tools.mcp.SseServerParameters;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.client.transport.StdioClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpSessionManager {
    private final Object connectionParams;
    private static final Logger logger = LoggerFactory.getLogger(McpSessionManager.class);

    public McpSessionManager(Object connectionParams) {
        this.connectionParams = connectionParams;
    }

    public McpSyncClient createSession() {
        return McpSessionManager.initializeSession(this.connectionParams);
    }

    public static McpSyncClient initializeSession(Object connectionParams) {
        StdioClientTransport transport;
        if (connectionParams instanceof ServerParameters) {
            transport = new StdioClientTransport((ServerParameters)connectionParams);
        } else if (connectionParams instanceof SseServerParameters) {
            SseServerParameters sseServerParams = (SseServerParameters)connectionParams;
            transport = HttpClientSseClientTransport.builder((String)sseServerParams.url()).sseEndpoint("sse").build();
        } else {
            throw new IllegalArgumentException("Connection parameters must be either ServerParameters or SseServerParameters, but got " + connectionParams.getClass().getName());
        }
        McpSyncClient client = McpClient.sync((McpClientTransport)transport).requestTimeout(Duration.ofSeconds(10L)).capabilities(McpSchema.ClientCapabilities.builder().build()).build();
        McpSchema.InitializeResult initResult = client.initialize();
        logger.debug("Initialize Client Result: {}", (Object)initResult);
        return client;
    }
}

