/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.LiveRequestQueue;
import com.google.adk.agents.RunConfig;
import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.exceptions.LlmCallsLimitExceededException;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.Session;
import com.google.genai.types.Content;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class InvocationContext {
    private final BaseSessionService sessionService;
    private final BaseArtifactService artifactService;
    private final Optional<LiveRequestQueue> liveRequestQueue;
    private Optional<String> branch;
    private final String invocationId;
    private BaseAgent agent;
    private final Session session;
    private final Optional<Content> userContent;
    private final RunConfig runConfig;
    private boolean endInvocation;
    private final InvocationCostManager invocationCostManager = new InvocationCostManager();

    private InvocationContext(BaseSessionService sessionService, BaseArtifactService artifactService, Optional<LiveRequestQueue> liveRequestQueue, Optional<String> branch, String invocationId, BaseAgent agent, Session session, Optional<Content> userContent, RunConfig runConfig, boolean endInvocation) {
        this.sessionService = sessionService;
        this.artifactService = artifactService;
        this.liveRequestQueue = liveRequestQueue;
        this.branch = branch;
        this.invocationId = invocationId;
        this.agent = agent;
        this.session = session;
        this.userContent = userContent;
        this.runConfig = runConfig;
        this.endInvocation = endInvocation;
    }

    public static InvocationContext create(BaseSessionService sessionService, BaseArtifactService artifactService, String invocationId, BaseAgent agent, Session session, Content userContent, RunConfig runConfig) {
        return new InvocationContext(sessionService, artifactService, Optional.empty(), Optional.empty(), invocationId, agent, session, Optional.ofNullable(userContent), runConfig, false);
    }

    public static InvocationContext create(BaseSessionService sessionService, BaseArtifactService artifactService, BaseAgent agent, Session session, LiveRequestQueue liveRequestQueue, RunConfig runConfig) {
        return new InvocationContext(sessionService, artifactService, Optional.ofNullable(liveRequestQueue), Optional.empty(), InvocationContext.newInvocationContextId(), agent, session, Optional.empty(), runConfig, false);
    }

    public static InvocationContext copyOf(InvocationContext other) {
        return new InvocationContext(other.sessionService, other.artifactService, other.liveRequestQueue, other.branch, other.invocationId, other.agent, other.session, other.userContent, other.runConfig, other.endInvocation);
    }

    protected BaseSessionService sessionService() {
        return this.sessionService;
    }

    public BaseArtifactService artifactService() {
        return this.artifactService;
    }

    public Optional<LiveRequestQueue> liveRequestQueue() {
        return this.liveRequestQueue;
    }

    public String invocationId() {
        return this.invocationId;
    }

    public void branch(@Nullable String branch) {
        this.branch = Optional.ofNullable(branch);
    }

    public Optional<String> branch() {
        return this.branch;
    }

    public BaseAgent agent() {
        return this.agent;
    }

    public void agent(BaseAgent agent) {
        this.agent = agent;
    }

    public Session session() {
        return this.session;
    }

    public Optional<Content> userContent() {
        return this.userContent;
    }

    public RunConfig runConfig() {
        return this.runConfig;
    }

    public boolean endInvocation() {
        return this.endInvocation;
    }

    public void setEndInvocation(boolean endInvocation) {
        this.endInvocation = endInvocation;
    }

    public String appName() {
        return this.session.appName();
    }

    public String userId() {
        return this.session.userId();
    }

    public static String newInvocationContextId() {
        return "e-" + String.valueOf(UUID.randomUUID());
    }

    public void incrementLlmCallsCount() throws LlmCallsLimitExceededException {
        this.invocationCostManager.incrementAndEnforceLlmCallsLimit(this.runConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvocationContext)) {
            return false;
        }
        InvocationContext that = (InvocationContext)o;
        return this.endInvocation == that.endInvocation && Objects.equals(this.sessionService, that.sessionService) && Objects.equals(this.artifactService, that.artifactService) && Objects.equals(this.liveRequestQueue, that.liveRequestQueue) && Objects.equals(this.branch, that.branch) && Objects.equals(this.invocationId, that.invocationId) && Objects.equals(this.agent, that.agent) && Objects.equals(this.session, that.session) && Objects.equals(this.userContent, that.userContent) && Objects.equals(this.runConfig, that.runConfig);
    }

    public int hashCode() {
        return Objects.hash(this.sessionService, this.artifactService, this.liveRequestQueue, this.branch, this.invocationId, this.agent, this.session, this.userContent, this.runConfig, this.endInvocation);
    }

    private static class InvocationCostManager {
        private int numberOfLlmCalls = 0;

        private InvocationCostManager() {
        }

        public void incrementAndEnforceLlmCallsLimit(RunConfig runConfig) throws LlmCallsLimitExceededException {
            ++this.numberOfLlmCalls;
            if (runConfig != null && runConfig.maxLlmCalls() > 0 && this.numberOfLlmCalls > runConfig.maxLlmCalls()) {
                throw new LlmCallsLimitExceededException("Max number of llm calls limit of " + runConfig.maxLlmCalls() + " exceeded");
            }
        }
    }
}

