/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.ReadonlyContext;
import com.google.adk.events.Event;
import com.google.adk.flows.llmflows.RequestProcessor;
import com.google.adk.models.LlmRequest;
import com.google.adk.utils.InstructionUtils;
import com.google.common.collect.ImmutableList;
import io.reactivex.rxjava3.core.Single;
import java.util.List;

public final class Instructions
implements RequestProcessor {
    @Override
    public Single<RequestProcessor.RequestProcessingResult> processRequest(InvocationContext context, LlmRequest request) {
        if (!(context.agent() instanceof LlmAgent)) {
            return Single.error((Throwable)new IllegalArgumentException("Agent in InvocationContext is not an instance of LlmAgent."));
        }
        LlmAgent agent = (LlmAgent)context.agent();
        ReadonlyContext readonlyContext = new ReadonlyContext(context);
        Single builderSingle = Single.just((Object)request.toBuilder());
        if (agent.rootAgent() instanceof LlmAgent) {
            LlmAgent rootAgent = (LlmAgent)agent.rootAgent();
            builderSingle = builderSingle.flatMap(builder -> rootAgent.canonicalGlobalInstruction(readonlyContext).flatMap(globalInstr -> {
                if (!globalInstr.isEmpty()) {
                    return InstructionUtils.injectSessionState(context, globalInstr).map(resolvedGlobalInstr -> builder.appendInstructions((List<String>)ImmutableList.of((Object)resolvedGlobalInstr)));
                }
                return Single.just((Object)builder);
            }));
        }
        builderSingle = builderSingle.flatMap(builder -> agent.canonicalInstruction(readonlyContext).flatMap(agentInstr -> {
            if (!agentInstr.isEmpty()) {
                return InstructionUtils.injectSessionState(context, agentInstr).map(resolvedAgentInstr -> builder.appendInstructions((List<String>)ImmutableList.of((Object)resolvedAgentInstr)));
            }
            return Single.just((Object)builder);
        }));
        return builderSingle.map(finalBuilder -> RequestProcessor.RequestProcessingResult.create(finalBuilder.build(), (Iterable<Event>)ImmutableList.of()));
    }
}

