/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.anthropic.client.AnthropicClient;
import com.anthropic.core.JsonValue;
import com.anthropic.models.messages.ContentBlock;
import com.anthropic.models.messages.ContentBlockParam;
import com.anthropic.models.messages.Message;
import com.anthropic.models.messages.MessageCreateParams;
import com.anthropic.models.messages.MessageParam;
import com.anthropic.models.messages.TextBlockParam;
import com.anthropic.models.messages.Tool;
import com.anthropic.models.messages.ToolChoice;
import com.anthropic.models.messages.ToolChoiceAuto;
import com.anthropic.models.messages.ToolResultBlockParam;
import com.anthropic.models.messages.ToolUnion;
import com.anthropic.models.messages.ToolUseBlockParam;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.adk.models.BaseLlm;
import com.google.adk.models.BaseLlmConnection;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Part;
import com.google.genai.types.Schema;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Claude
extends BaseLlm {
    private static final Logger logger = LoggerFactory.getLogger(Claude.class);
    private static final int MAX_TOKEN = 1024;
    private final AnthropicClient anthropicClient;

    public Claude(String modelName, AnthropicClient anthropicClient) {
        super(modelName);
        this.anthropicClient = anthropicClient;
    }

    @Override
    public Flowable<LlmResponse> generateContent(LlmRequest llmRequest, boolean stream) {
        String extractedSystemText;
        Optional systemInstructionOpt;
        List messages = llmRequest.contents().stream().map(this::contentToAnthropicMessageParam).collect(Collectors.toList());
        Object tools = ImmutableList.of();
        if (llmRequest.config().isPresent() && llmRequest.config().get().tools().isPresent() && !((List)llmRequest.config().get().tools().get()).isEmpty() && ((com.google.genai.types.Tool)((List)llmRequest.config().get().tools().get()).get(0)).functionDeclarations().isPresent()) {
            tools = ((List)((com.google.genai.types.Tool)((List)llmRequest.config().get().tools().get()).get(0)).functionDeclarations().get()).stream().map(this::functionDeclarationToAnthropicTool).map(tool -> ToolUnion.ofTool((Tool)tool)).collect(Collectors.toList());
        }
        ToolChoice toolChoice = llmRequest.tools().isEmpty() ? null : ToolChoice.ofAuto((ToolChoiceAuto)ToolChoiceAuto.builder().disableParallelToolUse(true).build());
        String systemText = "";
        Optional<GenerateContentConfig> configOpt = llmRequest.config();
        if (configOpt.isPresent() && (systemInstructionOpt = configOpt.get().systemInstruction()).isPresent() && !(extractedSystemText = ((List)((Content)systemInstructionOpt.get()).parts().orElse(ImmutableList.of())).stream().filter(p -> p.text().isPresent()).map(p -> (String)p.text().get()).collect(Collectors.joining("\n"))).isEmpty()) {
            systemText = extractedSystemText;
        }
        Message message = this.anthropicClient.messages().create(MessageCreateParams.builder().model(llmRequest.model().orElse(this.model())).system(systemText).messages(messages).tools((List)tools).toolChoice(toolChoice).maxTokens(1024L).build());
        logger.debug("Claude response: {}", (Object)message);
        return Flowable.just((Object)this.convertAnthropicResponseToLlmResponse(message));
    }

    private MessageParam.Role toClaudeRole(String role) {
        return role.equals("model") || role.equals("assistant") ? MessageParam.Role.ASSISTANT : MessageParam.Role.USER;
    }

    private MessageParam contentToAnthropicMessageParam(Content content) {
        return MessageParam.builder().role(this.toClaudeRole(content.role().orElse(""))).contentOfBlockParams(((List)content.parts().orElse(ImmutableList.of())).stream().map(this::partToAnthropicMessageBlock).filter(Objects::nonNull).collect(Collectors.toList())).build();
    }

    private ContentBlockParam partToAnthropicMessageBlock(Part part) {
        if (part.text().isPresent()) {
            return ContentBlockParam.ofText((TextBlockParam)TextBlockParam.builder().text((String)part.text().get()).build());
        }
        if (part.functionCall().isPresent()) {
            return ContentBlockParam.ofToolUse((ToolUseBlockParam)ToolUseBlockParam.builder().id(((FunctionCall)part.functionCall().get()).id().orElse("")).name((String)((FunctionCall)part.functionCall().get()).name().orElseThrow()).type(JsonValue.from((Object)"tool_use")).input(JsonValue.from((Object)((FunctionCall)part.functionCall().get()).args().orElse(ImmutableMap.of()))).build());
        }
        if (part.functionResponse().isPresent()) {
            String content = "";
            if (((FunctionResponse)part.functionResponse().get()).response().isPresent() && ((Map)((FunctionResponse)part.functionResponse().get()).response().get()).getOrDefault("result", null) != null) {
                content = ((Map)((FunctionResponse)part.functionResponse().get()).response().get()).get("result").toString();
            }
            return ContentBlockParam.ofToolResult((ToolResultBlockParam)ToolResultBlockParam.builder().toolUseId(((FunctionResponse)part.functionResponse().get()).id().orElse("")).content(content).isError(false).build());
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void updateTypeString(Map<String, Object> valueDict) {
        if (valueDict == null) {
            return;
        }
        if (valueDict.containsKey("type")) {
            valueDict.put("type", ((String)valueDict.get("type")).toLowerCase());
        }
        if (valueDict.containsKey("items")) {
            Map properties;
            this.updateTypeString((Map)valueDict.get("items"));
            if (valueDict.get("items") instanceof Map && ((Map)valueDict.get("items")).containsKey("properties") && (properties = (Map)((Map)valueDict.get("items")).get("properties")) != null) {
                for (Object value : properties.values()) {
                    if (!(value instanceof Map)) continue;
                    this.updateTypeString((Map)value);
                }
            }
        }
    }

    private Tool functionDeclarationToAnthropicTool(FunctionDeclaration functionDeclaration) {
        HashMap properties = new HashMap();
        if (functionDeclaration.parameters().isPresent() && ((Schema)functionDeclaration.parameters().get()).properties().isPresent()) {
            ((Map)((Schema)functionDeclaration.parameters().get()).properties().get()).forEach((key, schema) -> {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.registerModule((Module)new Jdk8Module());
                Map schemaMap = (Map)objectMapper.convertValue(schema, (TypeReference)new TypeReference<Map<String, Object>>(){});
                this.updateTypeString(schemaMap);
                properties.put(key, schemaMap);
            });
        }
        return Tool.builder().name((String)functionDeclaration.name().orElseThrow()).description(functionDeclaration.description().orElse("")).inputSchema(Tool.InputSchema.builder().properties(JsonValue.from(properties)).build()).build();
    }

    private LlmResponse convertAnthropicResponseToLlmResponse(Message message) {
        LlmResponse.Builder responseBuilder = LlmResponse.builder();
        ArrayList<Part> parts = new ArrayList<Part>();
        if (message.content() != null) {
            for (ContentBlock block : message.content()) {
                Part part = this.anthropicContentBlockToPart(block);
                if (part == null) continue;
                parts.add(part);
            }
            responseBuilder.content(Content.builder().role("model").parts((List)ImmutableList.copyOf(parts)).build());
        }
        return responseBuilder.build();
    }

    private Part anthropicContentBlockToPart(ContentBlock block) {
        if (block.isText()) {
            return Part.builder().text(block.asText().text()).build();
        }
        if (block.isToolUse()) {
            return Part.builder().functionCall(FunctionCall.builder().id(block.asToolUse().id()).name(block.asToolUse().name()).args((Map)block.asToolUse()._input().convert((TypeReference)new TypeReference<Map<String, Object>>(){})).build()).build();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BaseLlmConnection connect(LlmRequest llmRequest) {
        throw new UnsupportedOperationException("Live connection is not supported for Claude models.");
    }
}

