/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.GetSessionConfig;
import com.google.adk.sessions.ListEventsResponse;
import com.google.adk.sessions.ListSessionsResponse;
import com.google.adk.sessions.Session;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemorySessionService
implements BaseSessionService {
    private static final Logger logger = LoggerFactory.getLogger(InMemorySessionService.class);
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, Session>>> sessions = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, Session>>>();
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, Object>>> userState = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, Object>>>();
    private final ConcurrentMap<String, ConcurrentMap<String, Object>> appState = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();

    @Override
    public Single<Session> createSession(String appName, String userId, @Nullable ConcurrentMap<String, Object> state, @Nullable String sessionId) {
        Objects.requireNonNull(appName, "appName cannot be null");
        Objects.requireNonNull(userId, "userId cannot be null");
        String resolvedSessionId = Optional.ofNullable(sessionId).map(String::trim).filter(s -> !s.isEmpty()).orElseGet(() -> UUID.randomUUID().toString());
        ConcurrentHashMap<String, Object> initialState = state == null ? new ConcurrentHashMap<String, Object>() : new ConcurrentHashMap<String, Object>(state);
        ArrayList<Event> initialEvents = new ArrayList<Event>();
        Session newSession = Session.builder(resolvedSessionId).appName(appName).userId(userId).state(initialState).events(initialEvents).lastUpdateTime(Instant.now()).build();
        this.sessions.computeIfAbsent(appName, k -> new ConcurrentHashMap()).computeIfAbsent(userId, k -> new ConcurrentHashMap()).put(resolvedSessionId, newSession);
        Session returnCopy = this.copySession(newSession);
        return Single.just((Object)this.mergeWithGlobalState(appName, userId, returnCopy));
    }

    @Override
    public Maybe<Session> getSession(String appName, String userId, String sessionId, Optional<GetSessionConfig> configOpt) {
        Objects.requireNonNull(appName, "appName cannot be null");
        Objects.requireNonNull(userId, "userId cannot be null");
        Objects.requireNonNull(sessionId, "sessionId cannot be null");
        Objects.requireNonNull(configOpt, "configOpt cannot be null");
        Session storedSession = (Session)((ConcurrentMap)((ConcurrentMap)this.sessions.getOrDefault(appName, new ConcurrentHashMap())).getOrDefault(userId, new ConcurrentHashMap())).get(sessionId);
        if (storedSession == null) {
            return Maybe.empty();
        }
        Session sessionCopy = this.copySession(storedSession);
        GetSessionConfig config = configOpt.orElse(GetSessionConfig.builder().build());
        List<Event> eventsInCopy = sessionCopy.events();
        config.numRecentEvents().ifPresent(num -> {
            if (!eventsInCopy.isEmpty() && num < eventsInCopy.size()) {
                List eventsToRemove = eventsInCopy.subList(0, eventsInCopy.size() - num);
                eventsToRemove.clear();
            }
        });
        if (config.numRecentEvents().isEmpty() && config.afterTimestamp().isPresent()) {
            Instant threshold = config.afterTimestamp().get();
            eventsInCopy.removeIf(event -> this.getEventTimestampEpochSeconds((Event)event) < threshold.getEpochSecond());
        }
        return Maybe.just((Object)this.mergeWithGlobalState(appName, userId, sessionCopy));
    }

    private long getEventTimestampEpochSeconds(Event event) {
        return event.timestamp();
    }

    @Override
    public Single<ListSessionsResponse> listSessions(String appName, String userId) {
        Objects.requireNonNull(appName, "appName cannot be null");
        Objects.requireNonNull(userId, "userId cannot be null");
        Map userSessionsMap = (Map)((ConcurrentMap)this.sessions.getOrDefault(appName, new ConcurrentHashMap())).get(userId);
        if (userSessionsMap == null || userSessionsMap.isEmpty()) {
            return Single.just((Object)ListSessionsResponse.builder().build());
        }
        List sessionCopies = userSessionsMap.values().stream().map(this::copySessionMetadata).collect(Collectors.toCollection(ArrayList::new));
        return Single.just((Object)ListSessionsResponse.builder().sessions(sessionCopies).build());
    }

    @Override
    public Completable deleteSession(String appName, String userId, String sessionId) {
        Objects.requireNonNull(appName, "appName cannot be null");
        Objects.requireNonNull(userId, "userId cannot be null");
        Objects.requireNonNull(sessionId, "sessionId cannot be null");
        ConcurrentMap userSessionsMap = (ConcurrentMap)((ConcurrentMap)this.sessions.getOrDefault(appName, new ConcurrentHashMap())).get(userId);
        if (userSessionsMap != null) {
            userSessionsMap.remove(sessionId);
        }
        return Completable.complete();
    }

    @Override
    public Single<ListEventsResponse> listEvents(String appName, String userId, String sessionId) {
        Objects.requireNonNull(appName, "appName cannot be null");
        Objects.requireNonNull(userId, "userId cannot be null");
        Objects.requireNonNull(sessionId, "sessionId cannot be null");
        Session storedSession = (Session)((ConcurrentMap)((ConcurrentMap)this.sessions.getOrDefault(appName, new ConcurrentHashMap())).getOrDefault(userId, new ConcurrentHashMap())).get(sessionId);
        if (storedSession == null) {
            return Single.just((Object)ListEventsResponse.builder().build());
        }
        ImmutableList eventsCopy = ImmutableList.copyOf(storedSession.events());
        return Single.just((Object)ListEventsResponse.builder().events((List<Event>)eventsCopy).build());
    }

    @Override
    @CanIgnoreReturnValue
    public Single<Event> appendEvent(Session session, Event event) {
        ConcurrentMap<String, Object> stateDelta;
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(event, "event cannot be null");
        Objects.requireNonNull(session.appName(), "session.appName cannot be null");
        Objects.requireNonNull(session.userId(), "session.userId cannot be null");
        Objects.requireNonNull(session.id(), "session.id cannot be null");
        String appName = session.appName();
        String userId = session.userId();
        String sessionId = session.id();
        EventActions actions = event.actions();
        if (actions != null && (stateDelta = actions.stateDelta()) != null && !stateDelta.isEmpty()) {
            stateDelta.forEach((key, value) -> {
                if (key.startsWith("app:")) {
                    String appStateKey = key.substring("app:".length());
                    this.appState.computeIfAbsent(appName, k -> new ConcurrentHashMap()).put(appStateKey, value);
                } else if (key.startsWith("user:")) {
                    String userStateKey = key.substring("user:".length());
                    this.userState.computeIfAbsent(appName, k -> new ConcurrentHashMap()).computeIfAbsent(userId, k -> new ConcurrentHashMap()).put(userStateKey, value);
                }
            });
        }
        BaseSessionService.super.appendEvent(session, event);
        session.lastUpdateTime(this.getInstantFromEvent(event));
        ((ConcurrentMap)((ConcurrentMap)this.sessions.getOrDefault(appName, new ConcurrentHashMap())).getOrDefault(userId, new ConcurrentHashMap())).put(sessionId, session);
        return Single.just((Object)event);
    }

    private Instant getInstantFromEvent(Event event) {
        double epochSeconds = this.getEventTimestampEpochSeconds(event);
        long seconds = (long)epochSeconds;
        long nanos = (long)(epochSeconds % 1.0 * 1.0E9);
        return Instant.ofEpochSecond(seconds, nanos);
    }

    private Session copySession(Session original) {
        return Session.builder(original.id()).appName(original.appName()).userId(original.userId()).state(new ConcurrentHashMap<String, Object>(original.state())).events(new ArrayList<Event>(original.events())).lastUpdateTime(original.lastUpdateTime()).build();
    }

    private Session copySessionMetadata(Session original) {
        return Session.builder(original.id()).appName(original.appName()).userId(original.userId()).lastUpdateTime(original.lastUpdateTime()).build();
    }

    @CanIgnoreReturnValue
    private Session mergeWithGlobalState(String appName, String userId, Session session) {
        ConcurrentMap<String, Object> sessionState = session.state();
        ((ConcurrentMap)this.appState.getOrDefault(appName, new ConcurrentHashMap())).forEach((key, value) -> sessionState.put("app:" + key, value));
        ((ConcurrentMap)((ConcurrentMap)this.userState.getOrDefault(appName, new ConcurrentHashMap())).getOrDefault(userId, new ConcurrentHashMap())).forEach((key, value) -> sessionState.put("user:" + key, value));
        return session;
    }
}

