/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.models.LlmRequest;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Tool;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jspecify.annotations.Nullable;

public abstract class BaseTool {
    private final String name;
    private final String description;
    private final boolean isLongRunning;

    protected BaseTool(@Nonnull String name, @Nonnull String description) {
        this(name, description, false);
    }

    protected BaseTool(@Nonnull String name, @Nonnull String description, boolean isLongRunning) {
        this.name = name;
        this.description = description;
        this.isLongRunning = isLongRunning;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean longRunning() {
        return this.isLongRunning;
    }

    public Optional<FunctionDeclaration> declaration() {
        return Optional.empty();
    }

    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    @CanIgnoreReturnValue
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        if (this.declaration().isEmpty()) {
            return Completable.complete();
        }
        llmRequestBuilder.appendTools((List<BaseTool>)ImmutableList.of((Object)this));
        LlmRequest llmRequest = llmRequestBuilder.build();
        ImmutableList<Tool> toolsWithoutFunctionDeclarations = BaseTool.findToolsWithoutFunctionDeclarations(llmRequest);
        Tool toolWithFunctionDeclarations = BaseTool.findToolWithFunctionDeclarations(llmRequest);
        toolWithFunctionDeclarations = toolWithFunctionDeclarations == null ? Tool.builder().functionDeclarations((List)ImmutableList.of((Object)this.declaration().get())).build() : toolWithFunctionDeclarations.toBuilder().functionDeclarations((List)ImmutableList.builder().addAll((Iterable)toolWithFunctionDeclarations.functionDeclarations().orElse(ImmutableList.of())).add((Object)this.declaration().get()).build()).build();
        GenerateContentConfig generateContentConfig = llmRequest.config().map(GenerateContentConfig::toBuilder).orElse(GenerateContentConfig.builder()).tools((List)new ImmutableList.Builder().addAll(toolsWithoutFunctionDeclarations).add((Object)toolWithFunctionDeclarations).build()).build();
        llmRequestBuilder.config(generateContentConfig);
        return Completable.complete();
    }

    private static @Nullable Tool findToolWithFunctionDeclarations(LlmRequest llmRequest) {
        return llmRequest.config().flatMap(config -> config.tools()).flatMap(tools -> tools.stream().filter(t -> t.functionDeclarations().isPresent()).findFirst()).orElse(null);
    }

    private static ImmutableList<Tool> findToolsWithoutFunctionDeclarations(LlmRequest llmRequest) {
        return llmRequest.config().flatMap(config -> config.tools()).map(tools -> (ImmutableList)tools.stream().filter(t -> t.functionDeclarations().isEmpty()).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }
}

