/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.tools.mcp.McpSessionManager;
import com.google.adk.tools.mcp.McpTool;
import com.google.adk.tools.mcp.SseServerParameters;
import com.google.common.collect.ImmutableList;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpToolset
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(McpToolset.class);
    private final McpSessionManager mcpSessionManager;
    private McpSyncClient mcpSession;
    private final ObjectMapper objectMapper;

    public McpToolset(SseServerParameters connectionParams, ObjectMapper objectMapper) {
        Objects.requireNonNull(connectionParams);
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
        this.mcpSessionManager = new McpSessionManager(connectionParams);
    }

    public McpToolset(ServerParameters connectionParams, ObjectMapper objectMapper) {
        Objects.requireNonNull(connectionParams);
        this.objectMapper = objectMapper;
        this.mcpSessionManager = new McpSessionManager(connectionParams);
    }

    public McpToolset(SseServerParameters connectionParams) {
        this(connectionParams, JsonBaseModel.getMapper());
    }

    public McpToolset(ServerParameters connectionParams) {
        this(connectionParams, JsonBaseModel.getMapper());
    }

    private static CompletableFuture<McpToolsAndToolsetResult> fromServerInternal(Object connectionParams, ObjectMapper objectMapper) {
        McpToolset toolset;
        if (connectionParams instanceof SseServerParameters) {
            SseServerParameters sseServerParameters = (SseServerParameters)connectionParams;
            toolset = new McpToolset(sseServerParameters, objectMapper);
        } else if (connectionParams instanceof ServerParameters) {
            ServerParameters serverParameters = (ServerParameters)connectionParams;
            toolset = new McpToolset(serverParameters, objectMapper);
        } else {
            throw new IllegalArgumentException("Connection parameters must be either" + ServerParameters.class.getName() + " or " + SseServerParameters.class.getName() + "but got " + connectionParams.getClass().getName());
        }
        return ((CompletableFuture)((CompletableFuture)toolset.initializeSession().thenCompose(session -> toolset.loadTools())).thenApply(tools -> new McpToolsAndToolsetResult((List<McpTool>)tools, toolset))).exceptionallyCompose(e -> {
            CompletableFuture failedFuture = new CompletableFuture();
            logger.error("Error during McpToolset operation, attempting cleanup.", e);
            try {
                toolset.close();
            }
            catch (RuntimeException closeException) {
                logger.warn("Failed to close McpToolset after error", (Throwable)closeException);
                e.addSuppressed(closeException);
            }
            failedFuture.completeExceptionally(new McpToolsetException("Failed to load tools from MCP server during fromServer call. See suppressed exceptions for details.", (Throwable)e));
            return failedFuture;
        });
    }

    public static CompletableFuture<McpToolsAndToolsetResult> fromServer(SseServerParameters connectionParams, ObjectMapper objectMapper) {
        return McpToolset.fromServerInternal(connectionParams, objectMapper);
    }

    public static CompletableFuture<McpToolsAndToolsetResult> fromServer(ServerParameters connectionParams, ObjectMapper objectMapper) {
        return McpToolset.fromServerInternal(connectionParams, objectMapper);
    }

    public static CompletableFuture<McpToolsAndToolsetResult> fromServer(SseServerParameters connectionParams) {
        return McpToolset.fromServerInternal(connectionParams, JsonBaseModel.getMapper());
    }

    public static CompletableFuture<McpToolsAndToolsetResult> fromServer(ServerParameters connectionParams) {
        return McpToolset.fromServerInternal(connectionParams, JsonBaseModel.getMapper());
    }

    private CompletableFuture<McpSyncClient> initializeSession() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.mcpSession = this.mcpSessionManager.createSession();
                return this.mcpSession;
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid connection parameters for MCP session.", (Throwable)e);
                throw new McpInitializationException("Invalid connection parameters for MCP session.", e);
            }
            catch (RuntimeException e) {
                logger.error("Unexpected error during MCP session initialization.", (Throwable)e);
                throw new McpInitializationException("Unexpected error during MCP session initialization.", e);
            }
        });
    }

    public CompletableFuture<List<McpTool>> loadTools() {
        int maxRetries = 3;
        long retryDelayMillis = 100L;
        return CompletableFuture.supplyAsync(() -> {
            for (int i = 0; i < 3; ++i) {
                try {
                    if (this.mcpSession == null) {
                        logger.info("MCP session is null, attempting to reinitialize.");
                        this.mcpSession = this.mcpSessionManager.createSession();
                    }
                    McpSchema.ListToolsResult toolsResponse = this.mcpSession.listTools();
                    return (List)toolsResponse.tools().stream().map(tool -> new McpTool((McpSchema.Tool)tool, this.mcpSession, this.mcpSessionManager, this.objectMapper)).collect(ImmutableList.toImmutableList());
                }
                catch (IllegalArgumentException e) {
                    logger.error("Invalid argument encountered during tool loading.", (Throwable)e);
                    throw new McpToolLoadingException("Invalid argument encountered during tool loading.", e);
                }
                catch (RuntimeException e) {
                    logger.error("Unexpected error during tool loading, retry attempt " + (i + 1), (Throwable)e);
                    if (i < 2) {
                        try {
                            logger.info("Reinitializing MCP session before next retry for unexpected error.");
                            this.mcpSession = this.mcpSessionManager.createSession();
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            logger.error("Interrupted during retry delay for loadTools (unexpected error).", (Throwable)ie);
                            throw new McpToolLoadingException("Interrupted during retry delay (unexpected error)", ie);
                        }
                        catch (RuntimeException reinitE) {
                            logger.error("Failed to reinitialize session during retry (unexpected error).", (Throwable)reinitE);
                            throw new McpInitializationException("Failed to reinitialize session during tool loading retry (unexpected error).", reinitE);
                        }
                    }
                    logger.error("Failed to load tools after multiple retries due to unexpected error.", (Throwable)e);
                    throw new McpToolLoadingException("Failed to load tools after multiple retries due to unexpected error.", e);
                }
            }
            throw new IllegalStateException("Unexpected state: loadTools retry loop completed without success or throwing an exception.");
        });
    }

    @Override
    public void close() {
        if (this.mcpSession != null) {
            try {
                this.mcpSession.close();
                logger.debug("MCP session closed successfully.");
            }
            catch (RuntimeException e) {
                logger.error("Failed to close MCP session", (Throwable)e);
            }
            finally {
                this.mcpSession = null;
            }
        }
    }

    public static class McpToolLoadingException
    extends McpToolsetException {
        public McpToolLoadingException(String message) {
            super(message);
        }

        public McpToolLoadingException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class McpInitializationException
    extends McpToolsetException {
        public McpInitializationException(String message) {
            super(message);
        }

        public McpInitializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class McpToolsetException
    extends RuntimeException {
        public McpToolsetException(String message) {
            super(message);
        }

        public McpToolsetException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class McpToolsAndToolsetResult {
        private final List<McpTool> tools;
        private final McpToolset toolset;

        public McpToolsAndToolsetResult(List<McpTool> tools, McpToolset toolset) {
            this.tools = tools;
            this.toolset = toolset;
        }

        public List<McpTool> getTools() {
            return this.tools;
        }

        public McpToolset getToolset() {
            return this.toolset;
        }
    }
}

