package com.google.adk.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.adk.tools.BaseTool;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.LiveConnectConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LlmRequest extends LlmRequest {

  private final Optional<String> model;

  private final List<Content> contents;

  private final Optional<GenerateContentConfig> config;

  private final LiveConnectConfig liveConnectConfig;

  private final Map<String, BaseTool> tools;

  private AutoValue_LlmRequest(
      Optional<String> model,
      List<Content> contents,
      Optional<GenerateContentConfig> config,
      LiveConnectConfig liveConnectConfig,
      Map<String, BaseTool> tools) {
    this.model = model;
    this.contents = contents;
    this.config = config;
    this.liveConnectConfig = liveConnectConfig;
    this.tools = tools;
  }

  @JsonProperty("model")
  @Override
  public Optional<String> model() {
    return model;
  }

  @JsonProperty("contents")
  @Override
  public List<Content> contents() {
    return contents;
  }

  @JsonProperty("config")
  @Override
  public Optional<GenerateContentConfig> config() {
    return config;
  }

  @JsonProperty("liveConnectConfig")
  @Override
  public LiveConnectConfig liveConnectConfig() {
    return liveConnectConfig;
  }

  @JsonIgnore
  @Override
  public Map<String, BaseTool> tools() {
    return tools;
  }

  @Override
  public String toString() {
    return "LlmRequest{"
        + "model=" + model + ", "
        + "contents=" + contents + ", "
        + "config=" + config + ", "
        + "liveConnectConfig=" + liveConnectConfig + ", "
        + "tools=" + tools
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LlmRequest) {
      LlmRequest that = (LlmRequest) o;
      return this.model.equals(that.model())
          && this.contents.equals(that.contents())
          && this.config.equals(that.config())
          && this.liveConnectConfig.equals(that.liveConnectConfig())
          && this.tools.equals(that.tools());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= model.hashCode();
    h$ *= 1000003;
    h$ ^= contents.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    h$ *= 1000003;
    h$ ^= liveConnectConfig.hashCode();
    h$ *= 1000003;
    h$ ^= tools.hashCode();
    return h$;
  }

  @Override
  public LlmRequest.Builder toBuilder() {
    return new AutoValue_LlmRequest.Builder(this);
  }

  static final class Builder extends LlmRequest.Builder {
    private Optional<String> model = Optional.empty();
    private List<Content> contents;
    private Optional<GenerateContentConfig> config = Optional.empty();
    private LiveConnectConfig liveConnectConfig;
    private Map<String, BaseTool> tools;
    Builder() {
    }
    Builder(LlmRequest source) {
      this.model = source.model();
      this.contents = source.contents();
      this.config = source.config();
      this.liveConnectConfig = source.liveConnectConfig();
      this.tools = source.tools();
    }
    @Override
    public LlmRequest.Builder model(String model) {
      this.model = Optional.of(model);
      return this;
    }
    @Override
    public LlmRequest.Builder contents(List<Content> contents) {
      if (contents == null) {
        throw new NullPointerException("Null contents");
      }
      this.contents = contents;
      return this;
    }
    @Override
    public LlmRequest.Builder config(GenerateContentConfig config) {
      this.config = Optional.of(config);
      return this;
    }
    @Override
    public Optional<GenerateContentConfig> config() {
      return config;
    }
    @Override
    public LlmRequest.Builder liveConnectConfig(LiveConnectConfig liveConnectConfig) {
      if (liveConnectConfig == null) {
        throw new NullPointerException("Null liveConnectConfig");
      }
      this.liveConnectConfig = liveConnectConfig;
      return this;
    }
    @Override
    LiveConnectConfig liveConnectConfig() {
      if (this.liveConnectConfig == null) {
        throw new IllegalStateException("Property \"liveConnectConfig\" has not been set");
      }
      return liveConnectConfig;
    }
    @Override
    LlmRequest.Builder tools(Map<String, BaseTool> tools) {
      if (tools == null) {
        throw new NullPointerException("Null tools");
      }
      this.tools = tools;
      return this;
    }
    @Override
    Map<String, BaseTool> tools() {
      if (this.tools == null) {
        throw new IllegalStateException("Property \"tools\" has not been set");
      }
      return tools;
    }
    @Override
    public LlmRequest build() {
      if (this.contents == null
          || this.liveConnectConfig == null
          || this.tools == null) {
        StringBuilder missing = new StringBuilder();
        if (this.contents == null) {
          missing.append(" contents");
        }
        if (this.liveConnectConfig == null) {
          missing.append(" liveConnectConfig");
        }
        if (this.tools == null) {
          missing.append(" tools");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LlmRequest(
          this.model,
          this.contents,
          this.config,
          this.liveConnectConfig,
          this.tools);
    }
  }

}
