/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.CallbackUtil;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;

public class SequentialAgent
extends BaseAgent {
    private SequentialAgent(String name, String description, List<? extends BaseAgent> subAgents, List<Callbacks.BeforeAgentCallback> beforeAgentCallback, List<Callbacks.AfterAgentCallback> afterAgentCallback) {
        super(name, description, subAgents, beforeAgentCallback, afterAgentCallback);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Flowable<Event> runAsyncImpl(InvocationContext invocationContext) {
        return Flowable.fromIterable(this.subAgents()).concatMap(subAgent -> subAgent.runAsync(invocationContext));
    }

    @Override
    protected Flowable<Event> runLiveImpl(InvocationContext invocationContext) {
        return Flowable.fromIterable(this.subAgents()).concatMap(subAgent -> subAgent.runLive(invocationContext));
    }

    public static class Builder {
        private String name;
        private String description;
        private List<? extends BaseAgent> subAgents;
        private ImmutableList<Callbacks.BeforeAgentCallback> beforeAgentCallback;
        private ImmutableList<Callbacks.AfterAgentCallback> afterAgentCallback;

        @CanIgnoreReturnValue
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder subAgents(List<? extends BaseAgent> subAgents) {
            this.subAgents = subAgents;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder subAgents(BaseAgent ... subAgents) {
            this.subAgents = ImmutableList.copyOf((Object[])subAgents);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeAgentCallback(Callbacks.BeforeAgentCallback beforeAgentCallback) {
            this.beforeAgentCallback = ImmutableList.of((Object)beforeAgentCallback);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeAgentCallback(List<Callbacks.BeforeAgentCallbackBase> beforeAgentCallback) {
            this.beforeAgentCallback = CallbackUtil.getBeforeAgentCallbacks(beforeAgentCallback);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterAgentCallback(Callbacks.AfterAgentCallback afterAgentCallback) {
            this.afterAgentCallback = ImmutableList.of((Object)afterAgentCallback);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterAgentCallback(List<Callbacks.AfterAgentCallbackBase> afterAgentCallback) {
            this.afterAgentCallback = CallbackUtil.getAfterAgentCallbacks(afterAgentCallback);
            return this;
        }

        public SequentialAgent build() {
            return new SequentialAgent(this.name, this.description, this.subAgents, (List<Callbacks.BeforeAgentCallback>)this.beforeAgentCallback, (List<Callbacks.AfterAgentCallback>)this.afterAgentCallback);
        }
    }
}

