/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.runner;

import com.google.adk.Telemetry;
import com.google.adk.agents.ActiveStreamingTool;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LiveRequestQueue;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.RunConfig;
import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.events.Event;
import com.google.adk.memory.BaseMemoryService;
import com.google.adk.plugins.BasePlugin;
import com.google.adk.plugins.PluginManager;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.Session;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionTool;
import com.google.adk.utils.CollectionUtils;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.InlineMe;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.Content;
import com.google.genai.types.Modality;
import com.google.genai.types.Part;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;

public class Runner {
    private final BaseAgent agent;
    private final String appName;
    private final BaseArtifactService artifactService;
    private final BaseSessionService sessionService;
    @Nullable
    private final BaseMemoryService memoryService;
    private final PluginManager pluginManager;

    public Runner(BaseAgent agent, String appName, BaseArtifactService artifactService, BaseSessionService sessionService, @Nullable BaseMemoryService memoryService) {
        this(agent, appName, artifactService, sessionService, memoryService, (List<BasePlugin>)ImmutableList.of());
    }

    public Runner(BaseAgent agent, String appName, BaseArtifactService artifactService, BaseSessionService sessionService, @Nullable BaseMemoryService memoryService, List<BasePlugin> plugins) {
        this.agent = agent;
        this.appName = appName;
        this.artifactService = artifactService;
        this.sessionService = sessionService;
        this.memoryService = memoryService;
        this.pluginManager = new PluginManager(plugins);
    }

    @Deprecated
    @InlineMe(replacement="this(agent, appName, artifactService, sessionService, null)")
    public Runner(BaseAgent agent, String appName, BaseArtifactService artifactService, BaseSessionService sessionService) {
        this(agent, appName, artifactService, sessionService, null);
    }

    public BaseAgent agent() {
        return this.agent;
    }

    public String appName() {
        return this.appName;
    }

    public BaseArtifactService artifactService() {
        return this.artifactService;
    }

    public BaseSessionService sessionService() {
        return this.sessionService;
    }

    @Nullable
    public BaseMemoryService memoryService() {
        return this.memoryService;
    }

    public PluginManager pluginManager() {
        return this.pluginManager;
    }

    private Single<Event> appendNewMessageToSession(Session session, Content newMessage, InvocationContext invocationContext, boolean saveInputBlobsAsArtifacts) {
        if (newMessage.parts().isEmpty()) {
            throw new IllegalArgumentException("No parts in the new_message.");
        }
        if (this.artifactService != null && saveInputBlobsAsArtifacts) {
            for (int i = 0; i < ((List)newMessage.parts().get()).size(); ++i) {
                Part part = (Part)((List)newMessage.parts().get()).get(i);
                if (part.inlineData().isEmpty()) continue;
                String fileName = "artifact_" + invocationContext.invocationId() + "_" + i;
                Single<Integer> unused = this.artifactService.saveArtifact(this.appName, session.userId(), session.id(), fileName, part);
                ((List)newMessage.parts().get()).set(i, Part.fromText((String)("Uploaded file: " + fileName + ". It has been saved to the artifacts")));
            }
        }
        Event event = Event.builder().id(Event.generateEventId()).invocationId(invocationContext.invocationId()).author("user").content(Optional.of(newMessage)).build();
        return this.sessionService.appendEvent(session, event);
    }

    public Flowable<Event> runAsync(String userId, String sessionId, Content newMessage, RunConfig runConfig) {
        Maybe<Session> maybeSession = this.sessionService.getSession(this.appName, userId, sessionId, Optional.empty());
        return maybeSession.switchIfEmpty((SingleSource)Single.error((Throwable)new IllegalArgumentException(String.format("Session not found: %s for user %s", sessionId, userId)))).flatMapPublisher(session -> this.runAsync((Session)session, newMessage, runConfig));
    }

    public Flowable<Event> runAsync(String userId, String sessionId, Content newMessage) {
        return this.runAsync(userId, sessionId, newMessage, RunConfig.builder().build());
    }

    public Flowable<Event> runAsync(Session session, Content newMessage, RunConfig runConfig) {
        Flowable flowable;
        block8: {
            Span span = Telemetry.getTracer().spanBuilder("invocation").startSpan();
            Scope scope = span.makeCurrent();
            try {
                BaseAgent rootAgent = this.agent;
                InvocationContext context = this.newInvocationContext(session, Optional.of(newMessage), Optional.empty(), runConfig);
                Maybe beforeRunEvent = this.pluginManager.runBeforeRunCallback(context).map(content -> Event.builder().id(Event.generateEventId()).invocationId(context.invocationId()).author("model").content(Optional.of(content)).build());
                Flowable agentEvents = Flowable.defer(() -> this.pluginManager.runOnUserMessageCallback(context, newMessage).switchIfEmpty((SingleSource)Single.just((Object)newMessage)).flatMap(content -> content != null ? this.appendNewMessageToSession(session, (Content)content, context, runConfig.saveInputBlobsAsArtifacts()) : Single.just(null)).flatMapPublisher(event -> {
                    InvocationContext contextWithNewMessage = this.newInvocationContext(session, event.content(), Optional.empty(), runConfig);
                    contextWithNewMessage.agent(this.findAgentToRun(session, rootAgent));
                    return contextWithNewMessage.agent().runAsync(contextWithNewMessage).flatMap(agentEvent -> this.sessionService.appendEvent(session, (Event)agentEvent).flatMap(registeredEvent -> contextWithNewMessage.pluginManager().runOnEventCallback(contextWithNewMessage, (Event)registeredEvent).defaultIfEmpty(registeredEvent)).toFlowable());
                }));
                flowable = beforeRunEvent.toFlowable().switchIfEmpty((Publisher)agentEvents).concatWith((CompletableSource)Completable.defer(() -> this.pluginManager.runAfterRunCallback(context))).doOnError(throwable -> {
                    span.setStatus(StatusCode.ERROR, "Error in runAsync Flowable execution");
                    span.recordException(throwable);
                }).doFinally(() -> ((Span)span).end());
                if (scope == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    }
                    throw throwable2;
                }
                catch (Throwable t) {
                    span.setStatus(StatusCode.ERROR, "Error during runAsync synchronous setup");
                    span.recordException(t);
                    span.end();
                    return Flowable.error((Throwable)t);
                }
            }
            scope.close();
        }
        return flowable;
    }

    private InvocationContext newInvocationContextForLive(Session session, Optional<LiveRequestQueue> liveRequestQueue, RunConfig runConfig) {
        RunConfig.Builder runConfigBuilder = RunConfig.builder(runConfig);
        if (!CollectionUtils.isNullOrEmpty(runConfig.responseModalities()) && liveRequestQueue.isPresent()) {
            if (CollectionUtils.isNullOrEmpty(runConfig.responseModalities())) {
                runConfigBuilder.setResponseModalities((Iterable<Modality>)ImmutableList.of((Object)new Modality(Modality.Known.AUDIO)));
                if (runConfig.outputAudioTranscription() == null) {
                    runConfigBuilder.setOutputAudioTranscription(AudioTranscriptionConfig.builder().build());
                }
            } else if (!runConfig.responseModalities().contains((Object)new Modality(Modality.Known.TEXT)) && runConfig.outputAudioTranscription() == null) {
                runConfigBuilder.setOutputAudioTranscription(AudioTranscriptionConfig.builder().build());
            }
        }
        return this.newInvocationContext(session, Optional.empty(), liveRequestQueue, runConfigBuilder.build());
    }

    private InvocationContext newInvocationContext(Session session, Optional<Content> newMessage, Optional<LiveRequestQueue> liveRequestQueue, RunConfig runConfig) {
        BaseAgent rootAgent = this.agent;
        InvocationContext invocationContext = new InvocationContext(this.sessionService, this.artifactService, this.memoryService, this.pluginManager, liveRequestQueue, Optional.empty(), InvocationContext.newInvocationContextId(), rootAgent, session, newMessage, runConfig, false);
        invocationContext.agent(this.findAgentToRun(session, rootAgent));
        return invocationContext;
    }

    public Flowable<Event> runLive(Session session, LiveRequestQueue liveRequestQueue, RunConfig runConfig) {
        Flowable flowable;
        block11: {
            Span span = Telemetry.getTracer().spanBuilder("invocation").startSpan();
            Scope scope = span.makeCurrent();
            try {
                InvocationContext invocationContext = this.newInvocationContextForLive(session, Optional.of(liveRequestQueue), runConfig);
                if (invocationContext.agent() instanceof LlmAgent) {
                    LlmAgent agent = (LlmAgent)invocationContext.agent();
                    for (BaseTool tool : agent.tools()) {
                        if (!(tool instanceof FunctionTool)) continue;
                        FunctionTool functionTool = (FunctionTool)tool;
                        for (Parameter parameter : functionTool.func().getParameters()) {
                            if (!parameter.getType().equals(LiveRequestQueue.class)) continue;
                            invocationContext.activeStreamingTools().put(functionTool.name(), new ActiveStreamingTool(new LiveRequestQueue()));
                        }
                    }
                }
                flowable = invocationContext.agent().runLive(invocationContext).doOnNext(event -> this.sessionService.appendEvent(session, (Event)event)).doOnError(throwable -> {
                    span.setStatus(StatusCode.ERROR, "Error in runLive Flowable execution");
                    span.recordException(throwable);
                }).doFinally(() -> ((Span)span).end());
                if (scope == null) break block11;
            }
            catch (Throwable throwable2) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    }
                    throw throwable2;
                }
                catch (Throwable t) {
                    span.setStatus(StatusCode.ERROR, "Error during runLive synchronous setup");
                    span.recordException(t);
                    span.end();
                    return Flowable.error((Throwable)t);
                }
            }
            scope.close();
        }
        return flowable;
    }

    public Flowable<Event> runLive(String userId, String sessionId, LiveRequestQueue liveRequestQueue, RunConfig runConfig) {
        return this.sessionService.getSession(this.appName, userId, sessionId, Optional.empty()).flatMapPublisher(session -> {
            if (session == null) {
                return Flowable.error((Throwable)new IllegalArgumentException(String.format("Session not found: %s for user %s", sessionId, userId)));
            }
            return this.runLive((Session)session, liveRequestQueue, runConfig);
        });
    }

    public Flowable<Event> runWithSessionId(String sessionId, Content newMessage, RunConfig runConfig) {
        return this.runAsync("tmp-user", sessionId, newMessage, runConfig);
    }

    private boolean isTransferableAcrossAgentTree(BaseAgent agentToRun) {
        for (BaseAgent current = agentToRun; current != null; current = current.parentAgent()) {
            if (!(current instanceof LlmAgent)) {
                return false;
            }
            LlmAgent agent = (LlmAgent)current;
            if (!agent.disallowTransferToParent()) continue;
            return false;
        }
        return true;
    }

    private BaseAgent findAgentToRun(Session session, BaseAgent rootAgent) {
        ArrayList<Event> events = new ArrayList<Event>(session.events());
        Collections.reverse(events);
        for (Event event : events) {
            String author = event.author();
            if (author.equals("user")) continue;
            if (author.equals(rootAgent.name())) {
                return rootAgent;
            }
            BaseAgent agent = rootAgent.findSubAgent(author);
            if (agent == null || !this.isTransferableAcrossAgentTree(agent)) continue;
            return agent;
        }
        return rootAgent;
    }
}

