/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.filamat;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.filamat.MaterialPackage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class MaterialBuilder {
    private final BuilderFinalizer mFinalizer;
    private final long mNativeObject = MaterialBuilder.nCreateMaterialBuilder();
    private static Class<?> sEngineClass = null;
    private static Method sGetNativeJobSystemMethod = null;

    public static void init() {
        MaterialBuilder.nMaterialBuilderInit();
    }

    public static void shutdown() {
        MaterialBuilder.nMaterialBuilderShutdown();
    }

    public MaterialBuilder() {
        this.mFinalizer = new BuilderFinalizer(this.mNativeObject);
    }

    @NonNull
    public MaterialBuilder name(@NonNull String name) {
        MaterialBuilder.nMaterialBuilderName(this.mNativeObject, name);
        return this;
    }

    @NonNull
    public MaterialBuilder materialDomain(MaterialDomain domain) {
        MaterialBuilder.nMaterialBuilderMaterialDomain(this.mNativeObject, domain.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder shading(@NonNull Shading shading) {
        MaterialBuilder.nMaterialBuilderShading(this.mNativeObject, shading.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder interpolation(@NonNull Interpolation interpolation) {
        MaterialBuilder.nMaterialBuilderInterpolation(this.mNativeObject, interpolation.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder uniformParameter(@NonNull UniformType type, String name) {
        MaterialBuilder.nMaterialBuilderUniformParameter(this.mNativeObject, type.ordinal(), ParameterPrecision.DEFAULT.ordinal(), name);
        return this;
    }

    @NonNull
    public MaterialBuilder uniformParameter(@NonNull UniformType type, ParameterPrecision precision, String name) {
        MaterialBuilder.nMaterialBuilderUniformParameter(this.mNativeObject, type.ordinal(), precision.ordinal(), name);
        return this;
    }

    @NonNull
    public MaterialBuilder uniformParameterArray(@NonNull UniformType type, int size, String name) {
        MaterialBuilder.nMaterialBuilderUniformParameterArray(this.mNativeObject, type.ordinal(), size, ParameterPrecision.DEFAULT.ordinal(), name);
        return this;
    }

    @NonNull
    public MaterialBuilder uniformParameterArray(@NonNull UniformType type, int size, ParameterPrecision precision, String name) {
        MaterialBuilder.nMaterialBuilderUniformParameterArray(this.mNativeObject, type.ordinal(), size, precision.ordinal(), name);
        return this;
    }

    @NonNull
    public MaterialBuilder samplerParameter(@NonNull SamplerType type, SamplerFormat format, ParameterPrecision precision, String name) {
        MaterialBuilder.nMaterialBuilderSamplerParameter(this.mNativeObject, type.ordinal(), format.ordinal(), precision.ordinal(), name);
        return this;
    }

    @NonNull
    public MaterialBuilder variable(@NonNull Variable variable, String name) {
        MaterialBuilder.nMaterialBuilderVariable(this.mNativeObject, variable.ordinal(), name);
        return this;
    }

    @NonNull
    public MaterialBuilder require(@NonNull VertexAttribute attribute) {
        MaterialBuilder.nMaterialBuilderRequire(this.mNativeObject, attribute.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder material(@NonNull String code) {
        MaterialBuilder.nMaterialBuilderMaterial(this.mNativeObject, code);
        return this;
    }

    @NonNull
    public MaterialBuilder materialVertex(@NonNull String code) {
        MaterialBuilder.nMaterialBuilderMaterialVertex(this.mNativeObject, code);
        return this;
    }

    @NonNull
    public MaterialBuilder blending(@NonNull BlendingMode mode) {
        MaterialBuilder.nMaterialBuilderBlending(this.mNativeObject, mode.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder postLightingBlending(@NonNull BlendingMode mode) {
        MaterialBuilder.nMaterialBuilderPostLightingBlending(this.mNativeObject, mode.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder vertexDomain(@NonNull VertexDomain vertexDomain) {
        MaterialBuilder.nMaterialBuilderVertexDomain(this.mNativeObject, vertexDomain.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder culling(@NonNull CullingMode mode) {
        MaterialBuilder.nMaterialBuilderCulling(this.mNativeObject, mode.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder colorWrite(boolean enable) {
        MaterialBuilder.nMaterialBuilderColorWrite(this.mNativeObject, enable);
        return this;
    }

    @NonNull
    public MaterialBuilder depthWrite(boolean enable) {
        MaterialBuilder.nMaterialBuilderDepthWrite(this.mNativeObject, enable);
        return this;
    }

    @NonNull
    public MaterialBuilder depthCulling(boolean enable) {
        MaterialBuilder.nMaterialBuilderDepthCulling(this.mNativeObject, enable);
        return this;
    }

    @NonNull
    public MaterialBuilder doubleSided(boolean doubleSided) {
        MaterialBuilder.nMaterialBuilderDoubleSided(this.mNativeObject, doubleSided);
        return this;
    }

    @NonNull
    public MaterialBuilder maskThreshold(float threshold) {
        MaterialBuilder.nMaterialBuilderMaskThreshold(this.mNativeObject, threshold);
        return this;
    }

    @NonNull
    public MaterialBuilder alphaToCoverage(boolean enable) {
        MaterialBuilder.nMaterialBuilderAlphaToCoverage(this.mNativeObject, enable);
        return this;
    }

    @NonNull
    public MaterialBuilder shadowMultiplier(boolean shadowMultiplier) {
        MaterialBuilder.nMaterialBuilderShadowMultiplier(this.mNativeObject, shadowMultiplier);
        return this;
    }

    @NonNull
    public MaterialBuilder transparentShadow(boolean transparentShadow) {
        MaterialBuilder.nMaterialBuilderTransparentShadow(this.mNativeObject, transparentShadow);
        return this;
    }

    @NonNull
    public MaterialBuilder specularAntiAliasing(boolean specularAntiAliasing) {
        MaterialBuilder.nMaterialBuilderSpecularAntiAliasing(this.mNativeObject, specularAntiAliasing);
        return this;
    }

    @NonNull
    public MaterialBuilder specularAntiAliasingVariance(float variance) {
        MaterialBuilder.nMaterialBuilderSpecularAntiAliasingVariance(this.mNativeObject, variance);
        return this;
    }

    @NonNull
    public MaterialBuilder specularAntiAliasingThreshold(float threshold) {
        MaterialBuilder.nMaterialBuilderSpecularAntiAliasingThreshold(this.mNativeObject, threshold);
        return this;
    }

    @NonNull
    public MaterialBuilder refractionMode(RefractionMode mode) {
        MaterialBuilder.nMaterialBuilderRefractionMode(this.mNativeObject, mode.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder refractionType(RefractionType type) {
        MaterialBuilder.nMaterialBuilderRefractionType(this.mNativeObject, type.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder clearCoatIorChange(boolean clearCoatIorChange) {
        MaterialBuilder.nMaterialBuilderClearCoatIorChange(this.mNativeObject, clearCoatIorChange);
        return this;
    }

    @NonNull
    public MaterialBuilder flipUV(boolean flipUV) {
        MaterialBuilder.nMaterialBuilderFlipUV(this.mNativeObject, flipUV);
        return this;
    }

    @NonNull
    public MaterialBuilder customSurfaceShading(boolean customSurfaceShading) {
        MaterialBuilder.nMaterialBuilderCustomSurfaceShading(this.mNativeObject, customSurfaceShading);
        return this;
    }

    @NonNull
    public MaterialBuilder multiBounceAmbientOcclusion(boolean multiBounceAO) {
        MaterialBuilder.nMaterialBuilderMultiBounceAmbientOcclusion(this.mNativeObject, multiBounceAO);
        return this;
    }

    @NonNull
    public MaterialBuilder specularAmbientOcclusion(SpecularAmbientOcclusion specularAO) {
        MaterialBuilder.nMaterialBuilderSpecularAmbientOcclusion(this.mNativeObject, specularAO.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder transparencyMode(@NonNull TransparencyMode mode) {
        MaterialBuilder.nMaterialBuilderTransparencyMode(this.mNativeObject, mode.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder platform(@NonNull Platform platform) {
        MaterialBuilder.nMaterialBuilderPlatform(this.mNativeObject, platform.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder targetApi(@NonNull TargetApi api) {
        MaterialBuilder.nMaterialBuilderTargetApi(this.mNativeObject, api.number);
        return this;
    }

    @NonNull
    public MaterialBuilder optimization(@NonNull Optimization optimization) {
        MaterialBuilder.nMaterialBuilderOptimization(this.mNativeObject, optimization.ordinal());
        return this;
    }

    @NonNull
    public MaterialBuilder variantFilter(int variantFilter) {
        MaterialBuilder.nMaterialBuilderVariantFilter(this.mNativeObject, variantFilter);
        this.useLegacyMorphing();
        return this;
    }

    @NonNull
    public MaterialBuilder useLegacyMorphing() {
        MaterialBuilder.nMaterialBuilderUseLegacyMorphing(this.mNativeObject);
        return this;
    }

    @NonNull
    public MaterialPackage build() {
        return this.build(null);
    }

    @NonNull
    public MaterialPackage build(@Nullable Object jobSystemProvider) {
        long nativeJobSystem = 0L;
        if (jobSystemProvider != null && sEngineClass != null && sEngineClass.isInstance(jobSystemProvider) && sGetNativeJobSystemMethod != null) {
            try {
                nativeJobSystem = (Long)sGetNativeJobSystemMethod.invoke(jobSystemProvider, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        long nativePackage = MaterialBuilder.nBuilderBuild(this.mNativeObject, nativeJobSystem);
        byte[] data = MaterialBuilder.nGetPackageBytes(nativePackage);
        MaterialPackage result = new MaterialPackage(ByteBuffer.wrap(data), MaterialBuilder.nGetPackageIsValid(nativePackage));
        MaterialBuilder.nDestroyPackage(nativePackage);
        return result;
    }

    private static native void nMaterialBuilderInit();

    private static native void nMaterialBuilderShutdown();

    private static native long nCreateMaterialBuilder();

    private static native void nDestroyMaterialBuilder(long var0);

    private static native long nBuilderBuild(long var0, long var2);

    private static native byte[] nGetPackageBytes(long var0);

    private static native boolean nGetPackageIsValid(long var0);

    private static native void nDestroyPackage(long var0);

    private static native void nMaterialBuilderName(long var0, String var2);

    private static native void nMaterialBuilderMaterialDomain(long var0, int var2);

    private static native void nMaterialBuilderShading(long var0, int var2);

    private static native void nMaterialBuilderInterpolation(long var0, int var2);

    private static native void nMaterialBuilderUniformParameter(long var0, int var2, int var3, String var4);

    private static native void nMaterialBuilderUniformParameterArray(long var0, int var2, int var3, int var4, String var5);

    private static native void nMaterialBuilderSamplerParameter(long var0, int var2, int var3, int var4, String var5);

    private static native void nMaterialBuilderVariable(long var0, int var2, String var3);

    private static native void nMaterialBuilderRequire(long var0, int var2);

    private static native void nMaterialBuilderMaterial(long var0, String var2);

    private static native void nMaterialBuilderMaterialVertex(long var0, String var2);

    private static native void nMaterialBuilderBlending(long var0, int var2);

    private static native void nMaterialBuilderPostLightingBlending(long var0, int var2);

    private static native void nMaterialBuilderVertexDomain(long var0, int var2);

    private static native void nMaterialBuilderCulling(long var0, int var2);

    private static native void nMaterialBuilderColorWrite(long var0, boolean var2);

    private static native void nMaterialBuilderDepthWrite(long var0, boolean var2);

    private static native void nMaterialBuilderDepthCulling(long var0, boolean var2);

    private static native void nMaterialBuilderDoubleSided(long var0, boolean var2);

    private static native void nMaterialBuilderMaskThreshold(long var0, float var2);

    private static native void nMaterialBuilderAlphaToCoverage(long var0, boolean var2);

    private static native void nMaterialBuilderShadowMultiplier(long var0, boolean var2);

    private static native void nMaterialBuilderTransparentShadow(long var0, boolean var2);

    private static native void nMaterialBuilderSpecularAntiAliasing(long var0, boolean var2);

    private static native void nMaterialBuilderSpecularAntiAliasingVariance(long var0, float var2);

    private static native void nMaterialBuilderSpecularAntiAliasingThreshold(long var0, float var2);

    private static native void nMaterialBuilderRefractionMode(long var0, int var2);

    private static native void nMaterialBuilderRefractionType(long var0, int var2);

    private static native void nMaterialBuilderClearCoatIorChange(long var0, boolean var2);

    private static native void nMaterialBuilderFlipUV(long var0, boolean var2);

    private static native void nMaterialBuilderCustomSurfaceShading(long var0, boolean var2);

    private static native void nMaterialBuilderMultiBounceAmbientOcclusion(long var0, boolean var2);

    private static native void nMaterialBuilderSpecularAmbientOcclusion(long var0, int var2);

    private static native void nMaterialBuilderTransparencyMode(long var0, int var2);

    private static native void nMaterialBuilderPlatform(long var0, int var2);

    private static native void nMaterialBuilderTargetApi(long var0, int var2);

    private static native void nMaterialBuilderOptimization(long var0, int var2);

    private static native void nMaterialBuilderVariantFilter(long var0, int var2);

    private static native void nMaterialBuilderUseLegacyMorphing(long var0);

    static {
        System.loadLibrary("filamat-jni");
        try {
            sEngineClass = Class.forName("com.google.android.filament.Engine");
            sGetNativeJobSystemMethod = sEngineClass.getDeclaredMethod("getNativeJobSystem", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static class BuilderFinalizer {
        private final long mNativeObject;

        BuilderFinalizer(long nativeObject) {
            this.mNativeObject = nativeObject;
        }

        public void finalize() {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
            }
            finally {
                MaterialBuilder.nDestroyMaterialBuilder(this.mNativeObject);
            }
        }
    }

    public static enum Optimization {
        NONE,
        PREPROCESSOR,
        SIZE,
        PERFORMANCE;

    }

    public static enum TargetApi {
        OPENGL(1),
        VULKAN(2),
        METAL(4),
        ALL(7);

        final int number;

        private TargetApi(int number) {
            this.number = number;
        }
    }

    public static enum Platform {
        DESKTOP,
        MOBILE,
        ALL;

    }

    public static enum RefractionType {
        SOLID,
        THIN;

    }

    public static enum RefractionMode {
        NONE,
        CUBEMAP,
        SCREEN_SPACE;

    }

    public static enum SpecularAmbientOcclusion {
        NONE,
        SIMPLE,
        BENT_NORMALS;

    }

    public static enum MaterialDomain {
        SURFACE,
        POST_PROCESS;

    }

    public static enum TransparencyMode {
        DEFAULT,
        TWO_PASSES_ONE_SIDE,
        TWO_PASSES_TWO_SIDES;

    }

    public static enum CullingMode {
        NONE,
        FRONT,
        BACK,
        FRONT_AND_BACK;

    }

    public static enum VertexDomain {
        OBJECT,
        WORLD,
        VIEW,
        DEVICE;

    }

    public static enum BlendingMode {
        OPAQUE,
        TRANSPARENT,
        ADD,
        MASKED,
        FADE,
        MULTIPLY,
        SCREEN;

    }

    public static enum VertexAttribute {
        POSITION,
        TANGENTS,
        COLOR,
        UV0,
        UV1,
        BONE_INDICES,
        BONE_WEIGHTS,
        UNUSED,
        CUSTOM0,
        CUSTOM1,
        CUSTOM2,
        CUSTOM3,
        CUSTOM4,
        CUSTOM5,
        CUSTOM6,
        CUSTOM7;

    }

    public static enum Variable {
        CUSTOM0,
        CUSTOM1,
        CUSTOM2,
        CUSTOM3;

    }

    public static enum ParameterPrecision {
        LOW,
        MEDIUM,
        HIGH,
        DEFAULT;

    }

    public static enum SamplerFormat {
        INT,
        UINT,
        FLOAT,
        SHADOW;

    }

    public static enum SamplerType {
        SAMPLER_2D,
        SAMPLER_2D_ARRAY,
        SAMPLER_CUBEMAP,
        SAMPLER_EXTERNAL,
        SAMPLER_3D;

    }

    public static enum UniformType {
        BOOL,
        BOOL2,
        BOOL3,
        BOOL4,
        FLOAT,
        FLOAT2,
        FLOAT3,
        FLOAT4,
        INT,
        INT2,
        INT3,
        INT4,
        UINT,
        UINT2,
        UINT3,
        UINT4,
        MAT3,
        MAT4;

    }

    public static enum Interpolation {
        SMOOTH,
        FLAT;

    }

    public static enum Shading {
        UNLIT,
        LIT,
        SUBSURFACE,
        CLOTH,
        SPECULAR_GLOSSINESS;

    }
}

