/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.Asserts;
import com.google.android.filament.Entity;

public class Camera {
    private long mNativeObject;
    @Entity
    private final int mEntity;

    Camera(long nativeCamera, @Entity int entity) {
        this.mNativeObject = nativeCamera;
        this.mEntity = entity;
    }

    public void setProjection(@NonNull Projection projection, double left, double right, double bottom, double top, double near, double far) {
        Camera.nSetProjection(this.getNativeObject(), projection.ordinal(), left, right, bottom, top, near, far);
    }

    public void setProjection(double fovInDegrees, double aspect, double near, double far, @NonNull Fov direction) {
        Camera.nSetProjectionFov(this.getNativeObject(), fovInDegrees, aspect, near, far, direction.ordinal());
    }

    public void setLensProjection(double focalLength, double aspect, double near, double far) {
        Camera.nSetLensProjection(this.getNativeObject(), focalLength, aspect, near, far);
    }

    public void setCustomProjection(@NonNull @Size(min=16L) double[] inProjection, double near, double far) {
        Asserts.assertMat4dIn(inProjection);
        Camera.nSetCustomProjection(this.getNativeObject(), inProjection, inProjection, near, far);
    }

    public void setCustomProjection(@NonNull @Size(min=16L) double[] inProjection, @NonNull @Size(min=16L) double[] inProjectionForCulling, double near, double far) {
        Asserts.assertMat4dIn(inProjection);
        Asserts.assertMat4dIn(inProjectionForCulling);
        Camera.nSetCustomProjection(this.getNativeObject(), inProjection, inProjectionForCulling, near, far);
    }

    public void setScaling(double xscaling, double yscaling) {
        Camera.nSetScaling(this.getNativeObject(), xscaling, yscaling);
    }

    @Deprecated
    public void setScaling(@NonNull @Size(min=4L) double[] inScaling) {
        Asserts.assertDouble4In(inScaling);
        this.setScaling(inScaling[0], inScaling[1]);
    }

    public void setShift(double xshift, double yshift) {
        Camera.nSetShift(this.getNativeObject(), xshift, yshift);
    }

    public void setModelMatrix(@NonNull @Size(min=16L) float[] modelMatrix) {
        Asserts.assertMat4fIn(modelMatrix);
        Camera.nSetModelMatrix(this.getNativeObject(), modelMatrix);
    }

    public void setModelMatrix(@NonNull @Size(min=16L) double[] modelMatrix) {
        Asserts.assertMat4In(modelMatrix);
        Camera.nSetModelMatrixFp64(this.getNativeObject(), modelMatrix);
    }

    public void lookAt(double eyeX, double eyeY, double eyeZ, double centerX, double centerY, double centerZ, double upX, double upY, double upZ) {
        Camera.nLookAt(this.getNativeObject(), eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
    }

    public float getNear() {
        return (float)Camera.nGetNear(this.getNativeObject());
    }

    public float getCullingFar() {
        return (float)Camera.nGetCullingFar(this.getNativeObject());
    }

    @NonNull
    @Size(min=16L)
    public double[] getProjectionMatrix(@Nullable @Size(min=16L) double[] out) {
        out = Asserts.assertMat4d(out);
        Camera.nGetProjectionMatrix(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=16L)
    public double[] getCullingProjectionMatrix(@Nullable @Size(min=16L) double[] out) {
        out = Asserts.assertMat4d(out);
        Camera.nGetCullingProjectionMatrix(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=4L)
    public double[] getScaling(@Nullable @Size(min=4L) double[] out) {
        out = Asserts.assertDouble4(out);
        Camera.nGetScaling(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=16L)
    public float[] getModelMatrix(@Nullable @Size(min=16L) float[] out) {
        out = Asserts.assertMat4f(out);
        Camera.nGetModelMatrix(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=16L)
    public double[] getModelMatrix(@Nullable @Size(min=16L) double[] out) {
        out = Asserts.assertMat4(out);
        Camera.nGetModelMatrixFp64(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=16L)
    public float[] getViewMatrix(@Nullable @Size(min=16L) float[] out) {
        out = Asserts.assertMat4f(out);
        Camera.nGetViewMatrix(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=16L)
    public double[] getViewMatrix(@Nullable @Size(min=16L) double[] out) {
        out = Asserts.assertMat4(out);
        Camera.nGetViewMatrixFp64(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=3L)
    public float[] getPosition(@Nullable @Size(min=3L) float[] out) {
        out = Asserts.assertFloat3(out);
        Camera.nGetPosition(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=3L)
    public float[] getLeftVector(@Nullable @Size(min=3L) float[] out) {
        out = Asserts.assertFloat3(out);
        Camera.nGetLeftVector(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=3L)
    public float[] getUpVector(@Nullable @Size(min=3L) float[] out) {
        out = Asserts.assertFloat3(out);
        Camera.nGetUpVector(this.getNativeObject(), out);
        return out;
    }

    @NonNull
    @Size(min=3L)
    public float[] getForwardVector(@Nullable @Size(min=3L) float[] out) {
        out = Asserts.assertFloat3(out);
        Camera.nGetForwardVector(this.getNativeObject(), out);
        return out;
    }

    public void setExposure(float aperture, float shutterSpeed, float sensitivity) {
        Camera.nSetExposure(this.getNativeObject(), aperture, shutterSpeed, sensitivity);
    }

    public void setExposure(float exposure) {
        this.setExposure(1.0f, 1.2f, 100.0f * (1.0f / exposure));
    }

    public float getAperture() {
        return Camera.nGetAperture(this.getNativeObject());
    }

    public float getShutterSpeed() {
        return Camera.nGetShutterSpeed(this.getNativeObject());
    }

    public double getFocalLength() {
        return Camera.nGetFocalLength(this.getNativeObject());
    }

    public void setFocusDistance(float distance) {
        Camera.nSetFocusDistance(this.getNativeObject(), distance);
    }

    public float getFocusDistance() {
        return Camera.nGetFocusDistance(this.getNativeObject());
    }

    public float getSensitivity() {
        return Camera.nGetSensitivity(this.getNativeObject());
    }

    @Entity
    public int getEntity() {
        return this.mEntity;
    }

    static double computeEffectiveFocalLength(double focalLength, double focusDistance) {
        return Camera.nComputeEffectiveFocalLength(focalLength, focusDistance);
    }

    static double computeEffectiveFov(double fovInDegrees, double focusDistance) {
        return Camera.nComputeEffectiveFov(fovInDegrees, focusDistance);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Camera");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nSetProjection(long var0, int var2, double var3, double var5, double var7, double var9, double var11, double var13);

    private static native void nSetProjectionFov(long var0, double var2, double var4, double var6, double var8, int var10);

    private static native void nSetLensProjection(long var0, double var2, double var4, double var6, double var8);

    private static native void nSetCustomProjection(long var0, double[] var2, double[] var3, double var4, double var6);

    private static native void nSetScaling(long var0, double var2, double var4);

    private static native void nSetShift(long var0, double var2, double var4);

    private static native void nSetModelMatrix(long var0, float[] var2);

    private static native void nSetModelMatrixFp64(long var0, double[] var2);

    private static native void nLookAt(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18);

    private static native double nGetNear(long var0);

    private static native double nGetCullingFar(long var0);

    private static native void nGetProjectionMatrix(long var0, double[] var2);

    private static native void nGetCullingProjectionMatrix(long var0, double[] var2);

    private static native void nGetScaling(long var0, double[] var2);

    private static native void nGetModelMatrix(long var0, float[] var2);

    private static native void nGetModelMatrixFp64(long var0, double[] var2);

    private static native void nGetViewMatrix(long var0, float[] var2);

    private static native void nGetViewMatrixFp64(long var0, double[] var2);

    private static native void nGetPosition(long var0, float[] var2);

    private static native void nGetLeftVector(long var0, float[] var2);

    private static native void nGetUpVector(long var0, float[] var2);

    private static native void nGetForwardVector(long var0, float[] var2);

    private static native void nSetExposure(long var0, float var2, float var3, float var4);

    private static native float nGetAperture(long var0);

    private static native float nGetShutterSpeed(long var0);

    private static native float nGetSensitivity(long var0);

    private static native void nSetFocusDistance(long var0, float var2);

    private static native float nGetFocusDistance(long var0);

    private static native double nGetFocalLength(long var0);

    private static native double nComputeEffectiveFocalLength(double var0, double var2);

    private static native double nComputeEffectiveFov(double var0, double var2);

    public static enum Fov {
        VERTICAL,
        HORIZONTAL;

    }

    public static enum Projection {
        PERSPECTIVE,
        ORTHO;

    }
}

