/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.NonNull;

public class Fence {
    private long mNativeObject;
    public static final long WAIT_FOR_EVER = -1L;

    Fence(long nativeFence) {
        this.mNativeObject = nativeFence;
    }

    public FenceStatus wait(@NonNull Mode mode, long timeoutNanoSeconds) {
        int nativeResult = Fence.nWait(this.getNativeObject(), mode.ordinal(), timeoutNanoSeconds);
        switch (nativeResult) {
            case -1: {
                return FenceStatus.ERROR;
            }
            case 0: {
                return FenceStatus.CONDITION_SATISFIED;
            }
            case 1: {
                return FenceStatus.TIMEOUT_EXPIRED;
            }
        }
        return FenceStatus.ERROR;
    }

    public static FenceStatus waitAndDestroy(@NonNull Fence fence, @NonNull Mode mode) {
        int nativeResult = Fence.nWaitAndDestroy(fence.getNativeObject(), mode.ordinal());
        switch (nativeResult) {
            case -1: {
                return FenceStatus.ERROR;
            }
            case 0: {
                return FenceStatus.CONDITION_SATISFIED;
            }
        }
        return FenceStatus.ERROR;
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Fence");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native int nWait(long var0, int var2, long var3);

    private static native int nWaitAndDestroy(long var0, int var2);

    public static enum FenceStatus {
        ERROR,
        CONDITION_SATISFIED,
        TIMEOUT_EXPIRED;

    }

    public static enum Mode {
        FLUSH,
        DONT_FLUSH;

    }
}

