/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Box;
import com.google.android.filament.Engine;
import com.google.android.filament.Entity;
import com.google.android.filament.EntityInstance;
import com.google.android.filament.IndexBuffer;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.MorphTargetBuffer;
import com.google.android.filament.Platform;
import com.google.android.filament.SkinningBuffer;
import com.google.android.filament.VertexBuffer;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class RenderableManager {
    private static final String LOG_TAG = "Filament";
    private static final VertexBuffer.VertexAttribute[] sVertexAttributeValues = VertexBuffer.VertexAttribute.values();
    private long mNativeObject;

    RenderableManager(long nativeRenderableManager) {
        this.mNativeObject = nativeRenderableManager;
    }

    public boolean hasComponent(@Entity int entity) {
        return RenderableManager.nHasComponent(this.mNativeObject, entity);
    }

    @EntityInstance
    public int getInstance(@Entity int entity) {
        return RenderableManager.nGetInstance(this.mNativeObject, entity);
    }

    public void destroy(@Entity int entity) {
        RenderableManager.nDestroy(this.mNativeObject, entity);
    }

    public void setSkinningBuffer(@EntityInstance int i, @NonNull SkinningBuffer skinningBuffer, int count, int offset) {
        RenderableManager.nSetSkinningBuffer(this.mNativeObject, i, skinningBuffer.getNativeObject(), count, offset);
    }

    public void setBonesAsMatrices(@EntityInstance int i, @NonNull Buffer matrices, @IntRange(from=0L, to=255L) int boneCount, @IntRange(from=0L) int offset) {
        int result = RenderableManager.nSetBonesAsMatrices(this.mNativeObject, i, matrices, matrices.remaining(), boneCount, offset);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void setBonesAsQuaternions(@EntityInstance int i, @NonNull Buffer quaternions, @IntRange(from=0L, to=255L) int boneCount, @IntRange(from=0L) int offset) {
        int result = RenderableManager.nSetBonesAsQuaternions(this.mNativeObject, i, quaternions, quaternions.remaining(), boneCount, offset);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void setMorphWeights(@EntityInstance int i, @NonNull float[] weights, @IntRange(from=0L) int offset) {
        RenderableManager.nSetMorphWeights(this.mNativeObject, i, weights, offset);
    }

    public void setMorphTargetBufferAt(@EntityInstance int i, @IntRange(from=0L) int level, @IntRange(from=0L) int primitiveIndex, @NonNull MorphTargetBuffer morphTargetBuffer, @IntRange(from=0L) int offset, @IntRange(from=0L) int count) {
        RenderableManager.nSetMorphTargetBufferAt(this.mNativeObject, i, level, primitiveIndex, morphTargetBuffer.getNativeObject(), offset, count);
    }

    public void setMorphTargetBufferAt(@EntityInstance int i, @IntRange(from=0L) int level, @IntRange(from=0L) int primitiveIndex, @NonNull MorphTargetBuffer morphTargetBuffer) {
        RenderableManager.nSetMorphTargetBufferAt(this.mNativeObject, i, level, primitiveIndex, morphTargetBuffer.getNativeObject(), 0, morphTargetBuffer.getVertexCount());
    }

    @IntRange(from=0L)
    public int getMorphTargetCount(@EntityInstance int i) {
        return RenderableManager.nGetMorphTargetCount(this.mNativeObject, i);
    }

    public void setAxisAlignedBoundingBox(@EntityInstance int i, @NonNull Box aabb) {
        RenderableManager.nSetAxisAlignedBoundingBox(this.mNativeObject, i, aabb.getCenter()[0], aabb.getCenter()[1], aabb.getCenter()[2], aabb.getHalfExtent()[0], aabb.getHalfExtent()[1], aabb.getHalfExtent()[2]);
    }

    public void setLayerMask(@EntityInstance int i, @IntRange(from=0L, to=255L) int select, @IntRange(from=0L, to=255L) int value) {
        RenderableManager.nSetLayerMask(this.mNativeObject, i, select, value);
    }

    public void setPriority(@EntityInstance int i, @IntRange(from=0L, to=7L) int priority) {
        RenderableManager.nSetPriority(this.mNativeObject, i, priority);
    }

    public void setCulling(@EntityInstance int i, boolean enabled) {
        RenderableManager.nSetCulling(this.mNativeObject, i, enabled);
    }

    public void setLightChannel(@EntityInstance int i, @IntRange(from=0L, to=7L) int channel, boolean enable) {
        RenderableManager.nSetLightChannel(this.mNativeObject, i, channel, enable);
    }

    public boolean getLightChannel(@EntityInstance int i, @IntRange(from=0L, to=7L) int channel) {
        return RenderableManager.nGetLightChannel(this.mNativeObject, i, channel);
    }

    public void setCastShadows(@EntityInstance int i, boolean enabled) {
        RenderableManager.nSetCastShadows(this.mNativeObject, i, enabled);
    }

    public void setReceiveShadows(@EntityInstance int i, boolean enabled) {
        RenderableManager.nSetReceiveShadows(this.mNativeObject, i, enabled);
    }

    public void setScreenSpaceContactShadows(@EntityInstance int i, boolean enabled) {
        RenderableManager.nSetScreenSpaceContactShadows(this.mNativeObject, i, enabled);
    }

    public boolean isShadowCaster(@EntityInstance int i) {
        return RenderableManager.nIsShadowCaster(this.mNativeObject, i);
    }

    public boolean isShadowReceiver(@EntityInstance int i) {
        return RenderableManager.nIsShadowReceiver(this.mNativeObject, i);
    }

    @NonNull
    public Box getAxisAlignedBoundingBox(@EntityInstance int i, @Nullable Box out) {
        if (out == null) {
            out = new Box();
        }
        RenderableManager.nGetAxisAlignedBoundingBox(this.mNativeObject, i, out.getCenter(), out.getHalfExtent());
        return out;
    }

    @IntRange(from=0L)
    public int getPrimitiveCount(@EntityInstance int i) {
        return RenderableManager.nGetPrimitiveCount(this.mNativeObject, i);
    }

    public void setMaterialInstanceAt(@EntityInstance int i, @IntRange(from=0L) int primitiveIndex, @NonNull MaterialInstance materialInstance) {
        int required = materialInstance.getMaterial().getRequiredAttributesAsInt();
        int declared = RenderableManager.nGetEnabledAttributesAt(this.mNativeObject, i, primitiveIndex);
        if ((declared & required) != required) {
            Platform.get().warn("setMaterialInstanceAt() on primitive " + primitiveIndex + " of Renderable at " + i + ": declared attributes " + this.getEnabledAttributesAt(i, primitiveIndex) + " do no satisfy required attributes " + materialInstance.getMaterial().getRequiredAttributes());
        }
        RenderableManager.nSetMaterialInstanceAt(this.mNativeObject, i, primitiveIndex, materialInstance.getNativeObject());
    }

    @NonNull
    public MaterialInstance getMaterialInstanceAt(@EntityInstance int i, @IntRange(from=0L) int primitiveIndex) {
        long nativeMatInstance = RenderableManager.nGetMaterialInstanceAt(this.mNativeObject, i, primitiveIndex);
        return new MaterialInstance(nativeMatInstance);
    }

    public void setGeometryAt(@EntityInstance int i, @IntRange(from=0L) int primitiveIndex, @NonNull PrimitiveType type, @NonNull VertexBuffer vertices, @NonNull IndexBuffer indices, @IntRange(from=0L) int offset, @IntRange(from=0L) int count) {
        RenderableManager.nSetGeometryAt(this.mNativeObject, i, primitiveIndex, type.getValue(), vertices.getNativeObject(), indices.getNativeObject(), offset, count);
    }

    public void setGeometryAt(@EntityInstance int i, @IntRange(from=0L) int primitiveIndex, @NonNull PrimitiveType type, @NonNull VertexBuffer vertices, @NonNull IndexBuffer indices) {
        RenderableManager.nSetGeometryAt(this.mNativeObject, i, primitiveIndex, type.getValue(), vertices.getNativeObject(), indices.getNativeObject(), 0, indices.getIndexCount());
    }

    public void setBlendOrderAt(@EntityInstance int instance, @IntRange(from=0L) int primitiveIndex, @IntRange(from=0L, to=65535L) int blendOrder) {
        RenderableManager.nSetBlendOrderAt(this.mNativeObject, instance, primitiveIndex, blendOrder);
    }

    public void setGlobalBlendOrderEnabledAt(@EntityInstance int instance, @IntRange(from=0L) int primitiveIndex, boolean enabled) {
        RenderableManager.nSetGlobalBlendOrderEnabledAt(this.mNativeObject, instance, primitiveIndex, enabled);
    }

    public Set<VertexBuffer.VertexAttribute> getEnabledAttributesAt(@EntityInstance int i, @IntRange(from=0L) int primitiveIndex) {
        int bitSet = RenderableManager.nGetEnabledAttributesAt(this.mNativeObject, i, primitiveIndex);
        Set<VertexBuffer.VertexAttribute> requiredAttributes = EnumSet.noneOf(VertexBuffer.VertexAttribute.class);
        VertexBuffer.VertexAttribute[] values = sVertexAttributeValues;
        for (int j = 0; j < values.length; ++j) {
            if ((bitSet & 1 << j) == 0) continue;
            requiredAttributes.add(values[j]);
        }
        requiredAttributes = Collections.unmodifiableSet(requiredAttributes);
        return requiredAttributes;
    }

    public long getNativeObject() {
        return this.mNativeObject;
    }

    private static native boolean nHasComponent(long var0, int var2);

    private static native int nGetInstance(long var0, int var2);

    private static native void nDestroy(long var0, int var2);

    private static native long nCreateBuilder(int var0);

    private static native void nDestroyBuilder(long var0);

    private static native boolean nBuilderBuild(long var0, long var2, int var4);

    private static native void nBuilderGeometry(long var0, int var2, int var3, long var4, long var6);

    private static native void nBuilderGeometry(long var0, int var2, int var3, long var4, long var6, int var8, int var9);

    private static native void nBuilderGeometry(long var0, int var2, int var3, long var4, long var6, int var8, int var9, int var10, int var11);

    private static native void nBuilderMaterial(long var0, int var2, long var3);

    private static native void nBuilderBlendOrder(long var0, int var2, int var3);

    private static native void nBuilderGlobalBlendOrderEnabled(long var0, int var2, boolean var3);

    private static native void nBuilderBoundingBox(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native void nBuilderLayerMask(long var0, int var2, int var3);

    private static native void nBuilderPriority(long var0, int var2);

    private static native void nBuilderCulling(long var0, boolean var2);

    private static native void nBuilderCastShadows(long var0, boolean var2);

    private static native void nBuilderReceiveShadows(long var0, boolean var2);

    private static native void nBuilderScreenSpaceContactShadows(long var0, boolean var2);

    private static native void nBuilderSkinning(long var0, int var2);

    private static native int nBuilderSkinningBones(long var0, int var2, Buffer var3, int var4);

    private static native void nBuilderSkinningBuffer(long var0, long var2, int var4, int var5);

    private static native void nBuilderMorphing(long var0, int var2);

    private static native void nBuilderSetMorphTargetBufferAt(long var0, int var2, int var3, long var4, int var6, int var7);

    private static native void nEnableSkinningBuffers(long var0, boolean var2);

    private static native void nBuilderLightChannel(long var0, int var2, boolean var3);

    private static native void nBuilderInstances(long var0, int var2);

    private static native void nSetSkinningBuffer(long var0, int var2, long var3, int var5, int var6);

    private static native int nSetBonesAsMatrices(long var0, int var2, Buffer var3, int var4, int var5, int var6);

    private static native int nSetBonesAsQuaternions(long var0, int var2, Buffer var3, int var4, int var5, int var6);

    private static native void nSetMorphWeights(long var0, int var2, float[] var3, int var4);

    private static native void nSetMorphTargetBufferAt(long var0, int var2, int var3, int var4, long var5, int var7, int var8);

    private static native int nGetMorphTargetCount(long var0, int var2);

    private static native void nSetAxisAlignedBoundingBox(long var0, int var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private static native void nSetLayerMask(long var0, int var2, int var3, int var4);

    private static native void nSetPriority(long var0, int var2, int var3);

    private static native void nSetCulling(long var0, int var2, boolean var3);

    private static native void nSetLightChannel(long var0, int var2, int var3, boolean var4);

    private static native boolean nGetLightChannel(long var0, int var2, int var3);

    private static native void nSetCastShadows(long var0, int var2, boolean var3);

    private static native void nSetReceiveShadows(long var0, int var2, boolean var3);

    private static native void nSetScreenSpaceContactShadows(long var0, int var2, boolean var3);

    private static native boolean nIsShadowCaster(long var0, int var2);

    private static native boolean nIsShadowReceiver(long var0, int var2);

    private static native void nGetAxisAlignedBoundingBox(long var0, int var2, float[] var3, float[] var4);

    private static native int nGetPrimitiveCount(long var0, int var2);

    private static native void nSetMaterialInstanceAt(long var0, int var2, int var3, long var4);

    private static native long nGetMaterialInstanceAt(long var0, int var2, int var3);

    private static native void nSetGeometryAt(long var0, int var2, int var3, int var4, long var5, long var7, int var9, int var10);

    private static native void nSetBlendOrderAt(long var0, int var2, int var3, int var4);

    private static native void nSetGlobalBlendOrderEnabledAt(long var0, int var2, int var3, boolean var4);

    private static native int nGetEnabledAttributesAt(long var0, int var2, int var3);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder;

        public Builder(@IntRange(from=1L) int count) {
            this.mNativeBuilder = RenderableManager.nCreateBuilder(count);
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder geometry(@IntRange(from=0L) int index, @NonNull PrimitiveType type, @NonNull VertexBuffer vertices, @NonNull IndexBuffer indices, @IntRange(from=0L) int offset, @IntRange(from=0L) int minIndex, @IntRange(from=0L) int maxIndex, @IntRange(from=0L) int count) {
            RenderableManager.nBuilderGeometry(this.mNativeBuilder, index, type.getValue(), vertices.getNativeObject(), indices.getNativeObject(), offset, minIndex, maxIndex, count);
            return this;
        }

        @NonNull
        public Builder geometry(@IntRange(from=0L) int index, @NonNull PrimitiveType type, @NonNull VertexBuffer vertices, @NonNull IndexBuffer indices, @IntRange(from=0L) int offset, @IntRange(from=0L) int count) {
            RenderableManager.nBuilderGeometry(this.mNativeBuilder, index, type.getValue(), vertices.getNativeObject(), indices.getNativeObject(), offset, count);
            return this;
        }

        @NonNull
        public Builder geometry(@IntRange(from=0L) int index, @NonNull PrimitiveType type, @NonNull VertexBuffer vertices, @NonNull IndexBuffer indices) {
            RenderableManager.nBuilderGeometry(this.mNativeBuilder, index, type.getValue(), vertices.getNativeObject(), indices.getNativeObject());
            return this;
        }

        @NonNull
        public Builder material(@IntRange(from=0L) int index, @NonNull MaterialInstance material) {
            RenderableManager.nBuilderMaterial(this.mNativeBuilder, index, material.getNativeObject());
            return this;
        }

        @NonNull
        public Builder blendOrder(@IntRange(from=0L) int index, @IntRange(from=0L, to=32767L) int blendOrder) {
            RenderableManager.nBuilderBlendOrder(this.mNativeBuilder, index, blendOrder);
            return this;
        }

        @NonNull
        public Builder globalBlendOrderEnabled(@IntRange(from=0L) int index, boolean enabled) {
            RenderableManager.nBuilderGlobalBlendOrderEnabled(this.mNativeBuilder, index, enabled);
            return this;
        }

        @NonNull
        public Builder boundingBox(@NonNull Box aabb) {
            RenderableManager.nBuilderBoundingBox(this.mNativeBuilder, aabb.getCenter()[0], aabb.getCenter()[1], aabb.getCenter()[2], aabb.getHalfExtent()[0], aabb.getHalfExtent()[1], aabb.getHalfExtent()[2]);
            return this;
        }

        @NonNull
        public Builder layerMask(@IntRange(from=0L, to=255L) int select, @IntRange(from=0L, to=255L) int value) {
            RenderableManager.nBuilderLayerMask(this.mNativeBuilder, select & 0xFF, value & 0xFF);
            return this;
        }

        @NonNull
        public Builder priority(@IntRange(from=0L, to=7L) int priority) {
            RenderableManager.nBuilderPriority(this.mNativeBuilder, priority);
            return this;
        }

        @NonNull
        public Builder culling(boolean enabled) {
            RenderableManager.nBuilderCulling(this.mNativeBuilder, enabled);
            return this;
        }

        @NonNull
        public Builder lightChannel(@IntRange(from=0L, to=7L) int channel, boolean enable) {
            RenderableManager.nBuilderLightChannel(this.mNativeBuilder, channel, enable);
            return this;
        }

        @NonNull
        public Builder instances(@IntRange(from=1L, to=65535L) int instanceCount) {
            RenderableManager.nBuilderInstances(this.mNativeBuilder, instanceCount);
            return this;
        }

        @NonNull
        public Builder castShadows(boolean enabled) {
            RenderableManager.nBuilderCastShadows(this.mNativeBuilder, enabled);
            return this;
        }

        @NonNull
        public Builder receiveShadows(boolean enabled) {
            RenderableManager.nBuilderReceiveShadows(this.mNativeBuilder, enabled);
            return this;
        }

        @NonNull
        public Builder screenSpaceContactShadows(boolean enabled) {
            RenderableManager.nBuilderScreenSpaceContactShadows(this.mNativeBuilder, enabled);
            return this;
        }

        @NonNull
        public Builder enableSkinningBuffers(boolean enabled) {
            RenderableManager.nEnableSkinningBuffers(this.mNativeBuilder, enabled);
            return this;
        }

        @NonNull
        public Builder skinning(SkinningBuffer skinningBuffer, @IntRange(from=0L, to=255L) int boneCount, int offset) {
            RenderableManager.nBuilderSkinningBuffer(this.mNativeBuilder, skinningBuffer != null ? skinningBuffer.getNativeObject() : 0L, boneCount, offset);
            return this;
        }

        @NonNull
        public Builder skinning(@IntRange(from=0L, to=255L) int boneCount) {
            RenderableManager.nBuilderSkinning(this.mNativeBuilder, boneCount);
            return this;
        }

        @NonNull
        public Builder skinning(@IntRange(from=0L, to=255L) int boneCount, @NonNull Buffer bones) {
            int result = RenderableManager.nBuilderSkinningBones(this.mNativeBuilder, boneCount, bones, bones.remaining());
            if (result < 0) {
                throw new BufferOverflowException();
            }
            return this;
        }

        @NonNull
        public Builder morphing(@IntRange(from=0L, to=255L) int targetCount) {
            RenderableManager.nBuilderMorphing(this.mNativeBuilder, targetCount);
            return this;
        }

        @NonNull
        public Builder morphing(@IntRange(from=0L) int level, @IntRange(from=0L) int primitiveIndex, @NonNull MorphTargetBuffer morphTargetBuffer, @IntRange(from=0L) int offset, @IntRange(from=0L) int count) {
            RenderableManager.nBuilderSetMorphTargetBufferAt(this.mNativeBuilder, level, primitiveIndex, morphTargetBuffer.getNativeObject(), offset, count);
            return this;
        }

        @NonNull
        public Builder morphing(@IntRange(from=0L) int level, @IntRange(from=0L) int primitiveIndex, @NonNull MorphTargetBuffer morphTargetBuffer) {
            RenderableManager.nBuilderSetMorphTargetBufferAt(this.mNativeBuilder, level, primitiveIndex, morphTargetBuffer.getNativeObject(), 0, morphTargetBuffer.getVertexCount());
            return this;
        }

        public void build(@NonNull Engine engine, @Entity int entity) {
            if (!RenderableManager.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject(), entity)) {
                throw new IllegalStateException("Couldn't create Renderable component for entity " + entity + ", see log.");
            }
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    RenderableManager.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static enum PrimitiveType {
        POINTS(0),
        LINES(1),
        LINE_STRIP(3),
        TRIANGLES(4),
        TRIANGLE_STRIP(5);

        private final int mType;

        private PrimitiveType(int value) {
            this.mType = value;
        }

        int getValue() {
            return this.mType;
        }
    }
}

