/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Engine;
import java.nio.Buffer;
import java.nio.BufferOverflowException;

public class IndexBuffer {
    private long mNativeObject;

    private IndexBuffer(long nativeIndexBuffer) {
        this.mNativeObject = nativeIndexBuffer;
    }

    @IntRange(from=0L)
    public int getIndexCount() {
        return IndexBuffer.nGetIndexCount(this.getNativeObject());
    }

    public void setBuffer(@NonNull Engine engine, @NonNull Buffer buffer) {
        this.setBuffer(engine, buffer, 0, 0, null, null);
    }

    public void setBuffer(@NonNull Engine engine, @NonNull Buffer buffer, @IntRange(from=0L) int destOffsetInBytes, @IntRange(from=0L) int count) {
        this.setBuffer(engine, buffer, destOffsetInBytes, count, null, null);
    }

    public void setBuffer(@NonNull Engine engine, @NonNull Buffer buffer, @IntRange(from=0L) int destOffsetInBytes, @IntRange(from=0L) int count, @Nullable Object handler, @Nullable Runnable callback) {
        int result = IndexBuffer.nSetBuffer(this.getNativeObject(), engine.getNativeObject(), buffer, buffer.remaining(), destOffsetInBytes, count == 0 ? buffer.remaining() : count, handler, callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed IndexBuffer");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderIndexCount(long var0, int var2);

    private static native void nBuilderBufferType(long var0, int var2);

    private static native long nBuilderBuild(long var0, long var2);

    private static native int nGetIndexCount(long var0);

    private static native int nSetBuffer(long var0, long var2, Buffer var4, int var5, int var6, int var7, Object var8, Runnable var9);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = IndexBuffer.nCreateBuilder();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder indexCount(@IntRange(from=1L) int indexCount) {
            IndexBuffer.nBuilderIndexCount(this.mNativeBuilder, indexCount);
            return this;
        }

        @NonNull
        public Builder bufferType(@NonNull IndexType indexType) {
            IndexBuffer.nBuilderBufferType(this.mNativeBuilder, indexType.ordinal());
            return this;
        }

        @NonNull
        public IndexBuffer build(@NonNull Engine engine) {
            long nativeIndexBuffer = IndexBuffer.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeIndexBuffer == 0L) {
                throw new IllegalStateException("Couldn't create IndexBuffer");
            }
            return new IndexBuffer(nativeIndexBuffer);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    IndexBuffer.nDestroyBuilder(this.mNativeObject);
                }
            }
        }

        public static enum IndexType {
            USHORT,
            UINT;

        }
    }
}

