/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.Asserts;
import com.google.android.filament.Engine;
import com.google.android.filament.Texture;

public class IndirectLight {
    long mNativeObject;

    public IndirectLight(long indirectLight) {
        this.mNativeObject = indirectLight;
    }

    public void setIntensity(float intensity) {
        IndirectLight.nSetIntensity(this.getNativeObject(), intensity);
    }

    public float getIntensity() {
        return IndirectLight.nGetIntensity(this.getNativeObject());
    }

    public void setRotation(@NonNull @Size(min=9L) float[] rotation) {
        Asserts.assertMat3fIn(rotation);
        IndirectLight.nSetRotation(this.getNativeObject(), rotation[0], rotation[1], rotation[2], rotation[3], rotation[4], rotation[5], rotation[6], rotation[7], rotation[8]);
    }

    @NonNull
    @Size(min=9L)
    public float[] getRotation(@Nullable @Size(min=9L) float[] rotation) {
        rotation = Asserts.assertMat3f(rotation);
        IndirectLight.nGetRotation(this.getNativeObject(), rotation);
        return rotation;
    }

    @NonNull
    @Size(min=3L)
    public static float[] getDirectionEstimate(@NonNull float[] sh, @Nullable @Size(min=3L) float[] direction) {
        if (sh.length < 27) {
            throw new ArrayIndexOutOfBoundsException("3 bands SH required, array must be at least 9 x float3");
        }
        direction = Asserts.assertFloat3(direction);
        IndirectLight.nGetDirectionEstimateStatic(sh, direction);
        return direction;
    }

    @Deprecated
    @NonNull
    @Size(min=3L)
    public float[] getDirectionEstimate(@Nullable @Size(min=3L) float[] direction) {
        direction = Asserts.assertFloat3(direction);
        IndirectLight.nGetDirectionEstimate(this.getNativeObject(), direction);
        return direction;
    }

    @NonNull
    @Size(min=4L)
    public static float[] getColorEstimate(@Nullable @Size(min=4L) float[] colorIntensity, @NonNull float[] sh, float x, float y, float z) {
        if (sh.length < 27) {
            throw new ArrayIndexOutOfBoundsException("3 bands SH required, array must be at least 9 x float3");
        }
        colorIntensity = Asserts.assertFloat4(colorIntensity);
        IndirectLight.nGetColorEstimateStatic(colorIntensity, sh, x, y, z);
        return colorIntensity;
    }

    @Deprecated
    @NonNull
    @Size(min=4L)
    public float[] getColorEstimate(@Nullable @Size(min=4L) float[] colorIntensity, float x, float y, float z) {
        colorIntensity = Asserts.assertFloat4(colorIntensity);
        IndirectLight.nGetColorEstimate(this.getNativeObject(), colorIntensity, x, y, z);
        return colorIntensity;
    }

    @Nullable
    public Texture getReflectionsTexture() {
        long nativeTexture = IndirectLight.nGetReflectionsTexture(this.getNativeObject());
        return nativeTexture == 0L ? null : new Texture(nativeTexture);
    }

    @Nullable
    public Texture getIrradianceTexture() {
        long nativeTexture = IndirectLight.nGetIrradianceTexture(this.getNativeObject());
        return nativeTexture == 0L ? null : new Texture(nativeTexture);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed IndirectLight");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native long nBuilderBuild(long var0, long var2);

    private static native void nBuilderReflections(long var0, long var2);

    private static native void nIrradiance(long var0, int var2, float[] var3);

    private static native void nRadiance(long var0, int var2, float[] var3);

    private static native void nIrradianceAsTexture(long var0, long var2);

    private static native void nIntensity(long var0, float var2);

    private static native void nRotation(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    private static native void nSetIntensity(long var0, float var2);

    private static native float nGetIntensity(long var0);

    private static native void nSetRotation(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    private static native void nGetRotation(long var0, float[] var2);

    private static native void nGetDirectionEstimate(long var0, float[] var2);

    private static native void nGetColorEstimate(long var0, float[] var2, float var3, float var4, float var5);

    private static native long nGetReflectionsTexture(long var0);

    private static native long nGetIrradianceTexture(long var0);

    private static native void nGetDirectionEstimateStatic(float[] var0, float[] var1);

    private static native void nGetColorEstimateStatic(float[] var0, float[] var1, float var2, float var3, float var4);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = IndirectLight.nCreateBuilder();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder reflections(@NonNull Texture cubemap) {
            IndirectLight.nBuilderReflections(this.mNativeBuilder, cubemap.getNativeObject());
            return this;
        }

        @NonNull
        public Builder irradiance(@IntRange(from=1L, to=3L) int bands, @NonNull float[] sh) {
            switch (bands) {
                case 1: {
                    if (sh.length >= 3) break;
                    throw new ArrayIndexOutOfBoundsException("1 band SH, array must be at least 1 x float3");
                }
                case 2: {
                    if (sh.length >= 12) break;
                    throw new ArrayIndexOutOfBoundsException("2 bands SH, array must be at least 4 x float3");
                }
                case 3: {
                    if (sh.length >= 27) break;
                    throw new ArrayIndexOutOfBoundsException("3 bands SH, array must be at least 9 x float3");
                }
                default: {
                    throw new IllegalArgumentException("bands must be 1, 2 or 3");
                }
            }
            IndirectLight.nIrradiance(this.mNativeBuilder, bands, sh);
            return this;
        }

        @NonNull
        public Builder radiance(@IntRange(from=1L, to=3L) int bands, @NonNull float[] sh) {
            switch (bands) {
                case 1: {
                    if (sh.length >= 3) break;
                    throw new ArrayIndexOutOfBoundsException("1 band SH, array must be at least 1 x float3");
                }
                case 2: {
                    if (sh.length >= 12) break;
                    throw new ArrayIndexOutOfBoundsException("2 bands SH, array must be at least 4 x float3");
                }
                case 3: {
                    if (sh.length >= 27) break;
                    throw new ArrayIndexOutOfBoundsException("3 bands SH, array must be at least 9 x float3");
                }
                default: {
                    throw new IllegalArgumentException("bands must be 1, 2 or 3");
                }
            }
            IndirectLight.nRadiance(this.mNativeBuilder, bands, sh);
            return this;
        }

        @NonNull
        public Builder irradiance(@NonNull Texture cubemap) {
            IndirectLight.nIrradianceAsTexture(this.mNativeBuilder, cubemap.getNativeObject());
            return this;
        }

        @NonNull
        public Builder intensity(float envIntensity) {
            IndirectLight.nIntensity(this.mNativeBuilder, envIntensity);
            return this;
        }

        @NonNull
        public Builder rotation(@NonNull @Size(min=9L) float[] rotation) {
            IndirectLight.nRotation(this.mNativeBuilder, rotation[0], rotation[1], rotation[2], rotation[3], rotation[4], rotation[5], rotation[6], rotation[7], rotation[8]);
            return this;
        }

        @NonNull
        public IndirectLight build(@NonNull Engine engine) {
            long nativeIndirectLight = IndirectLight.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeIndirectLight == 0L) {
                throw new IllegalStateException("Couldn't create IndirectLight");
            }
            return new IndirectLight(nativeIndirectLight);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    IndirectLight.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }
}

