/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import com.google.android.filament.Colors;
import com.google.android.filament.Engine;
import com.google.android.filament.Material;
import com.google.android.filament.Texture;
import com.google.android.filament.TextureSampler;
import com.google.android.filament.proguard.UsedByNative;

@UsedByNative(value="AssetLoader.cpp")
public class MaterialInstance {
    private static final Material.CullingMode[] sCullingModeValues = Material.CullingMode.values();
    private Material mMaterial;
    private String mName;
    private long mNativeObject;
    private long mNativeMaterial;
    static final int[] sStencilFaceMapping = new int[]{1, 2, 3};

    public MaterialInstance(Engine engine, long nativeMaterialInstance) {
        this.mNativeObject = nativeMaterialInstance;
        this.mNativeMaterial = MaterialInstance.nGetMaterial(this.mNativeObject);
    }

    MaterialInstance(@NonNull Material material, long nativeMaterialInstance) {
        this.mMaterial = material;
        this.mNativeMaterial = material.getNativeObject();
        this.mNativeObject = nativeMaterialInstance;
    }

    MaterialInstance(long nativeMaterialInstance) {
        this.mNativeObject = nativeMaterialInstance;
        this.mNativeMaterial = MaterialInstance.nGetMaterial(this.mNativeObject);
    }

    @NonNull
    public static MaterialInstance duplicate(@NonNull MaterialInstance other, String name) {
        long nativeInstance = MaterialInstance.nDuplicate(other.mNativeObject, name);
        if (nativeInstance == 0L) {
            throw new IllegalStateException("Couldn't duplicate MaterialInstance");
        }
        return new MaterialInstance(other.getMaterial(), nativeInstance);
    }

    @NonNull
    public Material getMaterial() {
        if (this.mMaterial == null) {
            this.mMaterial = new Material(this.mNativeMaterial);
        }
        return this.mMaterial;
    }

    @NonNull
    public String getName() {
        if (this.mName == null) {
            this.mName = MaterialInstance.nGetName(this.getNativeObject());
        }
        return this.mName;
    }

    public void setParameter(@NonNull String name, boolean x) {
        MaterialInstance.nSetParameterBool(this.getNativeObject(), name, x);
    }

    public void setParameter(@NonNull String name, float x) {
        MaterialInstance.nSetParameterFloat(this.getNativeObject(), name, x);
    }

    public void setParameter(@NonNull String name, int x) {
        MaterialInstance.nSetParameterInt(this.getNativeObject(), name, x);
    }

    public void setParameter(@NonNull String name, boolean x, boolean y) {
        MaterialInstance.nSetParameterBool2(this.getNativeObject(), name, x, y);
    }

    public void setParameter(@NonNull String name, float x, float y) {
        MaterialInstance.nSetParameterFloat2(this.getNativeObject(), name, x, y);
    }

    public void setParameter(@NonNull String name, int x, int y) {
        MaterialInstance.nSetParameterInt2(this.getNativeObject(), name, x, y);
    }

    public void setParameter(@NonNull String name, boolean x, boolean y, boolean z) {
        MaterialInstance.nSetParameterBool3(this.getNativeObject(), name, x, y, z);
    }

    public void setParameter(@NonNull String name, float x, float y, float z) {
        MaterialInstance.nSetParameterFloat3(this.getNativeObject(), name, x, y, z);
    }

    public void setParameter(@NonNull String name, int x, int y, int z) {
        MaterialInstance.nSetParameterInt3(this.getNativeObject(), name, x, y, z);
    }

    public void setParameter(@NonNull String name, boolean x, boolean y, boolean z, boolean w) {
        MaterialInstance.nSetParameterBool4(this.getNativeObject(), name, x, y, z, w);
    }

    public void setParameter(@NonNull String name, float x, float y, float z, float w) {
        MaterialInstance.nSetParameterFloat4(this.getNativeObject(), name, x, y, z, w);
    }

    public void setParameter(@NonNull String name, int x, int y, int z, int w) {
        MaterialInstance.nSetParameterInt4(this.getNativeObject(), name, x, y, z, w);
    }

    public void setParameter(@NonNull String name, @NonNull Texture texture, @NonNull TextureSampler sampler) {
        MaterialInstance.nSetParameterTexture(this.getNativeObject(), name, texture.getNativeObject(), sampler.mSampler);
    }

    public void setParameter(@NonNull String name, @NonNull BooleanElement type, @NonNull boolean[] v, @IntRange(from=0L) int offset, @IntRange(from=1L) int count) {
        MaterialInstance.nSetBooleanParameterArray(this.getNativeObject(), name, type.ordinal(), v, offset, count);
    }

    public void setParameter(@NonNull String name, @NonNull IntElement type, @NonNull int[] v, @IntRange(from=0L) int offset, @IntRange(from=1L) int count) {
        MaterialInstance.nSetIntParameterArray(this.getNativeObject(), name, type.ordinal(), v, offset, count);
    }

    public void setParameter(@NonNull String name, @NonNull FloatElement type, @NonNull float[] v, @IntRange(from=0L) int offset, @IntRange(from=1L) int count) {
        MaterialInstance.nSetFloatParameterArray(this.getNativeObject(), name, type.ordinal(), v, offset, count);
    }

    public void setParameter(@NonNull String name, @NonNull Colors.RgbType type, float r, float g, float b) {
        float[] color = Colors.toLinear(type, r, g, b);
        MaterialInstance.nSetParameterFloat3(this.getNativeObject(), name, color[0], color[1], color[2]);
    }

    public void setParameter(@NonNull String name, @NonNull Colors.RgbaType type, float r, float g, float b, float a) {
        float[] color = Colors.toLinear(type, r, g, b, a);
        MaterialInstance.nSetParameterFloat4(this.getNativeObject(), name, color[0], color[1], color[2], color[3]);
    }

    public void setScissor(@IntRange(from=0L) int left, @IntRange(from=0L) int bottom, @IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        MaterialInstance.nSetScissor(this.getNativeObject(), left, bottom, width, height);
    }

    public void unsetScissor() {
        MaterialInstance.nUnsetScissor(this.getNativeObject());
    }

    public void setPolygonOffset(float scale, float constant) {
        MaterialInstance.nSetPolygonOffset(this.getNativeObject(), scale, constant);
    }

    public void setMaskThreshold(float threshold) {
        MaterialInstance.nSetMaskThreshold(this.getNativeObject(), threshold);
    }

    public float getMaskThreshold() {
        return MaterialInstance.nGetMaskThreshold(this.getNativeObject());
    }

    public void setSpecularAntiAliasingVariance(float variance) {
        MaterialInstance.nSetSpecularAntiAliasingVariance(this.getNativeObject(), variance);
    }

    public float getSpecularAntiAliasingVariance() {
        return MaterialInstance.nGetSpecularAntiAliasingVariance(this.getNativeObject());
    }

    public void setSpecularAntiAliasingThreshold(float threshold) {
        MaterialInstance.nSetSpecularAntiAliasingThreshold(this.getNativeObject(), threshold);
    }

    public float getSpecularAntiAliasingThreshold() {
        return MaterialInstance.nGetSpecularAntiAliasingThreshold(this.getNativeObject());
    }

    public void setDoubleSided(boolean doubleSided) {
        MaterialInstance.nSetDoubleSided(this.getNativeObject(), doubleSided);
    }

    public boolean isDoubleSided() {
        return MaterialInstance.nIsDoubleSided(this.getNativeObject());
    }

    public void setCullingMode(@NonNull Material.CullingMode mode) {
        MaterialInstance.nSetCullingMode(this.getNativeObject(), mode.ordinal());
    }

    @NonNull
    public Material.CullingMode getCullingMode() {
        return sCullingModeValues[MaterialInstance.nGetCullingMode(this.getNativeObject())];
    }

    public void setColorWrite(boolean enable) {
        MaterialInstance.nSetColorWrite(this.getNativeObject(), enable);
    }

    public boolean isColorWriteEnabled() {
        return MaterialInstance.nIsColorWriteEnabled(this.getNativeObject());
    }

    public void setDepthWrite(boolean enable) {
        MaterialInstance.nSetDepthWrite(this.getNativeObject(), enable);
    }

    public boolean isDepthWriteEnabled() {
        return MaterialInstance.nIsDepthWriteEnabled(this.getNativeObject());
    }

    public void setStencilWrite(boolean enable) {
        MaterialInstance.nSetStencilWrite(this.getNativeObject(), enable);
    }

    public boolean isStencilWriteEnabled() {
        return MaterialInstance.nIsStencilWriteEnabled(this.getNativeObject());
    }

    public void setDepthCulling(boolean enable) {
        MaterialInstance.nSetDepthCulling(this.getNativeObject(), enable);
    }

    public void setDepthFunc(TextureSampler.CompareFunction func) {
        MaterialInstance.nSetDepthFunc(this.getNativeObject(), func.ordinal());
    }

    public boolean isDepthCullingEnabled() {
        return MaterialInstance.nIsDepthCullingEnabled(this.getNativeObject());
    }

    public TextureSampler.CompareFunction getDepthFunc() {
        return TextureSampler.EnumCache.sCompareFunctionValues[MaterialInstance.nGetDepthFunc(this.getNativeObject())];
    }

    public void setStencilCompareFunction(TextureSampler.CompareFunction func, StencilFace face) {
        MaterialInstance.nSetStencilCompareFunction(this.getNativeObject(), func.ordinal(), sStencilFaceMapping[face.ordinal()]);
    }

    public void setStencilCompareFunction(TextureSampler.CompareFunction func) {
        this.setStencilCompareFunction(func, StencilFace.FRONT_AND_BACK);
    }

    public void setStencilOpStencilFail(StencilOperation op, StencilFace face) {
        MaterialInstance.nSetStencilOpStencilFail(this.getNativeObject(), op.ordinal(), sStencilFaceMapping[face.ordinal()]);
    }

    public void setStencilOpStencilFail(StencilOperation op) {
        this.setStencilOpStencilFail(op, StencilFace.FRONT_AND_BACK);
    }

    public void setStencilOpDepthFail(StencilOperation op, StencilFace face) {
        MaterialInstance.nSetStencilOpDepthFail(this.getNativeObject(), op.ordinal(), sStencilFaceMapping[face.ordinal()]);
    }

    public void setStencilOpDepthFail(StencilOperation op) {
        this.setStencilOpDepthFail(op, StencilFace.FRONT_AND_BACK);
    }

    public void setStencilOpDepthStencilPass(StencilOperation op, StencilFace face) {
        MaterialInstance.nSetStencilOpDepthStencilPass(this.getNativeObject(), op.ordinal(), sStencilFaceMapping[face.ordinal()]);
    }

    public void setStencilOpDepthStencilPass(StencilOperation op) {
        this.setStencilOpDepthStencilPass(op, StencilFace.FRONT_AND_BACK);
    }

    public void setStencilReferenceValue(@IntRange(from=0L, to=255L) int value, StencilFace face) {
        MaterialInstance.nSetStencilReferenceValue(this.getNativeObject(), value, sStencilFaceMapping[face.ordinal()]);
    }

    public void setStencilReferenceValue(@IntRange(from=0L, to=255L) int value) {
        this.setStencilReferenceValue(value, StencilFace.FRONT_AND_BACK);
    }

    public void setStencilReadMask(@IntRange(from=0L, to=255L) int readMask, StencilFace face) {
        MaterialInstance.nSetStencilReadMask(this.getNativeObject(), readMask, sStencilFaceMapping[face.ordinal()]);
    }

    public void setStencilReadMask(@IntRange(from=0L, to=255L) int readMask) {
        this.setStencilReadMask(readMask, StencilFace.FRONT_AND_BACK);
    }

    public void setStencilWriteMask(@IntRange(from=0L, to=255L) int writeMask, StencilFace face) {
        MaterialInstance.nSetStencilWriteMask(this.getNativeObject(), writeMask, sStencilFaceMapping[face.ordinal()]);
    }

    public void setStencilWriteMask(int writeMask) {
        this.setStencilWriteMask(writeMask, StencilFace.FRONT_AND_BACK);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed MaterialInstance");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nSetParameterBool(long var0, @NonNull String var2, boolean var3);

    private static native void nSetParameterFloat(long var0, @NonNull String var2, float var3);

    private static native void nSetParameterInt(long var0, @NonNull String var2, int var3);

    private static native void nSetParameterBool2(long var0, @NonNull String var2, boolean var3, boolean var4);

    private static native void nSetParameterFloat2(long var0, @NonNull String var2, float var3, float var4);

    private static native void nSetParameterInt2(long var0, @NonNull String var2, int var3, int var4);

    private static native void nSetParameterBool3(long var0, @NonNull String var2, boolean var3, boolean var4, boolean var5);

    private static native void nSetParameterFloat3(long var0, @NonNull String var2, float var3, float var4, float var5);

    private static native void nSetParameterInt3(long var0, @NonNull String var2, int var3, int var4, int var5);

    private static native void nSetParameterBool4(long var0, @NonNull String var2, boolean var3, boolean var4, boolean var5, boolean var6);

    private static native void nSetParameterFloat4(long var0, @NonNull String var2, float var3, float var4, float var5, float var6);

    private static native void nSetParameterInt4(long var0, @NonNull String var2, int var3, int var4, int var5, int var6);

    private static native void nSetBooleanParameterArray(long var0, @NonNull String var2, int var3, @NonNull @Size(min=1L) boolean[] var4, @IntRange(from=0L) int var5, @IntRange(from=1L) int var6);

    private static native void nSetIntParameterArray(long var0, @NonNull String var2, int var3, @NonNull @Size(min=1L) int[] var4, @IntRange(from=0L) int var5, @IntRange(from=1L) int var6);

    private static native void nSetFloatParameterArray(long var0, @NonNull String var2, int var3, @NonNull @Size(min=1L) float[] var4, @IntRange(from=0L) int var5, @IntRange(from=1L) int var6);

    private static native void nSetParameterTexture(long var0, @NonNull String var2, long var3, int var5);

    private static native void nSetScissor(long var0, @IntRange(from=0L) int var2, @IntRange(from=0L) int var3, @IntRange(from=0L) int var4, @IntRange(from=0L) int var5);

    private static native void nUnsetScissor(long var0);

    private static native void nSetPolygonOffset(long var0, float var2, float var3);

    private static native void nSetMaskThreshold(long var0, float var2);

    private static native void nSetSpecularAntiAliasingVariance(long var0, float var2);

    private static native void nSetSpecularAntiAliasingThreshold(long var0, float var2);

    private static native void nSetDoubleSided(long var0, boolean var2);

    private static native void nSetCullingMode(long var0, long var2);

    private static native void nSetColorWrite(long var0, boolean var2);

    private static native void nSetDepthWrite(long var0, boolean var2);

    private static native void nSetStencilWrite(long var0, boolean var2);

    private static native void nSetDepthCulling(long var0, boolean var2);

    private static native void nSetDepthFunc(long var0, long var2);

    private static native void nSetStencilCompareFunction(long var0, long var2, long var4);

    private static native void nSetStencilOpStencilFail(long var0, long var2, long var4);

    private static native void nSetStencilOpDepthFail(long var0, long var2, long var4);

    private static native void nSetStencilOpDepthStencilPass(long var0, long var2, long var4);

    private static native void nSetStencilReferenceValue(long var0, int var2, long var3);

    private static native void nSetStencilReadMask(long var0, int var2, long var3);

    private static native void nSetStencilWriteMask(long var0, int var2, long var3);

    private static native String nGetName(long var0);

    private static native long nGetMaterial(long var0);

    private static native long nDuplicate(long var0, String var2);

    private static native float nGetMaskThreshold(long var0);

    private static native float nGetSpecularAntiAliasingVariance(long var0);

    private static native float nGetSpecularAntiAliasingThreshold(long var0);

    private static native boolean nIsDoubleSided(long var0);

    private static native int nGetCullingMode(long var0);

    private static native boolean nIsColorWriteEnabled(long var0);

    private static native boolean nIsDepthWriteEnabled(long var0);

    private static native boolean nIsStencilWriteEnabled(long var0);

    private static native boolean nIsDepthCullingEnabled(long var0);

    private static native int nGetDepthFunc(long var0);

    public static enum BooleanElement {
        BOOL,
        BOOL2,
        BOOL3,
        BOOL4;

    }

    public static enum IntElement {
        INT,
        INT2,
        INT3,
        INT4;

    }

    public static enum FloatElement {
        FLOAT,
        FLOAT2,
        FLOAT3,
        FLOAT4,
        MAT3,
        MAT4;

    }

    public static enum StencilFace {
        FRONT,
        BACK,
        FRONT_AND_BACK;

    }

    public static enum StencilOperation {
        KEEP,
        ZERO,
        REPLACE,
        INCR_CLAMP,
        INCR_WRAP,
        DECR_CLAMP,
        DECR_WRAP,
        INVERT;

    }
}

