/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.google.android.filament.Engine;
import java.nio.BufferOverflowException;

public class MorphTargetBuffer {
    private long mNativeObject;

    private MorphTargetBuffer(long nativeMorphTargetBuffer) {
        this.mNativeObject = nativeMorphTargetBuffer;
    }

    public void setPositionsAt(@NonNull Engine engine, @IntRange(from=0L) int targetIndex, @NonNull float[] positions, @IntRange(from=0L, to=125L) int count) {
        int result = MorphTargetBuffer.nSetPositionsAt(this.mNativeObject, engine.getNativeObject(), targetIndex, positions, count);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void setTangentsAt(@NonNull Engine engine, @IntRange(from=0L) int targetIndex, @NonNull short[] tangents, @IntRange(from=0L, to=125L) int count) {
        int result = MorphTargetBuffer.nSetTangentsAt(this.mNativeObject, engine.getNativeObject(), targetIndex, tangents, count);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public int getVertexCount() {
        return MorphTargetBuffer.nGetVertexCount(this.mNativeObject);
    }

    public int getCount() {
        return MorphTargetBuffer.nGetCount(this.mNativeObject);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed MorphTargetBuffer");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderVertexCount(long var0, int var2);

    private static native void nBuilderCount(long var0, int var2);

    private static native long nBuilderBuild(long var0, long var2);

    private static native int nSetPositionsAt(long var0, long var2, int var4, float[] var5, int var6);

    private static native int nSetTangentsAt(long var0, long var2, int var4, short[] var5, int var6);

    private static native int nGetVertexCount(long var0);

    private static native int nGetCount(long var0);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = MorphTargetBuffer.nCreateBuilder();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder vertexCount(@IntRange(from=1L) int vertexCount) {
            MorphTargetBuffer.nBuilderVertexCount(this.mNativeBuilder, vertexCount);
            return this;
        }

        @NonNull
        public Builder count(@IntRange(from=1L) int count) {
            MorphTargetBuffer.nBuilderCount(this.mNativeBuilder, count);
            return this;
        }

        @NonNull
        public MorphTargetBuffer build(@NonNull Engine engine) {
            long nativeMorphTargetBuffer = MorphTargetBuffer.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeMorphTargetBuffer == 0L) {
                throw new IllegalStateException("Couldn't create MorphTargetBuffer");
            }
            return new MorphTargetBuffer(nativeMorphTargetBuffer);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    MorphTargetBuffer.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }
}

