/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.NonNull;
import com.google.android.filament.Engine;

public class SwapChain {
    private final Object mSurface;
    private long mNativeObject;
    public static final long CONFIG_DEFAULT = 0L;
    public static final long CONFIG_TRANSPARENT = 1L;
    public static final long CONFIG_READABLE = 2L;
    public static final long CONFIG_ENABLE_XCB = 4L;
    public static final long CONFIG_SRGB_COLORSPACE = 16L;

    SwapChain(long nativeSwapChain, Object surface) {
        this.mNativeObject = nativeSwapChain;
        this.mSurface = surface;
    }

    public static boolean isSRGBSwapChainSupported(@NonNull Engine engine) {
        return SwapChain.nIsSRGBSwapChainSupported(engine.getNativeObject());
    }

    public Object getNativeWindow() {
        return this.mSurface;
    }

    public void setFrameCompletedCallback(@NonNull Object handler, @NonNull Runnable callback) {
        SwapChain.nSetFrameCompletedCallback(this.getNativeObject(), handler, callback);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed SwapChain");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nSetFrameCompletedCallback(long var0, Object var2, Runnable var3);

    private static native boolean nIsSRGBSwapChainSupported(long var0);
}

