/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.BufferObject;
import com.google.android.filament.Engine;
import java.nio.Buffer;
import java.nio.BufferOverflowException;

public class VertexBuffer {
    private long mNativeObject;

    private VertexBuffer(long nativeVertexBuffer) {
        this.mNativeObject = nativeVertexBuffer;
    }

    @IntRange(from=0L)
    public int getVertexCount() {
        return VertexBuffer.nGetVertexCount(this.getNativeObject());
    }

    public void setBufferAt(@NonNull Engine engine, int bufferIndex, @NonNull Buffer buffer) {
        this.setBufferAt(engine, bufferIndex, buffer, 0, 0, null, null);
    }

    public void setBufferAt(@NonNull Engine engine, int bufferIndex, @NonNull Buffer buffer, @IntRange(from=0L) int destOffsetInBytes, @IntRange(from=0L) int count) {
        this.setBufferAt(engine, bufferIndex, buffer, destOffsetInBytes, count, null, null);
    }

    public void setBufferAt(@NonNull Engine engine, int bufferIndex, @NonNull Buffer buffer, @IntRange(from=0L) int destOffsetInBytes, @IntRange(from=0L) int count, @Nullable Object handler, @Nullable Runnable callback) {
        int result = VertexBuffer.nSetBufferAt(this.getNativeObject(), engine.getNativeObject(), bufferIndex, buffer, buffer.remaining(), destOffsetInBytes, count == 0 ? buffer.remaining() : count, handler, callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void setBufferObjectAt(@NonNull Engine engine, int bufferIndex, @NonNull BufferObject bufferObject) {
        VertexBuffer.nSetBufferObjectAt(this.getNativeObject(), engine.getNativeObject(), bufferIndex, bufferObject.getNativeObject());
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed VertexBuffer");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderVertexCount(long var0, int var2);

    private static native void nBuilderEnableBufferObjects(long var0, boolean var2);

    private static native void nBuilderBufferCount(long var0, int var2);

    private static native void nBuilderAttribute(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void nBuilderNormalized(long var0, int var2, boolean var3);

    private static native long nBuilderBuild(long var0, long var2);

    private static native int nGetVertexCount(long var0);

    private static native int nSetBufferAt(long var0, long var2, int var4, Buffer var5, int var6, int var7, int var8, Object var9, Runnable var10);

    private static native void nSetBufferObjectAt(long var0, long var2, int var4, long var5);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = VertexBuffer.nCreateBuilder();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder vertexCount(@IntRange(from=1L) int vertexCount) {
            VertexBuffer.nBuilderVertexCount(this.mNativeBuilder, vertexCount);
            return this;
        }

        @NonNull
        public Builder enableBufferObjects(boolean enabled) {
            VertexBuffer.nBuilderEnableBufferObjects(this.mNativeBuilder, enabled);
            return this;
        }

        @NonNull
        public Builder bufferCount(@IntRange(from=1L) int bufferCount) {
            VertexBuffer.nBuilderBufferCount(this.mNativeBuilder, bufferCount);
            return this;
        }

        @NonNull
        public Builder attribute(@NonNull VertexAttribute attribute, @IntRange(from=0L) int bufferIndex, @NonNull AttributeType attributeType, @IntRange(from=0L) int byteOffset, @IntRange(from=0L) int byteStride) {
            VertexBuffer.nBuilderAttribute(this.mNativeBuilder, attribute.ordinal(), bufferIndex, attributeType.ordinal(), byteOffset, byteStride);
            return this;
        }

        @NonNull
        public Builder attribute(@NonNull VertexAttribute attribute, @IntRange(from=0L) int bufferIndex, @NonNull AttributeType attributeType) {
            return this.attribute(attribute, bufferIndex, attributeType, 0, 0);
        }

        @NonNull
        public Builder normalized(@NonNull VertexAttribute attribute) {
            VertexBuffer.nBuilderNormalized(this.mNativeBuilder, attribute.ordinal(), true);
            return this;
        }

        @NonNull
        public Builder normalized(@NonNull VertexAttribute attribute, boolean enabled) {
            VertexBuffer.nBuilderNormalized(this.mNativeBuilder, attribute.ordinal(), enabled);
            return this;
        }

        @NonNull
        public VertexBuffer build(@NonNull Engine engine) {
            long nativeVertexBuffer = VertexBuffer.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeVertexBuffer == 0L) {
                throw new IllegalStateException("Couldn't create VertexBuffer");
            }
            return new VertexBuffer(nativeVertexBuffer);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    VertexBuffer.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static enum AttributeType {
        BYTE,
        BYTE2,
        BYTE3,
        BYTE4,
        UBYTE,
        UBYTE2,
        UBYTE3,
        UBYTE4,
        SHORT,
        SHORT2,
        SHORT3,
        SHORT4,
        USHORT,
        USHORT2,
        USHORT3,
        USHORT4,
        INT,
        UINT,
        FLOAT,
        FLOAT2,
        FLOAT3,
        FLOAT4,
        HALF,
        HALF2,
        HALF3,
        HALF4;

    }

    public static enum VertexAttribute {
        POSITION,
        TANGENTS,
        COLOR,
        UV0,
        UV1,
        BONE_INDICES,
        BONE_WEIGHTS,
        UNUSED,
        CUSTOM0,
        CUSTOM1,
        CUSTOM2,
        CUSTOM3,
        CUSTOM4,
        CUSTOM5,
        CUSTOM6,
        CUSTOM7;

    }
}

