/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Engine;
import java.nio.Buffer;
import java.nio.BufferOverflowException;

public class BufferObject {
    private long mNativeObject;

    private BufferObject(long nativeBufferObject) {
        this.mNativeObject = nativeBufferObject;
    }

    @IntRange(from=0L)
    public int getByteCount() {
        return BufferObject.nGetByteCount(this.getNativeObject());
    }

    public void setBuffer(@NonNull Engine engine, @NonNull Buffer buffer) {
        this.setBuffer(engine, buffer, 0, 0, null, null);
    }

    public void setBuffer(@NonNull Engine engine, @NonNull Buffer buffer, @IntRange(from=0L) int destOffsetInBytes, @IntRange(from=0L) int count) {
        this.setBuffer(engine, buffer, destOffsetInBytes, count, null, null);
    }

    public void setBuffer(@NonNull Engine engine, @NonNull Buffer buffer, @IntRange(from=0L) int destOffsetInBytes, @IntRange(from=0L) int count, @Nullable Object handler, @Nullable Runnable callback) {
        int result = BufferObject.nSetBuffer(this.getNativeObject(), engine.getNativeObject(), buffer, buffer.remaining(), destOffsetInBytes, count == 0 ? buffer.remaining() : count, handler, callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed BufferObject");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderSize(long var0, int var2);

    private static native void nBuilderBindingType(long var0, int var2);

    private static native long nBuilderBuild(long var0, long var2);

    private static native int nGetByteCount(long var0);

    private static native int nSetBuffer(long var0, long var2, Buffer var4, int var5, int var6, int var7, Object var8, Runnable var9);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = BufferObject.nCreateBuilder();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder size(@IntRange(from=1L) int byteCount) {
            BufferObject.nBuilderSize(this.mNativeBuilder, byteCount);
            return this;
        }

        @NonNull
        public Builder bindingType(@NonNull BindingType bindingType) {
            BufferObject.nBuilderBindingType(this.mNativeBuilder, bindingType.ordinal());
            return this;
        }

        @NonNull
        public BufferObject build(@NonNull Engine engine) {
            long nativeBufferObject = BufferObject.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeBufferObject == 0L) {
                throw new IllegalStateException("Couldn't create BufferObject");
            }
            return new BufferObject(nativeBufferObject);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    BufferObject.nDestroyBuilder(this.mNativeObject);
                }
            }
        }

        public static enum BindingType {
            VERTEX;

        }
    }
}

