/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Camera;
import com.google.android.filament.ColorGrading;
import com.google.android.filament.Entity;
import com.google.android.filament.EntityManager;
import com.google.android.filament.Fence;
import com.google.android.filament.IndexBuffer;
import com.google.android.filament.IndirectLight;
import com.google.android.filament.LightManager;
import com.google.android.filament.Material;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.NativeSurface;
import com.google.android.filament.Platform;
import com.google.android.filament.RenderTarget;
import com.google.android.filament.RenderableManager;
import com.google.android.filament.Renderer;
import com.google.android.filament.Scene;
import com.google.android.filament.SkinningBuffer;
import com.google.android.filament.Skybox;
import com.google.android.filament.Stream;
import com.google.android.filament.SwapChain;
import com.google.android.filament.Texture;
import com.google.android.filament.TransformManager;
import com.google.android.filament.VertexBuffer;
import com.google.android.filament.View;
import com.google.android.filament.proguard.UsedByReflection;

public class Engine {
    private static final Backend[] sBackendValues = Backend.values();
    private static final FeatureLevel[] sFeatureLevelValues = FeatureLevel.values();
    private long mNativeObject;
    private Config mConfig;
    @NonNull
    private final TransformManager mTransformManager;
    @NonNull
    private final LightManager mLightManager;
    @NonNull
    private final RenderableManager mRenderableManager;
    @NonNull
    private final EntityManager mEntityManager;

    private Engine(long nativeEngine, Config config) {
        this.mNativeObject = nativeEngine;
        this.mTransformManager = new TransformManager(Engine.nGetTransformManager(nativeEngine));
        this.mLightManager = new LightManager(Engine.nGetLightManager(nativeEngine));
        this.mRenderableManager = new RenderableManager(Engine.nGetRenderableManager(nativeEngine));
        this.mEntityManager = new EntityManager(Engine.nGetEntityManager(nativeEngine));
        this.mConfig = config;
    }

    @NonNull
    public static Engine create() {
        return new Builder().build();
    }

    @NonNull
    public static Engine create(@NonNull Backend backend) {
        return new Builder().backend(backend).build();
    }

    @NonNull
    public static Engine create(@NonNull Object sharedContext) {
        return new Builder().sharedContext(sharedContext).build();
    }

    public boolean isValid() {
        return this.mNativeObject != 0L;
    }

    public void destroy() {
        Engine.nDestroyEngine(this.getNativeObject());
        this.clearNativeObject();
    }

    @NonNull
    public Backend getBackend() {
        return sBackendValues[(int)Engine.nGetBackend(this.getNativeObject())];
    }

    public void enableAccurateTranslations() {
        this.getTransformManager().setAccurateTranslationsEnabled(true);
    }

    @NonNull
    public FeatureLevel getSupportedFeatureLevel() {
        return sFeatureLevelValues[Engine.nGetSupportedFeatureLevel(this.getNativeObject())];
    }

    @NonNull
    public FeatureLevel setActiveFeatureLevel(@NonNull FeatureLevel featureLevel) {
        return sFeatureLevelValues[Engine.nSetActiveFeatureLevel(this.getNativeObject(), featureLevel.ordinal())];
    }

    @NonNull
    public FeatureLevel getActiveFeatureLevel() {
        return sFeatureLevelValues[Engine.nGetActiveFeatureLevel(this.getNativeObject())];
    }

    public void setAutomaticInstancingEnabled(boolean enable) {
        Engine.nSetAutomaticInstancingEnabled(this.getNativeObject(), enable);
    }

    public boolean isAutomaticInstancingEnabled() {
        return Engine.nIsAutomaticInstancingEnabled(this.getNativeObject());
    }

    @NonNull
    public Config getConfig() {
        if (this.mConfig == null) {
            this.mConfig = new Config();
        }
        return this.mConfig;
    }

    public long getMaxStereoscopicEyes() {
        return Engine.nGetMaxStereoscopicEyes(this.getNativeObject());
    }

    @NonNull
    public SwapChain createSwapChain(@NonNull Object surface) {
        return this.createSwapChain(surface, 0L);
    }

    @NonNull
    public SwapChain createSwapChain(@NonNull Object surface, long flags) {
        if (Platform.get().validateSurface(surface)) {
            long nativeSwapChain = Engine.nCreateSwapChain(this.getNativeObject(), surface, flags);
            if (nativeSwapChain == 0L) {
                throw new IllegalStateException("Couldn't create SwapChain");
            }
            return new SwapChain(nativeSwapChain, surface);
        }
        throw new IllegalArgumentException("Invalid surface " + surface);
    }

    @NonNull
    public SwapChain createSwapChain(int width, int height, long flags) {
        if (width >= 0 && height >= 0) {
            long nativeSwapChain = Engine.nCreateSwapChainHeadless(this.getNativeObject(), width, height, flags);
            if (nativeSwapChain == 0L) {
                throw new IllegalStateException("Couldn't create SwapChain");
            }
            return new SwapChain(nativeSwapChain, null);
        }
        throw new IllegalArgumentException("Invalid parameters");
    }

    @NonNull
    public SwapChain createSwapChainFromNativeSurface(@NonNull NativeSurface surface, long flags) {
        long nativeSwapChain = Engine.nCreateSwapChainFromRawPointer(this.getNativeObject(), surface.getNativeObject(), flags);
        if (nativeSwapChain == 0L) {
            throw new IllegalStateException("Couldn't create SwapChain");
        }
        return new SwapChain(nativeSwapChain, surface);
    }

    public void destroySwapChain(@NonNull SwapChain swapChain) {
        Engine.assertDestroy(Engine.nDestroySwapChain(this.getNativeObject(), swapChain.getNativeObject()));
        swapChain.clearNativeObject();
    }

    public boolean isValidRenderer(@NonNull Renderer object) {
        return Engine.nIsValidRenderer(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidView(@NonNull View object) {
        return Engine.nIsValidView(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidScene(@NonNull Scene object) {
        return Engine.nIsValidScene(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidFence(@NonNull Fence object) {
        return Engine.nIsValidFence(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidStream(@NonNull Stream object) {
        return Engine.nIsValidStream(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidIndexBuffer(@NonNull IndexBuffer object) {
        return Engine.nIsValidIndexBuffer(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidVertexBuffer(@NonNull VertexBuffer object) {
        return Engine.nIsValidVertexBuffer(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidSkinningBuffer(@NonNull SkinningBuffer object) {
        return Engine.nIsValidSkinningBuffer(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidIndirectLight(@NonNull IndirectLight object) {
        return Engine.nIsValidIndirectLight(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidMaterial(@NonNull Material object) {
        return Engine.nIsValidMaterial(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidMaterialInstance(@NonNull Material ma, MaterialInstance mi) {
        return Engine.nIsValidMaterialInstance(this.getNativeObject(), ma.getNativeObject(), mi.getNativeObject());
    }

    public boolean isValidExpensiveMaterialInstance(@NonNull MaterialInstance object) {
        return Engine.nIsValidExpensiveMaterialInstance(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidSkybox(@NonNull Skybox object) {
        return Engine.nIsValidSkybox(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidColorGrading(@NonNull ColorGrading object) {
        return Engine.nIsValidColorGrading(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidTexture(@NonNull Texture object) {
        return Engine.nIsValidTexture(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidRenderTarget(@NonNull RenderTarget object) {
        return Engine.nIsValidRenderTarget(this.getNativeObject(), object.getNativeObject());
    }

    public boolean isValidSwapChain(@NonNull SwapChain object) {
        return Engine.nIsValidSwapChain(this.getNativeObject(), object.getNativeObject());
    }

    @NonNull
    public View createView() {
        long nativeView = Engine.nCreateView(this.getNativeObject());
        if (nativeView == 0L) {
            throw new IllegalStateException("Couldn't create View");
        }
        return new View(nativeView);
    }

    public void destroyView(@NonNull View view) {
        Engine.assertDestroy(Engine.nDestroyView(this.getNativeObject(), view.getNativeObject()));
        view.clearNativeObject();
    }

    @NonNull
    public Renderer createRenderer() {
        long nativeRenderer = Engine.nCreateRenderer(this.getNativeObject());
        if (nativeRenderer == 0L) {
            throw new IllegalStateException("Couldn't create Renderer");
        }
        return new Renderer(this, nativeRenderer);
    }

    public void destroyRenderer(@NonNull Renderer renderer) {
        Engine.assertDestroy(Engine.nDestroyRenderer(this.getNativeObject(), renderer.getNativeObject()));
        renderer.clearNativeObject();
    }

    @NonNull
    public Camera createCamera(@Entity int entity) {
        long nativeCamera = Engine.nCreateCamera(this.getNativeObject(), entity);
        if (nativeCamera == 0L) {
            throw new IllegalStateException("Couldn't create Camera");
        }
        return new Camera(nativeCamera, entity);
    }

    @Nullable
    public Camera getCameraComponent(@Entity int entity) {
        long nativeCamera = Engine.nGetCameraComponent(this.getNativeObject(), entity);
        if (nativeCamera == 0L) {
            return null;
        }
        return new Camera(nativeCamera, entity);
    }

    public void destroyCameraComponent(@Entity int entity) {
        Engine.nDestroyCameraComponent(this.getNativeObject(), entity);
    }

    @NonNull
    public Scene createScene() {
        long nativeScene = Engine.nCreateScene(this.getNativeObject());
        if (nativeScene == 0L) {
            throw new IllegalStateException("Couldn't create Scene");
        }
        return new Scene(nativeScene);
    }

    public void destroyScene(@NonNull Scene scene) {
        Engine.assertDestroy(Engine.nDestroyScene(this.getNativeObject(), scene.getNativeObject()));
        scene.clearNativeObject();
    }

    public void destroyStream(@NonNull Stream stream) {
        Engine.assertDestroy(Engine.nDestroyStream(this.getNativeObject(), stream.getNativeObject()));
        stream.clearNativeObject();
    }

    @NonNull
    public Fence createFence() {
        long nativeFence = Engine.nCreateFence(this.getNativeObject());
        if (nativeFence == 0L) {
            throw new IllegalStateException("Couldn't create Fence");
        }
        return new Fence(nativeFence);
    }

    public void destroyFence(@NonNull Fence fence) {
        Engine.assertDestroy(Engine.nDestroyFence(this.getNativeObject(), fence.getNativeObject()));
        fence.clearNativeObject();
    }

    public void destroyIndexBuffer(@NonNull IndexBuffer indexBuffer) {
        Engine.assertDestroy(Engine.nDestroyIndexBuffer(this.getNativeObject(), indexBuffer.getNativeObject()));
        indexBuffer.clearNativeObject();
    }

    public void destroyVertexBuffer(@NonNull VertexBuffer vertexBuffer) {
        Engine.assertDestroy(Engine.nDestroyVertexBuffer(this.getNativeObject(), vertexBuffer.getNativeObject()));
        vertexBuffer.clearNativeObject();
    }

    public void destroySkinningBuffer(@NonNull SkinningBuffer skinningBuffer) {
        Engine.assertDestroy(Engine.nDestroySkinningBuffer(this.getNativeObject(), skinningBuffer.getNativeObject()));
        skinningBuffer.clearNativeObject();
    }

    public void destroyIndirectLight(@NonNull IndirectLight ibl) {
        Engine.assertDestroy(Engine.nDestroyIndirectLight(this.getNativeObject(), ibl.getNativeObject()));
        ibl.clearNativeObject();
    }

    public void destroyMaterial(@NonNull Material material) {
        Engine.assertDestroy(Engine.nDestroyMaterial(this.getNativeObject(), material.getNativeObject()));
        material.clearNativeObject();
    }

    public void destroyMaterialInstance(@NonNull MaterialInstance materialInstance) {
        Engine.assertDestroy(Engine.nDestroyMaterialInstance(this.getNativeObject(), materialInstance.getNativeObject()));
        materialInstance.clearNativeObject();
    }

    public void destroySkybox(@NonNull Skybox skybox) {
        Engine.assertDestroy(Engine.nDestroySkybox(this.getNativeObject(), skybox.getNativeObject()));
        skybox.clearNativeObject();
    }

    public void destroyColorGrading(@NonNull ColorGrading colorGrading) {
        Engine.assertDestroy(Engine.nDestroyColorGrading(this.getNativeObject(), colorGrading.getNativeObject()));
        colorGrading.clearNativeObject();
    }

    public void destroyTexture(@NonNull Texture texture) {
        Engine.assertDestroy(Engine.nDestroyTexture(this.getNativeObject(), texture.getNativeObject()));
        texture.clearNativeObject();
    }

    public void destroyRenderTarget(@NonNull RenderTarget target) {
        Engine.nDestroyRenderTarget(this.getNativeObject(), target.getNativeObject());
        target.clearNativeObject();
    }

    public void destroyEntity(@Entity int entity) {
        Engine.nDestroyEntity(this.getNativeObject(), entity);
    }

    @NonNull
    public TransformManager getTransformManager() {
        return this.mTransformManager;
    }

    @NonNull
    public LightManager getLightManager() {
        return this.mLightManager;
    }

    @NonNull
    public RenderableManager getRenderableManager() {
        return this.mRenderableManager;
    }

    @NonNull
    public EntityManager getEntityManager() {
        return this.mEntityManager;
    }

    public void flushAndWait() {
        Engine.nFlushAndWait(this.getNativeObject());
    }

    public void flush() {
        Engine.nFlush(this.getNativeObject());
    }

    public boolean isPaused() {
        return Engine.nIsPaused(this.getNativeObject());
    }

    public void setPaused(boolean paused) {
        Engine.nSetPaused(this.getNativeObject(), paused);
    }

    @UsedByReflection(value="TextureHelper.java")
    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Engine");
        }
        return this.mNativeObject;
    }

    @UsedByReflection(value="MaterialBuilder.java")
    public long getNativeJobSystem() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Engine");
        }
        return Engine.nGetJobSystem(this.getNativeObject());
    }

    private void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static void assertDestroy(boolean success) {
        if (!success) {
            throw new IllegalStateException("Object couldn't be destroyed (double destroy()?)");
        }
    }

    private static native void nDestroyEngine(long var0);

    private static native long nGetBackend(long var0);

    private static native long nCreateSwapChain(long var0, Object var2, long var3);

    private static native long nCreateSwapChainHeadless(long var0, int var2, int var3, long var4);

    private static native long nCreateSwapChainFromRawPointer(long var0, long var2, long var4);

    private static native long nCreateView(long var0);

    private static native long nCreateRenderer(long var0);

    private static native long nCreateCamera(long var0, int var2);

    private static native long nGetCameraComponent(long var0, int var2);

    private static native void nDestroyCameraComponent(long var0, int var2);

    private static native long nCreateScene(long var0);

    private static native long nCreateFence(long var0);

    private static native boolean nDestroyRenderer(long var0, long var2);

    private static native boolean nDestroyView(long var0, long var2);

    private static native boolean nDestroyScene(long var0, long var2);

    private static native boolean nDestroyFence(long var0, long var2);

    private static native boolean nDestroyStream(long var0, long var2);

    private static native boolean nDestroyIndexBuffer(long var0, long var2);

    private static native boolean nDestroyVertexBuffer(long var0, long var2);

    private static native boolean nDestroySkinningBuffer(long var0, long var2);

    private static native boolean nDestroyIndirectLight(long var0, long var2);

    private static native boolean nDestroyMaterial(long var0, long var2);

    private static native boolean nDestroyMaterialInstance(long var0, long var2);

    private static native boolean nDestroySkybox(long var0, long var2);

    private static native boolean nDestroyColorGrading(long var0, long var2);

    private static native boolean nDestroyTexture(long var0, long var2);

    private static native boolean nDestroyRenderTarget(long var0, long var2);

    private static native boolean nDestroySwapChain(long var0, long var2);

    private static native boolean nIsValidRenderer(long var0, long var2);

    private static native boolean nIsValidView(long var0, long var2);

    private static native boolean nIsValidScene(long var0, long var2);

    private static native boolean nIsValidFence(long var0, long var2);

    private static native boolean nIsValidStream(long var0, long var2);

    private static native boolean nIsValidIndexBuffer(long var0, long var2);

    private static native boolean nIsValidVertexBuffer(long var0, long var2);

    private static native boolean nIsValidSkinningBuffer(long var0, long var2);

    private static native boolean nIsValidIndirectLight(long var0, long var2);

    private static native boolean nIsValidMaterial(long var0, long var2);

    private static native boolean nIsValidMaterialInstance(long var0, long var2, long var4);

    private static native boolean nIsValidExpensiveMaterialInstance(long var0, long var2);

    private static native boolean nIsValidSkybox(long var0, long var2);

    private static native boolean nIsValidColorGrading(long var0, long var2);

    private static native boolean nIsValidTexture(long var0, long var2);

    private static native boolean nIsValidRenderTarget(long var0, long var2);

    private static native boolean nIsValidSwapChain(long var0, long var2);

    private static native void nDestroyEntity(long var0, int var2);

    private static native void nFlushAndWait(long var0);

    private static native void nFlush(long var0);

    private static native boolean nIsPaused(long var0);

    private static native void nSetPaused(long var0, boolean var2);

    private static native long nGetTransformManager(long var0);

    private static native long nGetLightManager(long var0);

    private static native long nGetRenderableManager(long var0);

    private static native long nGetJobSystem(long var0);

    private static native long nGetEntityManager(long var0);

    private static native void nSetAutomaticInstancingEnabled(long var0, boolean var2);

    private static native boolean nIsAutomaticInstancingEnabled(long var0);

    private static native long nGetMaxStereoscopicEyes(long var0);

    private static native int nGetSupportedFeatureLevel(long var0);

    private static native int nSetActiveFeatureLevel(long var0, int var2);

    private static native int nGetActiveFeatureLevel(long var0);

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nSetBuilderBackend(long var0, long var2);

    private static native void nSetBuilderConfig(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, boolean var16, int var17, long var18, long var20, long var22, boolean var24, int var25, boolean var26);

    private static native void nSetBuilderFeatureLevel(long var0, int var2);

    private static native void nSetBuilderSharedContext(long var0, long var2);

    private static native void nSetBuilderPaused(long var0, boolean var2);

    private static native long nBuilderBuild(long var0);

    public static class Config {
        private static final long FILAMENT_PER_RENDER_PASS_ARENA_SIZE_IN_MB = 3L;
        private static final long FILAMENT_PER_FRAME_COMMANDS_SIZE_IN_MB = 2L;
        private static final long FILAMENT_MIN_COMMAND_BUFFERS_SIZE_IN_MB = 1L;
        private static final long FILAMENT_COMMAND_BUFFER_SIZE_IN_MB = 3L;
        public long commandBufferSizeMB = 3L;
        public long perRenderPassArenaSizeMB = 3L;
        public long driverHandleArenaSizeMB = 0L;
        public long minCommandBufferSizeMB = 1L;
        public long perFrameCommandsSizeMB = 2L;
        public long jobSystemThreadCount = 0L;
        public long textureUseAfterFreePoolSize = 0L;
        public boolean disableParallelShaderCompile = false;
        public StereoscopicType stereoscopicType = StereoscopicType.INSTANCED;
        public long stereoscopicEyeCount = 2L;
        public long resourceAllocatorCacheSizeMB = 64L;
        public long resourceAllocatorCacheMaxAge = 2L;
        public boolean disableHandleUseAfterFreeCheck = false;
        public ShaderLanguage preferredShaderLanguage = ShaderLanguage.DEFAULT;
        public boolean forceGLES2Context = false;

        public static enum ShaderLanguage {
            DEFAULT,
            MSL,
            METAL_LIBRARY;

        }
    }

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = Engine.nCreateBuilder();
        private Config mConfig;

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        public Builder backend(Backend backend) {
            Engine.nSetBuilderBackend(this.mNativeBuilder, backend.ordinal());
            return this;
        }

        public Builder sharedContext(Object sharedContext) {
            if (Platform.get().validateSharedContext(sharedContext)) {
                Engine.nSetBuilderSharedContext(this.mNativeBuilder, Platform.get().getSharedContextNativeHandle(sharedContext));
                return this;
            }
            throw new IllegalArgumentException("Invalid shared context " + sharedContext);
        }

        public Builder config(Config config) {
            this.mConfig = config;
            Engine.nSetBuilderConfig(this.mNativeBuilder, config.commandBufferSizeMB, config.perRenderPassArenaSizeMB, config.driverHandleArenaSizeMB, config.minCommandBufferSizeMB, config.perFrameCommandsSizeMB, config.jobSystemThreadCount, config.textureUseAfterFreePoolSize, config.disableParallelShaderCompile, config.stereoscopicType.ordinal(), config.stereoscopicEyeCount, config.resourceAllocatorCacheSizeMB, config.resourceAllocatorCacheMaxAge, config.disableHandleUseAfterFreeCheck, config.preferredShaderLanguage.ordinal(), config.forceGLES2Context);
            return this;
        }

        public Builder featureLevel(FeatureLevel featureLevel) {
            Engine.nSetBuilderFeatureLevel(this.mNativeBuilder, featureLevel.ordinal());
            return this;
        }

        public Builder paused(boolean paused) {
            Engine.nSetBuilderPaused(this.mNativeBuilder, paused);
            return this;
        }

        public Engine build() {
            long nativeEngine = Engine.nBuilderBuild(this.mNativeBuilder);
            if (nativeEngine == 0L) {
                throw new IllegalStateException("Couldn't create Engine");
            }
            return new Engine(nativeEngine, this.mConfig);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    Engine.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static enum Backend {
        DEFAULT,
        OPENGL,
        VULKAN,
        METAL,
        NOOP;

    }

    public static enum FeatureLevel {
        FEATURE_LEVEL_0,
        FEATURE_LEVEL_1,
        FEATURE_LEVEL_2,
        FEATURE_LEVEL_3;

    }

    public static enum StereoscopicType {
        INSTANCED,
        MULTIVIEW;

    }
}

