/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Entity;
import com.google.android.filament.IndirectLight;
import com.google.android.filament.Skybox;

public class Scene {
    private long mNativeObject;
    @Nullable
    private Skybox mSkybox;
    @Nullable
    private IndirectLight mIndirectLight;

    Scene(long nativeScene) {
        this.mNativeObject = nativeScene;
    }

    @Nullable
    public Skybox getSkybox() {
        return this.mSkybox;
    }

    public void setSkybox(@Nullable Skybox skybox) {
        this.mSkybox = skybox;
        Scene.nSetSkybox(this.getNativeObject(), this.mSkybox != null ? this.mSkybox.getNativeObject() : 0L);
    }

    @Nullable
    public IndirectLight getIndirectLight() {
        return this.mIndirectLight;
    }

    public void setIndirectLight(@Nullable IndirectLight ibl) {
        this.mIndirectLight = ibl;
        Scene.nSetIndirectLight(this.getNativeObject(), this.mIndirectLight != null ? this.mIndirectLight.getNativeObject() : 0L);
    }

    public void addEntity(@Entity int entity) {
        Scene.nAddEntity(this.getNativeObject(), entity);
    }

    public void addEntities(@Entity int[] entities) {
        Scene.nAddEntities(this.getNativeObject(), entities);
    }

    public void removeEntity(@Entity int entity) {
        Scene.nRemove(this.getNativeObject(), entity);
    }

    @Deprecated
    public void remove(@Entity int entity) {
        this.removeEntity(entity);
    }

    public void removeEntities(@Entity int[] entities) {
        Scene.nRemoveEntities(this.getNativeObject(), entities);
    }

    public int getEntityCount() {
        return Scene.nGetEntityCount(this.getNativeObject());
    }

    public int getRenderableCount() {
        return Scene.nGetRenderableCount(this.getNativeObject());
    }

    public int getLightCount() {
        return Scene.nGetLightCount(this.getNativeObject());
    }

    public boolean hasEntity(@Entity int entity) {
        return Scene.nHasEntity(this.getNativeObject(), entity);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Scene");
        }
        return this.mNativeObject;
    }

    public int[] getEntities(@Nullable int[] outArray) {
        boolean success;
        int c = this.getEntityCount();
        if (outArray == null || outArray.length < c) {
            outArray = new int[c];
        }
        if (!(success = Scene.nGetEntities(this.getNativeObject(), outArray, outArray.length))) {
            throw new IllegalStateException("Error retriving Scene's entities");
        }
        return outArray;
    }

    public int[] getEntities() {
        return this.getEntities(null);
    }

    public void forEach(@NonNull EntityProcessor entityProcessor) {
        int[] entities;
        for (int entity : entities = this.getEntities(null)) {
            entityProcessor.process(entity);
        }
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nSetSkybox(long var0, long var2);

    private static native void nSetIndirectLight(long var0, long var2);

    private static native void nAddEntity(long var0, int var2);

    private static native void nAddEntities(long var0, int[] var2);

    private static native void nRemove(long var0, int var2);

    private static native void nRemoveEntities(long var0, int[] var2);

    private static native int nGetEntityCount(long var0);

    private static native int nGetRenderableCount(long var0);

    private static native int nGetLightCount(long var0);

    private static native boolean nHasEntity(long var0, int var2);

    private static native boolean nGetEntities(long var0, int[] var2, int var3);

    public static interface EntityProcessor {
        public void process(@Entity int var1);
    }
}

