/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.google.android.filament.Engine;
import java.nio.Buffer;
import java.nio.BufferOverflowException;

public class SkinningBuffer {
    private long mNativeObject;

    private SkinningBuffer(long nativeSkinningBuffer) {
        this.mNativeObject = nativeSkinningBuffer;
    }

    public void setBonesAsMatrices(@NonNull Engine engine, @NonNull Buffer matrices, @IntRange(from=0L, to=255L) int boneCount, @IntRange(from=0L) int offset) {
        int result = SkinningBuffer.nSetBonesAsMatrices(this.mNativeObject, engine.getNativeObject(), matrices, matrices.remaining(), boneCount, offset);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void setBonesAsQuaternions(@NonNull Engine engine, @NonNull Buffer quaternions, @IntRange(from=0L, to=255L) int boneCount, @IntRange(from=0L) int offset) {
        int result = SkinningBuffer.nSetBonesAsQuaternions(this.mNativeObject, engine.getNativeObject(), quaternions, quaternions.remaining(), boneCount, offset);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public int getBoneCount() {
        return SkinningBuffer.nGetBoneCount(this.mNativeObject);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed IndexBuffer");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderBoneCount(long var0, int var2);

    private static native void nBuilderInitialize(long var0, boolean var2);

    private static native long nBuilderBuild(long var0, long var2);

    private static native int nSetBonesAsMatrices(long var0, long var2, Buffer var4, int var5, int var6, int var7);

    private static native int nSetBonesAsQuaternions(long var0, long var2, Buffer var4, int var5, int var6, int var7);

    private static native int nGetBoneCount(long var0);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder = SkinningBuffer.nCreateBuilder();

        public Builder() {
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder boneCount(@IntRange(from=1L) int boneCount) {
            SkinningBuffer.nBuilderBoneCount(this.mNativeBuilder, boneCount);
            return this;
        }

        @NonNull
        public Builder initialize(boolean initialize) {
            SkinningBuffer.nBuilderInitialize(this.mNativeBuilder, initialize);
            return this;
        }

        @NonNull
        public SkinningBuffer build(@NonNull Engine engine) {
            long nativeSkinningBuffer = SkinningBuffer.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeSkinningBuffer == 0L) {
                throw new IllegalStateException("Couldn't create SkinningBuffer");
            }
            return new SkinningBuffer(nativeSkinningBuffer);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    SkinningBuffer.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }
}

