/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.NonNull;
import com.google.android.filament.Engine;

public class SwapChain {
    private final Object mSurface;
    private long mNativeObject;

    SwapChain(long nativeSwapChain, Object surface) {
        this.mNativeObject = nativeSwapChain;
        this.mSurface = surface;
    }

    public static boolean isProtectedContentSupported(@NonNull Engine engine) {
        return SwapChain.nIsProtectedContentSupported(engine.getNativeObject());
    }

    public static boolean isSRGBSwapChainSupported(@NonNull Engine engine) {
        return SwapChain.nIsSRGBSwapChainSupported(engine.getNativeObject());
    }

    public Object getNativeWindow() {
        return this.mSurface;
    }

    public void setFrameCompletedCallback(@NonNull Object handler, @NonNull Runnable callback) {
        SwapChain.nSetFrameCompletedCallback(this.getNativeObject(), handler, callback);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed SwapChain");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nSetFrameCompletedCallback(long var0, Object var2, Runnable var3);

    private static native boolean nIsSRGBSwapChainSupported(long var0);

    private static native boolean nIsProtectedContentSupported(long var0);
}

