/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.android;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class UiHelper {
    private static final String LOG_TAG = "UiHelper";
    private static final boolean LOGGING = false;
    private int mDesiredWidth;
    private int mDesiredHeight;
    private Object mNativeWindow;
    private RendererCallback mRenderCallback;
    private boolean mHasSwapChain;
    private RenderSurface mRenderSurface;
    private boolean mOpaque = true;
    private boolean mOverlay = false;

    public UiHelper() {
        this(ContextErrorPolicy.CHECK);
    }

    public UiHelper(ContextErrorPolicy policy) {
    }

    public void setRenderCallback(@Nullable RendererCallback renderCallback) {
        this.mRenderCallback = renderCallback;
    }

    @Nullable
    public RendererCallback getRenderCallback() {
        return this.mRenderCallback;
    }

    public void detach() {
        if (this.mRenderSurface != null) {
            this.mRenderSurface.detach();
        }
        this.destroySwapChain();
        this.mNativeWindow = null;
        this.mRenderSurface = null;
    }

    public boolean isReadyToRender() {
        return this.mHasSwapChain;
    }

    public void setDesiredSize(int width, int height) {
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        if (this.mRenderSurface != null) {
            this.mRenderSurface.resize(width, height);
        }
    }

    public int getDesiredWidth() {
        return this.mDesiredWidth;
    }

    public int getDesiredHeight() {
        return this.mDesiredHeight;
    }

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public void setOpaque(boolean opaque) {
        this.mOpaque = opaque;
    }

    public boolean isMediaOverlay() {
        return this.mOverlay;
    }

    public void setMediaOverlay(boolean overlay) {
        this.mOverlay = overlay;
    }

    public long getSwapChainFlags() {
        return this.isOpaque() ? 0L : 1L;
    }

    public void attachTo(@NonNull SurfaceView view) {
        if (this.attach(view)) {
            boolean translucent;
            boolean bl = translucent = !this.isOpaque();
            if (this.isMediaOverlay()) {
                view.setZOrderMediaOverlay(translucent);
            } else {
                view.setZOrderOnTop(translucent);
            }
            view.getHolder().setFormat(this.isOpaque() ? -1 : -3);
            this.mRenderSurface = new SurfaceViewHandler(view);
        }
    }

    public void attachTo(@NonNull TextureView view) {
        if (this.attach(view)) {
            view.setOpaque(this.isOpaque());
            this.mRenderSurface = new TextureViewHandler(view);
        }
    }

    public void attachTo(@NonNull SurfaceHolder holder) {
        if (this.attach(holder)) {
            holder.setFormat(this.isOpaque() ? -1 : -3);
            this.mRenderSurface = new SurfaceHolderHandler(holder);
        }
    }

    private boolean attach(@NonNull Object nativeWindow) {
        if (this.mNativeWindow != null) {
            if (this.mNativeWindow == nativeWindow) {
                return false;
            }
            if (this.mRenderSurface != null) {
                this.mRenderSurface.detach();
                this.mRenderSurface = null;
            }
            this.destroySwapChain();
        }
        this.mNativeWindow = nativeWindow;
        return true;
    }

    private void createSwapChain(@NonNull Surface surface) {
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onNativeWindowChanged(surface);
        }
        this.mHasSwapChain = true;
    }

    private void destroySwapChain() {
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onDetachedFromSurface();
        }
        this.mHasSwapChain = false;
    }

    public static enum ContextErrorPolicy {
        CHECK,
        DONT_CHECK;

    }

    public static interface RendererCallback {
        public void onNativeWindowChanged(Surface var1);

        public void onDetachedFromSurface();

        public void onResized(int var1, int var2);
    }

    private static interface RenderSurface {
        public void resize(int var1, int var2);

        public void detach();
    }

    private class SurfaceViewHandler
    implements RenderSurface,
    SurfaceHolder.Callback {
        @NonNull
        private final SurfaceView mSurfaceView;

        SurfaceViewHandler(SurfaceView surfaceView) {
            Surface surface;
            this.mSurfaceView = surfaceView;
            SurfaceHolder holder = surfaceView.getHolder();
            holder.addCallback((SurfaceHolder.Callback)this);
            if (UiHelper.this.mDesiredWidth > 0 && UiHelper.this.mDesiredHeight > 0) {
                holder.setFixedSize(UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
            }
            if ((surface = holder.getSurface()) != null && surface.isValid()) {
                this.surfaceCreated(holder);
                this.surfaceChanged(holder, 1, holder.getSurfaceFrame().width(), holder.getSurfaceFrame().height());
            }
        }

        @Override
        public void resize(int width, int height) {
            SurfaceHolder holder = this.mSurfaceView.getHolder();
            holder.setFixedSize(width, height);
        }

        @Override
        public void detach() {
            SurfaceHolder holder = this.mSurfaceView.getHolder();
            holder.removeCallback((SurfaceHolder.Callback)this);
        }

        public void surfaceCreated(@NonNull SurfaceHolder holder) {
            UiHelper.this.createSwapChain(holder.getSurface());
        }

        public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
            if (UiHelper.this.mRenderCallback != null) {
                UiHelper.this.mRenderCallback.onResized(width, height);
            }
        }

        public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
            UiHelper.this.destroySwapChain();
        }
    }

    private class TextureViewHandler
    implements RenderSurface,
    TextureView.SurfaceTextureListener {
        private final TextureView mTextureView;
        private Surface mSurface;

        TextureViewHandler(TextureView view) {
            SurfaceTexture surfaceTexture;
            this.mTextureView = view;
            this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            if (view.isAvailable() && (surfaceTexture = view.getSurfaceTexture()) != null) {
                this.onSurfaceTextureAvailable(surfaceTexture, UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
            }
        }

        @Override
        public void resize(int width, int height) {
            SurfaceTexture surfaceTexture;
            if (Build.VERSION.SDK_INT >= 15 && (surfaceTexture = this.mTextureView.getSurfaceTexture()) != null) {
                surfaceTexture.setDefaultBufferSize(width, height);
            }
            if (UiHelper.this.mRenderCallback != null) {
                UiHelper.this.mRenderCallback.onResized(width, height);
            }
        }

        @Override
        public void detach() {
            this.mTextureView.setSurfaceTextureListener(null);
        }

        public void onSurfaceTextureAvailable(@NonNull SurfaceTexture surfaceTexture, int width, int height) {
            if (Build.VERSION.SDK_INT >= 15 && UiHelper.this.mDesiredWidth > 0 && UiHelper.this.mDesiredHeight > 0) {
                surfaceTexture.setDefaultBufferSize(UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
            }
            Surface surface = new Surface(surfaceTexture);
            this.setSurface(surface);
            UiHelper.this.createSwapChain(surface);
            if (UiHelper.this.mRenderCallback != null) {
                UiHelper.this.mRenderCallback.onResized(width, height);
            }
        }

        public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surfaceTexture, int width, int height) {
            if (UiHelper.this.mRenderCallback != null) {
                if (UiHelper.this.mDesiredWidth > 0 && UiHelper.this.mDesiredHeight > 0) {
                    surfaceTexture.setDefaultBufferSize(UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
                    UiHelper.this.mRenderCallback.onResized(UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
                } else {
                    UiHelper.this.mRenderCallback.onResized(width, height);
                }
                Surface surface = this.getSurface();
                if (surface != null) {
                    UiHelper.this.mRenderCallback.onNativeWindowChanged(surface);
                }
            }
        }

        public boolean onSurfaceTextureDestroyed(@NonNull SurfaceTexture surfaceTexture) {
            this.setSurface(null);
            UiHelper.this.destroySwapChain();
            return true;
        }

        public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surface) {
        }

        private void setSurface(@Nullable Surface surface) {
            if (surface == null && this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
        }

        private Surface getSurface() {
            return this.mSurface;
        }
    }

    private class SurfaceHolderHandler
    implements RenderSurface,
    SurfaceHolder.Callback {
        private final SurfaceHolder mSurfaceHolder;

        SurfaceHolderHandler(SurfaceHolder holder) {
            Surface surface;
            this.mSurfaceHolder = holder;
            holder.addCallback((SurfaceHolder.Callback)this);
            if (UiHelper.this.mDesiredWidth > 0 && UiHelper.this.mDesiredHeight > 0) {
                holder.setFixedSize(UiHelper.this.mDesiredWidth, UiHelper.this.mDesiredHeight);
            }
            if ((surface = holder.getSurface()) != null && surface.isValid()) {
                this.surfaceCreated(holder);
                this.surfaceChanged(holder, 1, holder.getSurfaceFrame().width(), holder.getSurfaceFrame().height());
            }
        }

        @Override
        public void resize(int width, int height) {
            this.mSurfaceHolder.setFixedSize(width, height);
        }

        @Override
        public void detach() {
            this.mSurfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }

        public void surfaceCreated(@NonNull SurfaceHolder holder) {
            UiHelper.this.createSwapChain(holder.getSurface());
        }

        public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
            if (UiHelper.this.mRenderCallback != null) {
                UiHelper.this.mRenderCallback.onResized(width, height);
            }
        }

        public void surfaceDestroyed(@NonNull SurfaceHolder surfaceHolder) {
            UiHelper.this.destroySwapChain();
        }
    }
}

