/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import com.google.android.filament.Colors;
import com.google.android.filament.Engine;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.Texture;
import com.google.android.filament.TextureSampler;
import com.google.android.filament.VertexBuffer;
import com.google.android.filament.proguard.UsedByNative;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class Material {
    private long mNativeObject;
    private final MaterialInstance mDefaultInstance;
    private Set<VertexBuffer.VertexAttribute> mRequiredAttributes;

    Material(long nativeMaterial) {
        this.mNativeObject = nativeMaterial;
        long nativeDefaultInstance = Material.nGetDefaultInstance(nativeMaterial);
        this.mDefaultInstance = new MaterialInstance(this, nativeDefaultInstance);
    }

    @NonNull
    public MaterialInstance createInstance() {
        long nativeInstance = Material.nCreateInstance(this.getNativeObject());
        if (nativeInstance == 0L) {
            throw new IllegalStateException("Couldn't create MaterialInstance");
        }
        return new MaterialInstance(this, nativeInstance);
    }

    @NonNull
    public MaterialInstance createInstance(@NonNull String name) {
        long nativeInstance = Material.nCreateInstanceWithName(this.getNativeObject(), name);
        if (nativeInstance == 0L) {
            throw new IllegalStateException("Couldn't create MaterialInstance");
        }
        return new MaterialInstance(this, nativeInstance);
    }

    @NonNull
    public MaterialInstance getDefaultInstance() {
        return this.mDefaultInstance;
    }

    public String getName() {
        return Material.nGetName(this.getNativeObject());
    }

    public Shading getShading() {
        return Shading.values()[Material.nGetShading(this.getNativeObject())];
    }

    public Interpolation getInterpolation() {
        return Interpolation.values()[Material.nGetInterpolation(this.getNativeObject())];
    }

    public BlendingMode getBlendingMode() {
        return BlendingMode.values()[Material.nGetBlendingMode(this.getNativeObject())];
    }

    public RefractionMode getRefractionMode() {
        return RefractionMode.values()[Material.nGetRefractionMode(this.getNativeObject())];
    }

    public RefractionType getRefractionType() {
        return RefractionType.values()[Material.nGetRefractionType(this.getNativeObject())];
    }

    public VertexDomain getVertexDomain() {
        return VertexDomain.values()[Material.nGetVertexDomain(this.getNativeObject())];
    }

    public CullingMode getCullingMode() {
        return CullingMode.values()[Material.nGetCullingMode(this.getNativeObject())];
    }

    public boolean isColorWriteEnabled() {
        return Material.nIsColorWriteEnabled(this.getNativeObject());
    }

    public boolean isDepthWriteEnabled() {
        return Material.nIsDepthWriteEnabled(this.getNativeObject());
    }

    public boolean isDepthCullingEnabled() {
        return Material.nIsDepthCullingEnabled(this.getNativeObject());
    }

    public boolean isDoubleSided() {
        return Material.nIsDoubleSided(this.getNativeObject());
    }

    public float getMaskThreshold() {
        return Material.nGetMaskThreshold(this.getNativeObject());
    }

    public float getSpecularAntiAliasingVariance() {
        return Material.nGetSpecularAntiAliasingVariance(this.getNativeObject());
    }

    public float getSpecularAntiAliasingThreshold() {
        return Material.nGetSpecularAntiAliasingThreshold(this.getNativeObject());
    }

    public Set<VertexBuffer.VertexAttribute> getRequiredAttributes() {
        if (this.mRequiredAttributes == null) {
            int bitSet = Material.nGetRequiredAttributes(this.getNativeObject());
            this.mRequiredAttributes = EnumSet.noneOf(VertexBuffer.VertexAttribute.class);
            VertexBuffer.VertexAttribute[] values = VertexBuffer.VertexAttribute.values();
            for (int i = 0; i < values.length; ++i) {
                if ((bitSet & 1 << i) == 0) continue;
                this.mRequiredAttributes.add(values[i]);
            }
            this.mRequiredAttributes = Collections.unmodifiableSet(this.mRequiredAttributes);
        }
        return this.mRequiredAttributes;
    }

    int getRequiredAttributesAsInt() {
        return Material.nGetRequiredAttributes(this.getNativeObject());
    }

    public int getParameterCount() {
        return Material.nGetParameterCount(this.getNativeObject());
    }

    public List<Parameter> getParameters() {
        int count = this.getParameterCount();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(count);
        if (count > 0) {
            Material.nGetParameters(this.getNativeObject(), parameters, count);
        }
        return parameters;
    }

    public boolean hasParameter(@NonNull String name) {
        return Material.nHasParameter(this.getNativeObject(), name);
    }

    public void setDefaultParameter(@NonNull String name, boolean x) {
        this.mDefaultInstance.setParameter(name, x);
    }

    public void setDefaultParameter(@NonNull String name, float x) {
        this.mDefaultInstance.setParameter(name, x);
    }

    public void setDefaultParameter(@NonNull String name, int x) {
        this.mDefaultInstance.setParameter(name, x);
    }

    public void setDefaultParameter(@NonNull String name, boolean x, boolean y) {
        this.mDefaultInstance.setParameter(name, x, y);
    }

    public void setDefaultParameter(@NonNull String name, float x, float y) {
        this.mDefaultInstance.setParameter(name, x, y);
    }

    public void setDefaultParameter(@NonNull String name, int x, int y) {
        this.mDefaultInstance.setParameter(name, x, y);
    }

    public void setDefaultParameter(@NonNull String name, boolean x, boolean y, boolean z) {
        this.mDefaultInstance.setParameter(name, x, y, z);
    }

    public void setDefaultParameter(@NonNull String name, float x, float y, float z) {
        this.mDefaultInstance.setParameter(name, x, y, z);
    }

    public void setDefaultParameter(@NonNull String name, int x, int y, int z) {
        this.mDefaultInstance.setParameter(name, x, y, z);
    }

    public void setDefaultParameter(@NonNull String name, boolean x, boolean y, boolean z, boolean w) {
        this.mDefaultInstance.setParameter(name, x, y, z, w);
    }

    public void setDefaultParameter(@NonNull String name, float x, float y, float z, float w) {
        this.mDefaultInstance.setParameter(name, x, y, z, w);
    }

    public void setDefaultParameter(@NonNull String name, int x, int y, int z, int w) {
        this.mDefaultInstance.setParameter(name, x, y, z, w);
    }

    public void setDefaultParameter(@NonNull String name, @NonNull MaterialInstance.BooleanElement type, @NonNull @Size(min=1L) boolean[] v, @IntRange(from=0L) int offset, @IntRange(from=1L) int count) {
        this.mDefaultInstance.setParameter(name, type, v, offset, count);
    }

    public void setDefaultParameter(@NonNull String name, @NonNull MaterialInstance.IntElement type, @NonNull @Size(min=1L) int[] v, @IntRange(from=0L) int offset, @IntRange(from=1L) int count) {
        this.mDefaultInstance.setParameter(name, type, v, offset, count);
    }

    public void setDefaultParameter(@NonNull String name, @NonNull MaterialInstance.FloatElement type, @NonNull @Size(min=1L) float[] v, @IntRange(from=0L) int offset, @IntRange(from=1L) int count) {
        this.mDefaultInstance.setParameter(name, type, v, offset, count);
    }

    public void setDefaultParameter(@NonNull String name, @NonNull Colors.RgbType type, float r, float g, float b) {
        this.mDefaultInstance.setParameter(name, type, r, g, b);
    }

    public void setDefaultParameter(@NonNull String name, @NonNull Colors.RgbaType type, float r, float g, float b, float a) {
        this.mDefaultInstance.setParameter(name, type, r, g, b, a);
    }

    public void setDefaultParameter(@NonNull String name, @NonNull Texture texture, @NonNull TextureSampler sampler) {
        this.mDefaultInstance.setParameter(name, texture, sampler);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Material");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nBuilderBuild(long var0, @NonNull Buffer var2, int var3);

    private static native long nCreateInstance(long var0);

    private static native long nCreateInstanceWithName(long var0, @NonNull String var2);

    private static native long nGetDefaultInstance(long var0);

    private static native String nGetName(long var0);

    private static native int nGetShading(long var0);

    private static native int nGetInterpolation(long var0);

    private static native int nGetBlendingMode(long var0);

    private static native int nGetVertexDomain(long var0);

    private static native int nGetCullingMode(long var0);

    private static native boolean nIsColorWriteEnabled(long var0);

    private static native boolean nIsDepthWriteEnabled(long var0);

    private static native boolean nIsDepthCullingEnabled(long var0);

    private static native boolean nIsDoubleSided(long var0);

    private static native float nGetMaskThreshold(long var0);

    private static native float nGetSpecularAntiAliasingVariance(long var0);

    private static native float nGetSpecularAntiAliasingThreshold(long var0);

    private static native int nGetRefractionMode(long var0);

    private static native int nGetRefractionType(long var0);

    private static native int nGetParameterCount(long var0);

    private static native void nGetParameters(long var0, @NonNull List<Parameter> var2, @IntRange(from=1L) int var3);

    private static native int nGetRequiredAttributes(long var0);

    private static native boolean nHasParameter(long var0, @NonNull String var2);

    public static class Builder {
        private Buffer mBuffer;
        private int mSize;

        @NonNull
        public Builder payload(@NonNull Buffer buffer, @IntRange(from=0L) int size) {
            this.mBuffer = buffer;
            this.mSize = size;
            return this;
        }

        @NonNull
        public Material build(@NonNull Engine engine) {
            long nativeMaterial = Material.nBuilderBuild(engine.getNativeObject(), this.mBuffer, this.mSize);
            if (nativeMaterial == 0L) {
                throw new IllegalStateException("Couldn't create Material");
            }
            return new Material(nativeMaterial);
        }
    }

    @UsedByNative(value="Material.cpp")
    public static class Parameter {
        @UsedByNative(value="Material.cpp")
        private static final int SAMPLER_OFFSET = Type.MAT4.ordinal() + 1;
        @NonNull
        public final String name;
        @NonNull
        public final Type type;
        @NonNull
        public final Precision precision;
        @IntRange(from=1L)
        public final int count;

        private Parameter(@NonNull String name, @NonNull Type type, @NonNull Precision precision, @IntRange(from=1L) int count) {
            this.name = name;
            this.type = type;
            this.precision = precision;
            this.count = count;
        }

        @UsedByNative(value="Material.cpp")
        private static void add(@NonNull List<Parameter> parameters, @NonNull String name, @IntRange(from=0L) int type, @IntRange(from=0L) int precision, @IntRange(from=1L) int count) {
            parameters.add(new Parameter(name, Type.values()[type], Precision.values()[precision], count));
        }

        public static enum Precision {
            LOW,
            MEDIUM,
            HIGH,
            DEFAULT;

        }

        public static enum Type {
            BOOL,
            BOOL2,
            BOOL3,
            BOOL4,
            FLOAT,
            FLOAT2,
            FLOAT3,
            FLOAT4,
            INT,
            INT2,
            INT3,
            INT4,
            UINT,
            UINT2,
            UINT3,
            UINT4,
            MAT3,
            MAT4,
            SAMPLER_2D,
            SAMPLER_CUBEMAP,
            SAMPLER_EXTERNAL;

        }
    }

    public static enum CullingMode {
        NONE,
        FRONT,
        BACK,
        FRONT_AND_BACK;

    }

    public static enum VertexDomain {
        OBJECT,
        WORLD,
        VIEW,
        DEVICE;

    }

    public static enum RefractionType {
        SOLID,
        THIN;

    }

    public static enum RefractionMode {
        NONE,
        CUBEMAP,
        SCREEN_SPACE;

    }

    public static enum BlendingMode {
        OPAQUE,
        TRANSPARENT,
        ADD,
        MASKED,
        FADE,
        MULTIPLY,
        SCREEN;

    }

    public static enum Interpolation {
        SMOOTH,
        FLAT;

    }

    public static enum Shading {
        UNLIT,
        LIT,
        SUBSURFACE,
        CLOTH,
        SPECULAR_GLOSSINESS;

    }
}

