/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Engine;
import com.google.android.filament.Texture;

public class RenderTarget {
    private long mNativeObject;
    private final Texture[] mTextures = new Texture[2];

    private RenderTarget(long nativeRenderTarget, Builder builder) {
        this.mNativeObject = nativeRenderTarget;
        this.mTextures[0] = builder.mTextures[0];
        this.mTextures[1] = builder.mTextures[1];
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed RenderTarget");
        }
        return this.mNativeObject;
    }

    @Nullable
    public Texture getTexture(@NonNull AttachmentPoint attachment) {
        return this.mTextures[attachment.ordinal()];
    }

    @IntRange(from=0L)
    public int getMipLevel(@NonNull AttachmentPoint attachment) {
        return RenderTarget.nGetMipLevel(this.getNativeObject(), attachment.ordinal());
    }

    public Texture.CubemapFace getFace(AttachmentPoint attachment) {
        return Texture.CubemapFace.values()[RenderTarget.nGetFace(this.getNativeObject(), attachment.ordinal())];
    }

    @IntRange(from=0L)
    public int getLayer(@NonNull AttachmentPoint attachment) {
        return RenderTarget.nGetLayer(this.getNativeObject(), attachment.ordinal());
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native long nCreateBuilder();

    private static native void nDestroyBuilder(long var0);

    private static native void nBuilderTexture(long var0, int var2, long var3);

    private static native void nBuilderMipLevel(long var0, int var2, int var3);

    private static native void nBuilderFace(long var0, int var2, int var3);

    private static native void nBuilderLayer(long var0, int var2, int var3);

    private static native long nBuilderBuild(long var0, long var2);

    private static native int nGetMipLevel(long var0, int var2);

    private static native int nGetFace(long var0, int var2);

    private static native int nGetLayer(long var0, int var2);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder;
        private final Texture[] mTextures = new Texture[2];

        public Builder() {
            this.mNativeBuilder = RenderTarget.nCreateBuilder();
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder texture(@NonNull AttachmentPoint attachment, @Nullable Texture texture) {
            this.mTextures[attachment.ordinal()] = texture;
            RenderTarget.nBuilderTexture(this.mNativeBuilder, attachment.ordinal(), texture != null ? texture.getNativeObject() : 0L);
            return this;
        }

        @NonNull
        public Builder mipLevel(@NonNull AttachmentPoint attachment, @IntRange(from=0L) int level) {
            RenderTarget.nBuilderMipLevel(this.mNativeBuilder, attachment.ordinal(), level);
            return this;
        }

        @NonNull
        public Builder face(@NonNull AttachmentPoint attachment, Texture.CubemapFace face) {
            RenderTarget.nBuilderFace(this.mNativeBuilder, attachment.ordinal(), face.ordinal());
            return this;
        }

        @NonNull
        public Builder layer(@NonNull AttachmentPoint attachment, @IntRange(from=0L) int layer) {
            RenderTarget.nBuilderLayer(this.mNativeBuilder, attachment.ordinal(), layer);
            return this;
        }

        @NonNull
        public RenderTarget build(@NonNull Engine engine) {
            long nativeRenderTarget = RenderTarget.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject());
            if (nativeRenderTarget == 0L) {
                throw new IllegalStateException("Couldn't create RenderTarget");
            }
            return new RenderTarget(nativeRenderTarget, this);
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    RenderTarget.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static enum AttachmentPoint {
        COLOR,
        DEPTH;

    }
}

