/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.google.android.filament.Engine;
import com.google.android.filament.RenderTarget;
import com.google.android.filament.SwapChain;
import com.google.android.filament.Texture;
import com.google.android.filament.View;
import com.google.android.filament.Viewport;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ReadOnlyBufferException;

public class Renderer {
    private final Engine mEngine;
    private long mNativeObject;
    private DisplayInfo mDisplayInfo;
    private FrameRateOptions mFrameRateOptions;
    private ClearOptions mClearOptions;
    public static final int MIRROR_FRAME_FLAG_COMMIT = 1;
    public static final int MIRROR_FRAME_FLAG_SET_PRESENTATION_TIME = 2;
    public static final int MIRROR_FRAME_FLAG_CLEAR = 4;

    Renderer(@NonNull Engine engine, long nativeRenderer) {
        this.mEngine = engine;
        this.mNativeObject = nativeRenderer;
    }

    public void setDisplayInfo(@NonNull DisplayInfo info) {
        this.mDisplayInfo = info;
        Renderer.nSetDisplayInfo(this.getNativeObject(), info.refreshRate, info.presentationDeadlineNanos, info.vsyncOffsetNanos);
    }

    @NonNull
    public DisplayInfo getDisplayInfo() {
        if (this.mDisplayInfo == null) {
            this.mDisplayInfo = new DisplayInfo();
        }
        return this.mDisplayInfo;
    }

    public void setFrameRateOptions(@NonNull FrameRateOptions options) {
        this.mFrameRateOptions = options;
        Renderer.nSetFrameRateOptions(this.getNativeObject(), options.interval, options.headRoomRatio, options.scaleRate, options.history);
    }

    @NonNull
    public FrameRateOptions getFrameRateOptions() {
        if (this.mFrameRateOptions == null) {
            this.mFrameRateOptions = new FrameRateOptions();
        }
        return this.mFrameRateOptions;
    }

    public void setClearOptions(@NonNull ClearOptions options) {
        this.mClearOptions = options;
        Renderer.nSetClearOptions(this.getNativeObject(), options.clearColor[0], options.clearColor[1], options.clearColor[2], options.clearColor[3], options.clear, options.discard);
    }

    @NonNull
    public ClearOptions getClearOptions() {
        if (this.mClearOptions == null) {
            this.mClearOptions = new ClearOptions();
        }
        return this.mClearOptions;
    }

    @NonNull
    public Engine getEngine() {
        return this.mEngine;
    }

    public boolean beginFrame(@NonNull SwapChain swapChain, long frameTimeNanos) {
        return Renderer.nBeginFrame(this.getNativeObject(), swapChain.getNativeObject(), frameTimeNanos);
    }

    public void endFrame() {
        Renderer.nEndFrame(this.getNativeObject());
    }

    public void render(@NonNull View view) {
        Renderer.nRender(this.getNativeObject(), view.getNativeObject());
    }

    public void copyFrame(@NonNull SwapChain dstSwapChain, @NonNull Viewport dstViewport, @NonNull Viewport srcViewport, int flags) {
        Renderer.nCopyFrame(this.getNativeObject(), dstSwapChain.getNativeObject(), dstViewport.left, dstViewport.bottom, dstViewport.width, dstViewport.height, srcViewport.left, srcViewport.bottom, srcViewport.width, srcViewport.height, flags);
    }

    @Deprecated
    public void mirrorFrame(@NonNull SwapChain dstSwapChain, @NonNull Viewport dstViewport, @NonNull Viewport srcViewport, int flags) {
        this.copyFrame(dstSwapChain, dstViewport, srcViewport, flags);
    }

    public void readPixels(@IntRange(from=0L) int xoffset, @IntRange(from=0L) int yoffset, @IntRange(from=0L) int width, @IntRange(from=0L) int height, @NonNull Texture.PixelBufferDescriptor buffer) {
        if (buffer.storage.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int result = Renderer.nReadPixels(this.getNativeObject(), this.mEngine.getNativeObject(), xoffset, yoffset, width, height, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), buffer.handler, buffer.callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public void readPixels(@NonNull RenderTarget renderTarget, @IntRange(from=0L) int xoffset, @IntRange(from=0L) int yoffset, @IntRange(from=0L) int width, @IntRange(from=0L) int height, @NonNull Texture.PixelBufferDescriptor buffer) {
        if (buffer.storage.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int result = Renderer.nReadPixelsEx(this.getNativeObject(), this.mEngine.getNativeObject(), renderTarget.getNativeObject(), xoffset, yoffset, width, height, buffer.storage, buffer.storage.remaining(), buffer.left, buffer.top, buffer.type.ordinal(), buffer.alignment, buffer.stride, buffer.format.ordinal(), buffer.handler, buffer.callback);
        if (result < 0) {
            throw new BufferOverflowException();
        }
    }

    public double getUserTime() {
        return Renderer.nGetUserTime(this.getNativeObject());
    }

    public void resetUserTime() {
        Renderer.nResetUserTime(this.getNativeObject());
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed Renderer");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native boolean nBeginFrame(long var0, long var2, long var4);

    private static native void nEndFrame(long var0);

    private static native void nRender(long var0, long var2);

    private static native void nCopyFrame(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private static native int nReadPixels(long var0, long var2, int var4, int var5, int var6, int var7, Buffer var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, Object var16, Runnable var17);

    private static native int nReadPixelsEx(long var0, long var2, long var4, int var6, int var7, int var8, int var9, Buffer var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, Object var18, Runnable var19);

    private static native double nGetUserTime(long var0);

    private static native void nResetUserTime(long var0);

    private static native void nSetDisplayInfo(long var0, float var2, long var3, long var5);

    private static native void nSetFrameRateOptions(long var0, float var2, float var3, float var4, int var5);

    private static native void nSetClearOptions(long var0, float var2, float var3, float var4, float var5, boolean var6, boolean var7);

    public static class ClearOptions {
        @NonNull
        public float[] clearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        public boolean clear = false;
        public boolean discard = true;
    }

    public static class FrameRateOptions {
        public float interval = 0.016666668f;
        public float headRoomRatio = 0.0f;
        public float scaleRate = 0.125f;
        public int history = 9;
    }

    public static class DisplayInfo {
        public float refreshRate = 60.0f;
        public long presentationDeadlineNanos = 0L;
        public long vsyncOffsetNanos = 0L;
    }
}

