/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.Asserts;
import com.google.android.filament.Entity;
import com.google.android.filament.EntityInstance;

public class TransformManager {
    private long mNativeObject;

    TransformManager(long nativeTransformManager) {
        this.mNativeObject = nativeTransformManager;
    }

    public boolean hasComponent(@Entity int entity) {
        return TransformManager.nHasComponent(this.mNativeObject, entity);
    }

    @EntityInstance
    public int getInstance(@Entity int entity) {
        return TransformManager.nGetInstance(this.mNativeObject, entity);
    }

    @EntityInstance
    public int create(@Entity int entity) {
        return TransformManager.nCreate(this.mNativeObject, entity);
    }

    @EntityInstance
    public int create(@Entity int entity, @EntityInstance int parent, @Nullable @Size(min=16L) float[] localTransform) {
        return TransformManager.nCreateArray(this.mNativeObject, entity, parent, localTransform);
    }

    public void destroy(@Entity int entity) {
        TransformManager.nDestroy(this.mNativeObject, entity);
    }

    public void setParent(@EntityInstance int i, @EntityInstance int newParent) {
        TransformManager.nSetParent(this.mNativeObject, i, newParent);
    }

    public void setTransform(@EntityInstance int i, @NonNull @Size(min=16L) float[] localTransform) {
        Asserts.assertMat4fIn(localTransform);
        TransformManager.nSetTransform(this.mNativeObject, i, localTransform);
    }

    @NonNull
    @Size(min=16L)
    public float[] getTransform(@EntityInstance int i, @Nullable @Size(min=16L) float[] outLocalTransform) {
        outLocalTransform = Asserts.assertMat4f(outLocalTransform);
        TransformManager.nGetTransform(this.mNativeObject, i, outLocalTransform);
        return outLocalTransform;
    }

    @NonNull
    @Size(min=16L)
    public float[] getWorldTransform(@EntityInstance int i, @Nullable @Size(min=16L) float[] outWorldTransform) {
        outWorldTransform = Asserts.assertMat4f(outWorldTransform);
        TransformManager.nGetWorldTransform(this.mNativeObject, i, outWorldTransform);
        return outWorldTransform;
    }

    public void openLocalTransformTransaction() {
        TransformManager.nOpenLocalTransformTransaction(this.mNativeObject);
    }

    public void commitLocalTransformTransaction() {
        TransformManager.nCommitLocalTransformTransaction(this.mNativeObject);
    }

    public long getNativeObject() {
        return this.mNativeObject;
    }

    private static native boolean nHasComponent(long var0, int var2);

    private static native int nGetInstance(long var0, int var2);

    private static native int nCreate(long var0, int var2);

    private static native int nCreateArray(long var0, int var2, int var3, float[] var4);

    private static native void nDestroy(long var0, int var2);

    private static native void nSetParent(long var0, int var2, int var3);

    private static native void nSetTransform(long var0, int var2, float[] var3);

    private static native void nGetTransform(long var0, int var2, float[] var3);

    private static native void nGetWorldTransform(long var0, int var2, float[] var3);

    private static native void nOpenLocalTransformTransaction(long var0);

    private static native void nCommitLocalTransformTransaction(long var0);
}

