/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Camera;
import com.google.android.filament.RenderTarget;
import com.google.android.filament.Scene;
import com.google.android.filament.Texture;
import com.google.android.filament.Viewport;
import java.util.EnumSet;

public class View {
    private long mNativeObject;
    private String mName;
    private Scene mScene;
    private Camera mCamera;
    private Viewport mViewport = new Viewport(0, 0, 0, 0);
    private DynamicResolutionOptions mDynamicResolution;
    private RenderQuality mRenderQuality;
    private AmbientOcclusionOptions mAmbientOcclusionOptions;
    private BloomOptions mBloomOptions;
    private FogOptions mFogOptions;
    private RenderTarget mRenderTarget;
    private BlendMode mBlendMode;
    private DepthOfFieldOptions mDepthOfFieldOptions;

    View(long nativeView) {
        this.mNativeObject = nativeView;
    }

    public void setName(@NonNull String name) {
        this.mName = name;
        View.nSetName(this.getNativeObject(), name);
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public void setScene(@Nullable Scene scene) {
        this.mScene = scene;
        View.nSetScene(this.getNativeObject(), scene == null ? 0L : scene.getNativeObject());
    }

    @Nullable
    public Scene getScene() {
        return this.mScene;
    }

    public void setCamera(@Nullable Camera camera) {
        this.mCamera = camera;
        View.nSetCamera(this.getNativeObject(), camera == null ? 0L : camera.getNativeObject());
    }

    @Nullable
    public Camera getCamera() {
        return this.mCamera;
    }

    public void setViewport(@NonNull Viewport viewport) {
        this.mViewport = viewport;
        View.nSetViewport(this.getNativeObject(), this.mViewport.left, this.mViewport.bottom, this.mViewport.width, this.mViewport.height);
    }

    @NonNull
    public Viewport getViewport() {
        return this.mViewport;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.mBlendMode = blendMode;
        View.nSetBlendMode(this.getNativeObject(), blendMode.ordinal());
    }

    public BlendMode getBlendMode() {
        return this.mBlendMode;
    }

    public void setVisibleLayers(@IntRange(from=0L, to=255L) int select, @IntRange(from=0L, to=255L) int values) {
        View.nSetVisibleLayers(this.getNativeObject(), select & 0xFF, values & 0xFF);
    }

    public void setShadowsEnabled(boolean enabled) {
        View.nSetShadowsEnabled(this.getNativeObject(), enabled);
    }

    public void setRenderTarget(@Nullable RenderTarget target) {
        this.mRenderTarget = target;
        View.nSetRenderTarget(this.getNativeObject(), target != null ? target.getNativeObject() : 0L);
    }

    @Nullable
    public RenderTarget getRenderTarget() {
        return this.mRenderTarget;
    }

    public void setSampleCount(int count) {
        View.nSetSampleCount(this.getNativeObject(), count);
    }

    public int getSampleCount() {
        return View.nGetSampleCount(this.getNativeObject());
    }

    public void setAntiAliasing(@NonNull AntiAliasing type) {
        View.nSetAntiAliasing(this.getNativeObject(), type.ordinal());
    }

    @NonNull
    public AntiAliasing getAntiAliasing() {
        return AntiAliasing.values()[View.nGetAntiAliasing(this.getNativeObject())];
    }

    public void setToneMapping(@NonNull ToneMapping type) {
        View.nSetToneMapping(this.getNativeObject(), type.ordinal());
    }

    @NonNull
    public ToneMapping getToneMapping() {
        return ToneMapping.values()[View.nGetToneMapping(this.getNativeObject())];
    }

    public void setDithering(@NonNull Dithering dithering) {
        View.nSetDithering(this.getNativeObject(), dithering.ordinal());
    }

    @NonNull
    public Dithering getDithering() {
        return Dithering.values()[View.nGetDithering(this.getNativeObject())];
    }

    public void setDynamicResolutionOptions(@NonNull DynamicResolutionOptions options) {
        this.mDynamicResolution = options;
        View.nSetDynamicResolutionOptions(this.getNativeObject(), options.enabled, options.homogeneousScaling, options.minScale, options.maxScale, options.quality.ordinal());
    }

    @NonNull
    public DynamicResolutionOptions getDynamicResolutionOptions() {
        if (this.mDynamicResolution == null) {
            this.mDynamicResolution = new DynamicResolutionOptions();
        }
        return this.mDynamicResolution;
    }

    public void setRenderQuality(@NonNull RenderQuality renderQuality) {
        this.mRenderQuality = renderQuality;
        View.nSetRenderQuality(this.getNativeObject(), renderQuality.hdrColorBuffer.ordinal());
    }

    @NonNull
    public RenderQuality getRenderQuality() {
        if (this.mRenderQuality == null) {
            this.mRenderQuality = new RenderQuality();
        }
        return this.mRenderQuality;
    }

    public boolean isPostProcessingEnabled() {
        return View.nIsPostProcessingEnabled(this.getNativeObject());
    }

    public void setPostProcessingEnabled(boolean enabled) {
        View.nSetPostProcessingEnabled(this.getNativeObject(), enabled);
    }

    public boolean isFrontFaceWindingInverted() {
        return View.nIsFrontFaceWindingInverted(this.getNativeObject());
    }

    public void setFrontFaceWindingInverted(boolean inverted) {
        View.nSetFrontFaceWindingInverted(this.getNativeObject(), inverted);
    }

    public void setDynamicLightingOptions(float zLightNear, float zLightFar) {
        View.nSetDynamicLightingOptions(this.getNativeObject(), zLightNear, zLightFar);
    }

    public void setAmbientOcclusion(@NonNull AmbientOcclusion ao) {
        View.nSetAmbientOcclusion(this.getNativeObject(), ao.ordinal());
    }

    @NonNull
    public AmbientOcclusion getAmbientOcclusion() {
        return AmbientOcclusion.values()[View.nGetAmbientOcclusion(this.getNativeObject())];
    }

    public void setAmbientOcclusionOptions(@NonNull AmbientOcclusionOptions options) {
        this.mAmbientOcclusionOptions = options;
        View.nSetAmbientOcclusionOptions(this.getNativeObject(), options.radius, options.bias, options.power, options.resolution, options.intensity, options.quality.ordinal());
    }

    @NonNull
    public AmbientOcclusionOptions getAmbientOcclusionOptions() {
        if (this.mAmbientOcclusionOptions == null) {
            this.mAmbientOcclusionOptions = new AmbientOcclusionOptions();
        }
        return this.mAmbientOcclusionOptions;
    }

    public void setBloomOptions(@NonNull BloomOptions options) {
        this.mBloomOptions = options;
        View.nSetBloomOptions(this.getNativeObject(), options.dirt != null ? options.dirt.getNativeObject() : 0L, options.dirtStrength, options.strength, options.resolution, options.anamorphism, options.levels, options.blendingMode.ordinal(), options.threshold, options.enabled);
    }

    @NonNull
    public BloomOptions getBloomOptions() {
        if (this.mBloomOptions == null) {
            this.mBloomOptions = new BloomOptions();
        }
        return this.mBloomOptions;
    }

    public void setFogOptions(@NonNull FogOptions options) {
        this.mFogOptions = options;
        View.nSetFogOptions(this.getNativeObject(), options.distance, options.maximumOpacity, options.height, options.heightFalloff, options.color[0], options.color[1], options.color[2], options.density, options.inScatteringStart, options.inScatteringSize, options.fogColorFromIbl, options.enabled);
    }

    @NonNull
    public FogOptions getFogOptions() {
        if (this.mFogOptions == null) {
            this.mFogOptions = new FogOptions();
        }
        return this.mFogOptions;
    }

    public void setDepthOfFieldOptions(@NonNull DepthOfFieldOptions options) {
        this.mDepthOfFieldOptions = options;
        View.nSetDepthOfFieldOptions(this.getNativeObject(), options.focusDistance, options.blurScale, options.maxApertureDiameter, options.enabled);
    }

    @NonNull
    public DepthOfFieldOptions getDepthOfFieldOptions() {
        if (this.mDepthOfFieldOptions == null) {
            this.mDepthOfFieldOptions = new DepthOfFieldOptions();
        }
        return this.mDepthOfFieldOptions;
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed View");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nSetName(long var0, String var2);

    private static native void nSetScene(long var0, long var2);

    private static native void nSetCamera(long var0, long var2);

    private static native void nSetViewport(long var0, int var2, int var3, int var4, int var5);

    private static native void nSetVisibleLayers(long var0, int var2, int var3);

    private static native void nSetShadowsEnabled(long var0, boolean var2);

    private static native void nSetRenderTarget(long var0, long var2);

    private static native void nSetSampleCount(long var0, int var2);

    private static native int nGetSampleCount(long var0);

    private static native void nSetAntiAliasing(long var0, int var2);

    private static native int nGetAntiAliasing(long var0);

    private static native void nSetToneMapping(long var0, int var2);

    private static native int nGetToneMapping(long var0);

    private static native void nSetDithering(long var0, int var2);

    private static native int nGetDithering(long var0);

    private static native void nSetDynamicResolutionOptions(long var0, boolean var2, boolean var3, float var4, float var5, int var6);

    private static native void nSetRenderQuality(long var0, int var2);

    private static native void nSetDynamicLightingOptions(long var0, float var2, float var3);

    private static native void nSetPostProcessingEnabled(long var0, boolean var2);

    private static native boolean nIsPostProcessingEnabled(long var0);

    private static native void nSetFrontFaceWindingInverted(long var0, boolean var2);

    private static native boolean nIsFrontFaceWindingInverted(long var0);

    private static native void nSetAmbientOcclusion(long var0, int var2);

    private static native int nGetAmbientOcclusion(long var0);

    private static native void nSetAmbientOcclusionOptions(long var0, float var2, float var3, float var4, float var5, float var6, int var7);

    private static native void nSetBloomOptions(long var0, long var2, float var4, float var5, int var6, float var7, int var8, int var9, boolean var10, boolean var11);

    private static native void nSetFogOptions(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, boolean var12, boolean var13);

    private static native void nSetBlendMode(long var0, int var2);

    private static native void nSetDepthOfFieldOptions(long var0, float var2, float var3, float var4, boolean var5);

    public static enum TargetBufferFlags {
        COLOR0(1),
        COLOR1(2),
        COLOR2(4),
        COLOR3(8),
        DEPTH(16),
        STENCIL(32);

        public static EnumSet<TargetBufferFlags> NONE;
        public static EnumSet<TargetBufferFlags> ALL_COLOR;
        public static EnumSet<TargetBufferFlags> DEPTH_STENCIL;
        public static EnumSet<TargetBufferFlags> ALL;
        private int mFlags;

        private TargetBufferFlags(int flags) {
            this.mFlags = flags;
        }

        static int flags(EnumSet<TargetBufferFlags> flags) {
            int result = 0;
            for (TargetBufferFlags flag : flags) {
                result |= flag.mFlags;
            }
            return result;
        }

        static {
            NONE = EnumSet.noneOf(TargetBufferFlags.class);
            ALL_COLOR = EnumSet.of(COLOR0, COLOR1, COLOR2, COLOR3);
            DEPTH_STENCIL = EnumSet.of(DEPTH, STENCIL);
            ALL = EnumSet.range(COLOR0, STENCIL);
        }
    }

    public static enum Dithering {
        NONE,
        TEMPORAL;

    }

    public static enum ToneMapping {
        LINEAR,
        ACES;

    }

    public static enum AntiAliasing {
        NONE,
        FXAA;

    }

    public static enum AmbientOcclusion {
        NONE,
        SSAO;

    }

    public static class RenderQuality {
        public QualityLevel hdrColorBuffer = QualityLevel.HIGH;
    }

    public static class DepthOfFieldOptions {
        public float focusDistance = 10.0f;
        public float blurScale = 1.0f;
        public float maxApertureDiameter = 0.01f;
        public boolean enabled = false;
    }

    public static class FogOptions {
        public float distance = 0.0f;
        public float maximumOpacity = 1.0f;
        public float height = 0.0f;
        public float heightFalloff = 1.0f;
        @NonNull
        public float[] color = new float[]{0.5f, 0.5f, 0.5f};
        public float density = 0.1f;
        public float inScatteringStart = 0.0f;
        public float inScatteringSize = 0.0f;
        public boolean fogColorFromIbl = false;
        public boolean enabled = false;
    }

    public static class BloomOptions {
        @Nullable
        public Texture dirt = null;
        public float dirtStrength = 0.2f;
        public float strength = 0.1f;
        public int resolution = 360;
        public float anamorphism = 1.0f;
        public int levels = 6;
        public BlendingMode blendingMode = BlendingMode.ADD;
        public boolean threshold = true;
        public boolean enabled = false;

        public static enum BlendingMode {
            ADD,
            INTERPOLATE;

        }
    }

    public static class AmbientOcclusionOptions {
        public float radius = 0.3f;
        public float bias = 5.0E-4f;
        public float power = 1.0f;
        public float resolution = 0.5f;
        public float intensity = 1.0f;
        @NonNull
        public QualityLevel quality = QualityLevel.LOW;
    }

    public static class DynamicResolutionOptions {
        public boolean enabled = false;
        public boolean homogeneousScaling = false;
        public float minScale = 0.5f;
        public float maxScale = 1.0f;
        @NonNull
        public QualityLevel quality = QualityLevel.LOW;
    }

    public static enum BlendMode {
        OPAQUE,
        TRANSLUCENT;

    }

    public static enum QualityLevel {
        LOW,
        MEDIUM,
        HIGH,
        ULTRA;

    }
}

