/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.android;

import android.graphics.Bitmap;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.google.android.filament.Engine;
import com.google.android.filament.Texture;

public final class TextureHelper {
    private static final int BITMAP_CONFIG_ALPHA_8 = 0;
    private static final int BITMAP_CONFIG_RGB_565 = 1;
    private static final int BITMAP_CONFIG_RGBA_4444 = 2;
    private static final int BITMAP_CONFIG_RGBA_8888 = 3;
    private static final int BITMAP_CONFIG_RGBA_F16 = 4;
    private static final int BITMAP_CONFIG_HARDWARE = 5;

    private TextureHelper() {
    }

    public static void setBitmap(@NonNull Engine engine, @NonNull Texture texture, @IntRange(from=0L) int level, @NonNull Bitmap bitmap) {
        TextureHelper.setBitmap(engine, texture, level, 0, 0, texture.getWidth(level), texture.getHeight(level), bitmap);
    }

    public static void setBitmap(@NonNull Engine engine, @NonNull Texture texture, @IntRange(from=0L) int level, @IntRange(from=0L) int xoffset, @IntRange(from=0L) int yoffset, @IntRange(from=0L) int width, @IntRange(from=0L) int height, @NonNull Bitmap bitmap) {
        int format = TextureHelper.toNativeFormat(bitmap.getConfig());
        if (format == 2 || format == 5) {
            throw new IllegalArgumentException("Unsupported config: ARGB_4444 or HARDWARE");
        }
        long nativeTexture = texture.getNativeObject();
        long nativeEngine = engine.getNativeObject();
        TextureHelper.nSetBitmap(nativeTexture, nativeEngine, level, xoffset, yoffset, width, height, bitmap, format);
    }

    private static int toNativeFormat(Bitmap.Config config) {
        switch (config) {
            case ALPHA_8: {
                return 0;
            }
            case RGB_565: {
                return 1;
            }
            case ARGB_4444: {
                return 2;
            }
            case ARGB_8888: {
                return 3;
            }
            case RGBA_F16: {
                return 4;
            }
            case HARDWARE: {
                return 5;
            }
        }
        return 3;
    }

    private static native void nSetBitmap(long var0, long var2, int var4, int var5, int var6, int var7, int var8, Bitmap var9, int var10);
}

