/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import com.google.android.filament.Camera;
import com.google.android.filament.Colors;
import com.google.android.filament.Engine;
import com.google.android.filament.Entity;
import com.google.android.filament.EntityManager;
import com.google.android.filament.LightManager;
import com.google.android.filament.RenderableManager;
import com.google.android.filament.Renderer;
import com.google.android.filament.Scene;
import com.google.android.filament.SwapChain;
import com.google.android.filament.TransformManager;
import com.google.android.filament.View;
import com.google.android.filament.Viewport;
import com.google.android.filament.android.DisplayHelper;
import com.google.android.filament.android.UiHelper;
import com.google.android.filament.gltfio.Animator;
import com.google.android.filament.gltfio.AssetLoader;
import com.google.android.filament.gltfio.FilamentAsset;
import com.google.android.filament.gltfio.MaterialProvider;
import com.google.android.filament.gltfio.ResourceLoader;
import com.google.android.filament.gltfio.UbershaderProvider;
import com.google.android.filament.utils.Float3;
import com.google.android.filament.utils.GestureDetector;
import com.google.android.filament.utils.Manipulator;
import com.google.android.filament.utils.Mat4;
import com.google.android.filament.utils.MatrixKt;
import java.nio.Buffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 u2\u00020\u0001:\u0002uvB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB/\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010Z\u001a\u00020[2\u0006\u0010V\u001a\u00020\\H\u0002J\u0006\u0010]\u001a\u00020[J\u0006\u0010^\u001a\u00020[J-\u0010_\u001a\u00020[2\u0006\u0010\u0015\u001a\u00020\u00142\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020b\u0012\u0004\u0012\u00020c0aH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010dJ\u000e\u0010e\u001a\u00020[2\u0006\u0010f\u001a\u00020cJ$\u0010g\u001a\u00020[2\u0006\u0010f\u001a\u00020c2\u0014\u0010`\u001a\u0010\u0012\u0004\u0012\u00020b\u0012\u0006\u0012\u0004\u0018\u00010c0aJ\"\u0010h\u001a\u00020[2\u0006\u0010f\u001a\u00020c2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020b\u0012\u0004\u0012\u00020c0aJ\u0018\u0010i\u001a\u00020=2\u0006\u0010V\u001a\u00020\\2\u0006\u0010j\u001a\u00020kH\u0016J\u000e\u0010l\u001a\u00020[2\u0006\u0010j\u001a\u00020kJ\u0010\u0010m\u001a\u00020[2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u000e\u0010n\u001a\u00020[2\u0006\u0010o\u001a\u00020pJ\u0010\u0010q\u001a\u00020[2\b\b\u0002\u0010r\u001a\u00020sJ\b\u0010t\u001a\u00020[H\u0002R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R$\u0010%\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u000e\u0010(\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\"\"\u0004\b+\u0010$R\u000e\u0010,\u001a\u00020-X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\u0002078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010:\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u0017\u0010B\u001a\u00020\u001f8F\u00a2\u0006\f\u0012\u0004\bC\u0010D\u001a\u0004\bE\u0010\"R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010H\u001a\u00020I\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u000e\u0010L\u001a\u00020MX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010N\u001a\u00020O\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u0004\u0018\u00010SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010V\u001a\u00020W\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010Y\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006w"}, d2={"Lcom/google/android/filament/utils/ModelViewer;", "Landroid/view/View$OnTouchListener;", "surfaceView", "Landroid/view/SurfaceView;", "engine", "Lcom/google/android/filament/Engine;", "uiHelper", "Lcom/google/android/filament/android/UiHelper;", "manipulator", "Lcom/google/android/filament/utils/Manipulator;", "(Landroid/view/SurfaceView;Lcom/google/android/filament/Engine;Lcom/google/android/filament/android/UiHelper;Lcom/google/android/filament/utils/Manipulator;)V", "textureView", "Landroid/view/TextureView;", "(Landroid/view/TextureView;Lcom/google/android/filament/Engine;Lcom/google/android/filament/android/UiHelper;Lcom/google/android/filament/utils/Manipulator;)V", "(Lcom/google/android/filament/Engine;Lcom/google/android/filament/android/UiHelper;)V", "<set-?>", "Lcom/google/android/filament/gltfio/Animator;", "animator", "getAnimator", "()Lcom/google/android/filament/gltfio/Animator;", "Lcom/google/android/filament/gltfio/FilamentAsset;", "asset", "getAsset", "()Lcom/google/android/filament/gltfio/FilamentAsset;", "assetLoader", "Lcom/google/android/filament/gltfio/AssetLoader;", "camera", "Lcom/google/android/filament/Camera;", "getCamera", "()Lcom/google/android/filament/Camera;", "value", "", "cameraFar", "getCameraFar", "()F", "setCameraFar", "(F)V", "cameraFocalLength", "getCameraFocalLength", "setCameraFocalLength", "cameraManipulator", "cameraNear", "getCameraNear", "setCameraNear", "displayHelper", "Lcom/google/android/filament/android/DisplayHelper;", "getEngine", "()Lcom/google/android/filament/Engine;", "eyePos", "", "fetchResourcesJob", "Lkotlinx/coroutines/Job;", "gestureDetector", "Lcom/google/android/filament/utils/GestureDetector;", "light", "", "getLight", "()I", "materialProvider", "Lcom/google/android/filament/gltfio/MaterialProvider;", "normalizeSkinningWeights", "", "getNormalizeSkinningWeights", "()Z", "setNormalizeSkinningWeights", "(Z)V", "progress", "getProgress$annotations", "()V", "getProgress", "readyRenderables", "", "renderer", "Lcom/google/android/filament/Renderer;", "getRenderer", "()Lcom/google/android/filament/Renderer;", "resourceLoader", "Lcom/google/android/filament/gltfio/ResourceLoader;", "scene", "Lcom/google/android/filament/Scene;", "getScene", "()Lcom/google/android/filament/Scene;", "swapChain", "Lcom/google/android/filament/SwapChain;", "target", "upward", "view", "Lcom/google/android/filament/View;", "getView", "()Lcom/google/android/filament/View;", "addDetachListener", "", "Landroid/view/View;", "clearRootTransform", "destroyModel", "fetchResources", "callback", "Lkotlin/Function1;", "", "Ljava/nio/Buffer;", "(Lcom/google/android/filament/gltfio/FilamentAsset;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadModelGlb", "buffer", "loadModelGltf", "loadModelGltfAsync", "onTouch", "event", "Landroid/view/MotionEvent;", "onTouchEvent", "populateScene", "render", "frameTimeNanos", "", "transformToUnitCube", "centerPoint", "Lcom/google/android/filament/utils/Float3;", "updateCameraProjection", "Companion", "SurfaceCallback", "filament-utils-android_release"})
@SourceDebugExtension(value={"SMAP\nModelViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelViewer.kt\ncom/google/android/filament/utils/ModelViewer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Vector.kt\ncom/google/android/filament/utils/VectorKt\n+ 4 Vector.kt\ncom/google/android/filament/utils/Float3\n*L\n1#1,414:1\n1#2:415\n712#3:416\n293#4,9:417\n*S KotlinDebug\n*F\n+ 1 ModelViewer.kt\ncom/google/android/filament/utils/ModelViewer\n*L\n245#1:416\n247#1:417,9\n*E\n"})
public final class ModelViewer
implements View.OnTouchListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Engine engine;
    @NotNull
    private final UiHelper uiHelper;
    @Nullable
    private FilamentAsset asset;
    @Nullable
    private Animator animator;
    private boolean normalizeSkinningWeights;
    private float cameraFocalLength;
    private float cameraNear;
    private float cameraFar;
    @NotNull
    private final Scene scene;
    @NotNull
    private final View view;
    @NotNull
    private final Camera camera;
    @NotNull
    private final Renderer renderer;
    @Entity
    private final int light;
    private DisplayHelper displayHelper;
    private Manipulator cameraManipulator;
    private GestureDetector gestureDetector;
    @Nullable
    private SurfaceView surfaceView;
    @Nullable
    private TextureView textureView;
    @Nullable
    private Job fetchResourcesJob;
    @Nullable
    private SwapChain swapChain;
    @NotNull
    private AssetLoader assetLoader;
    @NotNull
    private MaterialProvider materialProvider;
    @NotNull
    private ResourceLoader resourceLoader;
    @NotNull
    private final int[] readyRenderables;
    @NotNull
    private final double[] eyePos;
    @NotNull
    private final double[] target;
    @NotNull
    private final double[] upward;
    @NotNull
    private static final Float3 kDefaultObjectPosition = new Float3(0.0f, 0.0f, -4.0f);

    /*
     * WARNING - void declaration
     */
    public ModelViewer(@NotNull Engine engine, @NotNull UiHelper uiHelper) {
        void $this$_init__u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)uiHelper, (String)"uiHelper");
        this.engine = engine;
        this.uiHelper = uiHelper;
        this.normalizeSkinningWeights = true;
        this.cameraFocalLength = 28.0f;
        this.cameraNear = 0.05f;
        this.cameraFar = 1000.0f;
        this.readyRenderables = new int[128];
        this.eyePos = new double[3];
        this.target = new double[3];
        this.upward = new double[3];
        Renderer renderer = this.engine.createRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)renderer, (String)"engine.createRenderer()");
        this.renderer = renderer;
        Scene scene = this.engine.createScene();
        Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"engine.createScene()");
        this.scene = scene;
        Camera camera = this.engine.createCamera(this.engine.getEntityManager().create());
        Intrinsics.checkNotNullExpressionValue((Object)camera, (String)"engine.createCamera(engine.entityManager.create())");
        Camera camera2 = object = camera;
        ModelViewer modelViewer = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setExposure(16.0f, 0.008f, 100.0f);
        modelViewer.camera = object;
        View view = this.engine.createView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"engine.createView()");
        this.view = view;
        this.view.setScene(this.scene);
        this.view.setCamera(this.camera);
        this.materialProvider = (MaterialProvider)new UbershaderProvider(this.engine);
        this.assetLoader = new AssetLoader(this.engine, this.materialProvider, EntityManager.get());
        this.resourceLoader = new ResourceLoader(this.engine, this.normalizeSkinningWeights);
        this.light = EntityManager.get().create();
        object = Colors.cct((float)6500.0f);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cct(6_500.0f)");
        Camera r = object[0];
        Camera g = object[1];
        Camera b = object[2];
        new LightManager.Builder(LightManager.Type.DIRECTIONAL).color((float)r, (float)g, (float)b).intensity(100000.0f).direction(0.0f, -1.0f, 0.0f).castShadows(true).build(this.engine, this.light);
        this.scene.addEntity(this.light);
    }

    @NotNull
    public final Engine getEngine() {
        return this.engine;
    }

    @Nullable
    public final FilamentAsset getAsset() {
        return this.asset;
    }

    @Nullable
    public final Animator getAnimator() {
        return this.animator;
    }

    public final float getProgress() {
        return this.resourceLoader.asyncGetLoadProgress();
    }

    public static /* synthetic */ void getProgress$annotations() {
    }

    public final boolean getNormalizeSkinningWeights() {
        return this.normalizeSkinningWeights;
    }

    public final void setNormalizeSkinningWeights(boolean bl) {
        this.normalizeSkinningWeights = bl;
    }

    public final float getCameraFocalLength() {
        return this.cameraFocalLength;
    }

    public final void setCameraFocalLength(float value) {
        this.cameraFocalLength = value;
        this.updateCameraProjection();
    }

    public final float getCameraNear() {
        return this.cameraNear;
    }

    public final void setCameraNear(float value) {
        this.cameraNear = value;
        this.updateCameraProjection();
    }

    public final float getCameraFar() {
        return this.cameraFar;
    }

    public final void setCameraFar(float value) {
        this.cameraFar = value;
        this.updateCameraProjection();
    }

    @NotNull
    public final Scene getScene() {
        return this.scene;
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    @NotNull
    public final Camera getCamera() {
        return this.camera;
    }

    @NotNull
    public final Renderer getRenderer() {
        return this.renderer;
    }

    public final int getLight() {
        return this.light;
    }

    public ModelViewer(@NotNull SurfaceView surfaceView, @NotNull Engine engine, @NotNull UiHelper uiHelper, @Nullable Manipulator manipulator) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)uiHelper, (String)"uiHelper");
        this(engine, uiHelper);
        Manipulator manipulator2 = manipulator;
        if (manipulator2 == null) {
            Manipulator manipulator3 = new Manipulator.Builder().targetPosition(kDefaultObjectPosition.getX(), kDefaultObjectPosition.getY(), kDefaultObjectPosition.getZ()).viewport(surfaceView.getWidth(), surfaceView.getHeight()).build(Manipulator.Mode.ORBIT);
            manipulator2 = manipulator3;
            Intrinsics.checkNotNullExpressionValue((Object)manipulator3, (String)"Builder()\n              \u2026d(Manipulator.Mode.ORBIT)");
        }
        this.cameraManipulator = manipulator2;
        this.surfaceView = surfaceView;
        android.view.View view = (android.view.View)surfaceView;
        Manipulator manipulator4 = this.cameraManipulator;
        if (manipulator4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraManipulator");
            manipulator4 = null;
        }
        this.gestureDetector = new GestureDetector(view, manipulator4);
        this.displayHelper = new DisplayHelper(surfaceView.getContext());
        uiHelper.setRenderCallback((UiHelper.RendererCallback)new SurfaceCallback());
        uiHelper.attachTo(surfaceView);
        this.addDetachListener((android.view.View)surfaceView);
    }

    public /* synthetic */ ModelViewer(SurfaceView surfaceView, Engine engine, UiHelper uiHelper, Manipulator manipulator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Engine engine2 = Engine.create();
            Intrinsics.checkNotNullExpressionValue((Object)engine2, (String)"create()");
            engine = engine2;
        }
        if ((n & 4) != 0) {
            uiHelper = new UiHelper(UiHelper.ContextErrorPolicy.DONT_CHECK);
        }
        if ((n & 8) != 0) {
            manipulator = null;
        }
        this(surfaceView, engine, uiHelper, manipulator);
    }

    public ModelViewer(@NotNull TextureView textureView, @NotNull Engine engine, @NotNull UiHelper uiHelper, @Nullable Manipulator manipulator) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"textureView");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)uiHelper, (String)"uiHelper");
        this(engine, uiHelper);
        Manipulator manipulator2 = manipulator;
        if (manipulator2 == null) {
            Manipulator manipulator3 = new Manipulator.Builder().targetPosition(kDefaultObjectPosition.getX(), kDefaultObjectPosition.getY(), kDefaultObjectPosition.getZ()).viewport(textureView.getWidth(), textureView.getHeight()).build(Manipulator.Mode.ORBIT);
            manipulator2 = manipulator3;
            Intrinsics.checkNotNullExpressionValue((Object)manipulator3, (String)"Builder()\n              \u2026d(Manipulator.Mode.ORBIT)");
        }
        this.cameraManipulator = manipulator2;
        this.textureView = textureView;
        android.view.View view = (android.view.View)textureView;
        Manipulator manipulator4 = this.cameraManipulator;
        if (manipulator4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraManipulator");
            manipulator4 = null;
        }
        this.gestureDetector = new GestureDetector(view, manipulator4);
        this.displayHelper = new DisplayHelper(textureView.getContext());
        uiHelper.setRenderCallback((UiHelper.RendererCallback)new SurfaceCallback());
        uiHelper.attachTo(textureView);
        this.addDetachListener((android.view.View)textureView);
    }

    public /* synthetic */ ModelViewer(TextureView textureView, Engine engine, UiHelper uiHelper, Manipulator manipulator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Engine engine2 = Engine.create();
            Intrinsics.checkNotNullExpressionValue((Object)engine2, (String)"create()");
            engine = engine2;
        }
        if ((n & 4) != 0) {
            uiHelper = new UiHelper(UiHelper.ContextErrorPolicy.DONT_CHECK);
        }
        if ((n & 8) != 0) {
            manipulator = null;
        }
        this(textureView, engine, uiHelper, manipulator);
    }

    public final void loadModelGlb(@NotNull Buffer buffer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.destroyModel();
            FilamentAsset filamentAsset = this.asset = this.assetLoader.createAsset(buffer);
            if (filamentAsset == null) break block0;
            FilamentAsset asset = filamentAsset;
            boolean bl = false;
            this.resourceLoader.asyncBeginLoad(asset);
            this.animator = asset.getInstance().getAnimator();
            asset.releaseSourceData();
        }
    }

    public final void loadModelGltf(@NotNull Buffer buffer, @NotNull Function1<? super String, ? extends Buffer> callback) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.destroyModel();
            FilamentAsset filamentAsset = this.asset = this.assetLoader.createAsset(buffer);
            if (filamentAsset == null) break block2;
            FilamentAsset asset = filamentAsset;
            boolean bl = false;
            String[] stringArray = asset.getResourceUris();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"asset.resourceUris");
            for (String uri : stringArray) {
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                Buffer resourceBuffer = (Buffer)callback.invoke((Object)uri);
                if (resourceBuffer == null) {
                    this.asset = null;
                    return;
                }
                this.resourceLoader.addResourceData(uri, resourceBuffer);
            }
            this.resourceLoader.asyncBeginLoad(asset);
            this.animator = asset.getInstance().getAnimator();
            asset.releaseSourceData();
        }
    }

    public final void loadModelGltfAsync(@NotNull Buffer buffer, @NotNull Function1<? super String, ? extends Buffer> callback) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.destroyModel();
        this.asset = this.assetLoader.createAsset(buffer);
        this.fetchResourcesJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback, null){
            int label;
            final /* synthetic */ ModelViewer this$0;
            final /* synthetic */ Function1<String, Buffer> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FilamentAsset filamentAsset = this.this$0.getAsset();
                        Intrinsics.checkNotNull((Object)filamentAsset);
                        this.label = 1;
                        Object object3 = ModelViewer.access$fetchResources(this.this$0, filamentAsset, this.$callback, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void transformToUnitCube(@NotNull Float3 centerPoint) {
        block0: {
            void v$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)centerPoint, (String)"centerPoint");
            FilamentAsset filamentAsset = this.asset;
            if (filamentAsset == null) break block0;
            FilamentAsset asset = filamentAsset;
            boolean bl = false;
            TransformManager transformManager = this.engine.getTransformManager();
            Intrinsics.checkNotNullExpressionValue((Object)transformManager, (String)"engine.transformManager");
            TransformManager tm = transformManager;
            float[] v = asset.getBoundingBox().getCenter();
            boolean bl2 = false;
            Float3 center = new Float3(v[0], v[1], v[2]);
            float[] v2 = asset.getBoundingBox().getHalfExtent();
            boolean $i$a$-let-ModelViewer$transformToUnitCube$1$halfExtent$22 = false;
            Float3 halfExtent = new Float3(v2[0], v2[1], v2[2]);
            boolean $i$f$max = false;
            float maxExtent = 2.0f * Math.max(halfExtent.getX(), Math.max(halfExtent.getY(), halfExtent.getZ()));
            float scaleFactor = 2.0f / maxExtent;
            Float3 $i$a$-let-ModelViewer$transformToUnitCube$1$halfExtent$22 = center;
            Float3 this_$iv2 = centerPoint;
            boolean $i$f$div = false;
            this_$iv2 = new Float3(this_$iv2.getX() / scaleFactor, this_$iv2.getY() / scaleFactor, this_$iv2.getZ() / scaleFactor);
            boolean $i$f$minus = false;
            center = new Float3(this_$iv.getX() - v$iv.getX(), this_$iv.getY() - v$iv.getY(), this_$iv.getZ() - v$iv.getZ());
            Mat4 transform = MatrixKt.scale(new Float3(scaleFactor)).times(MatrixKt.translation(center.unaryMinus()));
            tm.setTransform(tm.getInstance(asset.getRoot()), MatrixKt.transpose(transform).toFloatArray());
        }
    }

    public static /* synthetic */ void transformToUnitCube$default(ModelViewer modelViewer, Float3 float3, int n, Object object) {
        if ((n & 1) != 0) {
            float3 = kDefaultObjectPosition;
        }
        modelViewer.transformToUnitCube(float3);
    }

    public final void clearRootTransform() {
        block0: {
            FilamentAsset filamentAsset = this.asset;
            if (filamentAsset == null) break block0;
            FilamentAsset it = filamentAsset;
            boolean bl = false;
            TransformManager transformManager = this.engine.getTransformManager();
            Intrinsics.checkNotNullExpressionValue((Object)transformManager, (String)"engine.transformManager");
            TransformManager tm = transformManager;
            tm.setTransform(tm.getInstance(it.getRoot()), new Mat4(null, null, null, null, 15, null).toFloatArray());
        }
    }

    public final void destroyModel() {
        block1: {
            Job job = this.fetchResourcesJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.resourceLoader.asyncCancelLoad();
            this.resourceLoader.evictResourceData();
            FilamentAsset filamentAsset = this.asset;
            if (filamentAsset == null) break block1;
            FilamentAsset asset = filamentAsset;
            boolean bl = false;
            this.scene.removeEntities(asset.getEntities());
            this.assetLoader.destroyAsset(asset);
            this.asset = null;
            this.animator = null;
        }
    }

    public final void render(long frameTimeNanos) {
        Manipulator manipulator;
        if (!this.uiHelper.isReadyToRender()) {
            return;
        }
        this.resourceLoader.asyncUpdateLoad();
        FilamentAsset filamentAsset = this.asset;
        if (filamentAsset != null) {
            FilamentAsset it = filamentAsset;
            boolean bl = false;
            this.populateScene(it);
        }
        if ((manipulator = this.cameraManipulator) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraManipulator");
            manipulator = null;
        }
        manipulator.getLookAt(this.eyePos, this.target, this.upward);
        this.camera.lookAt(this.eyePos[0], this.eyePos[1], this.eyePos[2], this.target[0], this.target[1], this.target[2], this.upward[0], this.upward[1], this.upward[2]);
        SwapChain swapChain = this.swapChain;
        Intrinsics.checkNotNull((Object)swapChain);
        if (this.renderer.beginFrame(swapChain, frameTimeNanos)) {
            this.renderer.render(this.view);
            this.renderer.endFrame();
        }
    }

    private final void populateScene(FilamentAsset asset) {
        RenderableManager renderableManager = this.engine.getRenderableManager();
        Intrinsics.checkNotNullExpressionValue((Object)renderableManager, (String)"engine.renderableManager");
        RenderableManager rcm = renderableManager;
        Ref.IntRef count = new Ref.IntRef();
        Function0 popRenderables2 = (Function0)new Function0<Boolean>(count, asset, this){
            final /* synthetic */ Ref.IntRef $count;
            final /* synthetic */ FilamentAsset $asset;
            final /* synthetic */ ModelViewer this$0;
            {
                this.$count = $count;
                this.$asset = $asset;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                this.$count.element = this.$asset.popRenderables(ModelViewer.access$getReadyRenderables$p(this.this$0));
                return this.$count.element != 0;
            }
        };
        while (((Boolean)popRenderables2.invoke()).booleanValue()) {
            int i = 0;
            int n = count.element - 1;
            if (i <= n) {
                while (true) {
                    int ri = rcm.getInstance(this.readyRenderables[i]);
                    rcm.setScreenSpaceContactShadows(ri, true);
                    if (i == n) break;
                    ++i;
                }
            }
            this.scene.addEntities(CollectionsKt.toIntArray((Collection)ArraysKt.take((int[])this.readyRenderables, (int)count.element)));
        }
        this.scene.addEntities(asset.getLightEntities());
    }

    private final void addDetachListener(android.view.View view) {
        view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(this){
            final /* synthetic */ ModelViewer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onViewAttachedToWindow(@NotNull android.view.View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            }

            public void onViewDetachedFromWindow(@NotNull android.view.View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                ModelViewer.access$getUiHelper$p(this.this$0).detach();
                this.this$0.destroyModel();
                ModelViewer.access$getAssetLoader$p(this.this$0).destroy();
                ModelViewer.access$getMaterialProvider$p(this.this$0).destroyMaterials();
                ModelViewer.access$getMaterialProvider$p(this.this$0).destroy();
                ModelViewer.access$getResourceLoader$p(this.this$0).destroy();
                this.this$0.getEngine().destroyEntity(this.this$0.getLight());
                this.this$0.getEngine().destroyRenderer(this.this$0.getRenderer());
                this.this$0.getEngine().destroyView(this.this$0.getView());
                this.this$0.getEngine().destroyScene(this.this$0.getScene());
                this.this$0.getEngine().destroyCameraComponent(this.this$0.getCamera().getEntity());
                EntityManager.get().destroy(this.this$0.getCamera().getEntity());
                EntityManager.get().destroy(this.this$0.getLight());
                this.this$0.getEngine().destroy();
            }
        });
    }

    public final void onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GestureDetector gestureDetector = this.gestureDetector;
        if (gestureDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gestureDetector");
            gestureDetector = null;
        }
        gestureDetector.onTouchEvent(event);
    }

    public boolean onTouch(@NotNull android.view.View view, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onTouchEvent(event);
        return true;
    }

    private final Object fetchResources(FilamentAsset asset, Function1<? super String, ? extends Buffer> callback, Continuation<? super Unit> $completion) {
        HashMap<String, Buffer> items = new HashMap<String, Buffer>();
        String[] stringArray = asset.getResourceUris();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"asset.resourceUris");
        for (String resourceUri : stringArray) {
            Map map = items;
            Intrinsics.checkNotNullExpressionValue((Object)resourceUri, (String)"resourceUri");
            map.put(resourceUri, callback.invoke((Object)resourceUri));
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(items, this, asset, null){
            int label;
            final /* synthetic */ HashMap<String, Buffer> $items;
            final /* synthetic */ ModelViewer this$0;
            final /* synthetic */ FilamentAsset $asset;
            {
                this.$items = $items;
                this.this$0 = $receiver;
                this.$asset = $asset;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        for (Map.Entry<K, V> entry : ((Map)this.$items).entrySet()) {
                            String uri = (String)entry.getKey();
                            Buffer buffer = (Buffer)entry.getValue();
                            ModelViewer.access$getResourceLoader$p(this.this$0).addResourceData(uri, buffer);
                        }
                        ModelViewer.access$getResourceLoader$p(this.this$0).asyncBeginLoad(this.$asset);
                        ModelViewer.access$setAnimator$p(this.this$0, this.$asset.getInstance().getAnimator());
                        this.$asset.releaseSourceData();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void updateCameraProjection() {
        int width = this.view.getViewport().width;
        int height = this.view.getViewport().height;
        double aspect = (double)width / (double)height;
        this.camera.setLensProjection((double)this.cameraFocalLength, aspect, (double)this.cameraNear, (double)this.cameraFar);
    }

    public static final /* synthetic */ Object access$fetchResources(ModelViewer $this, FilamentAsset asset, Function1 callback, Continuation $completion) {
        return $this.fetchResources(asset, (Function1<? super String, ? extends Buffer>)callback, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ int[] access$getReadyRenderables$p(ModelViewer $this) {
        return $this.readyRenderables;
    }

    public static final /* synthetic */ UiHelper access$getUiHelper$p(ModelViewer $this) {
        return $this.uiHelper;
    }

    public static final /* synthetic */ AssetLoader access$getAssetLoader$p(ModelViewer $this) {
        return $this.assetLoader;
    }

    public static final /* synthetic */ MaterialProvider access$getMaterialProvider$p(ModelViewer $this) {
        return $this.materialProvider;
    }

    public static final /* synthetic */ ResourceLoader access$getResourceLoader$p(ModelViewer $this) {
        return $this.resourceLoader;
    }

    public static final /* synthetic */ void access$setAnimator$p(ModelViewer $this, Animator animator) {
        $this.animator = animator;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/google/android/filament/utils/ModelViewer$SurfaceCallback;", "Lcom/google/android/filament/android/UiHelper$RendererCallback;", "(Lcom/google/android/filament/utils/ModelViewer;)V", "onDetachedFromSurface", "", "onNativeWindowChanged", "surface", "Landroid/view/Surface;", "onResized", "width", "", "height", "filament-utils-android_release"})
    @SourceDebugExtension(value={"SMAP\nModelViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelViewer.kt\ncom/google/android/filament/utils/ModelViewer$SurfaceCallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,414:1\n1#2:415\n*E\n"})
    public final class SurfaceCallback
    implements UiHelper.RendererCallback {
        public void onNativeWindowChanged(@NotNull Surface surface) {
            block4: {
                SwapChain it;
                ModelViewer modelViewer;
                SwapChain swapChain;
                Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
                SwapChain swapChain2 = ModelViewer.this.swapChain;
                if (swapChain2 != null) {
                    swapChain = swapChain2;
                    modelViewer = ModelViewer.this;
                    it = swapChain;
                    boolean bl = false;
                    modelViewer.getEngine().destroySwapChain(it);
                }
                ModelViewer.this.swapChain = ModelViewer.this.getEngine().createSwapChain((Object)surface);
                SurfaceView surfaceView = ModelViewer.this.surfaceView;
                if (surfaceView != null) {
                    swapChain = surfaceView;
                    modelViewer = ModelViewer.this;
                    it = swapChain;
                    boolean bl = false;
                    DisplayHelper displayHelper = modelViewer.displayHelper;
                    if (displayHelper == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"displayHelper");
                        displayHelper = null;
                    }
                    displayHelper.attach(modelViewer.getRenderer(), it.getDisplay());
                }
                TextureView textureView = ModelViewer.this.textureView;
                if (textureView == null) break block4;
                swapChain = textureView;
                modelViewer = ModelViewer.this;
                it = swapChain;
                boolean bl = false;
                DisplayHelper displayHelper = modelViewer.displayHelper;
                if (displayHelper == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"displayHelper");
                    displayHelper = null;
                }
                displayHelper.attach(modelViewer.getRenderer(), it.getDisplay());
            }
        }

        public void onDetachedFromSurface() {
            block1: {
                DisplayHelper displayHelper = ModelViewer.this.displayHelper;
                if (displayHelper == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"displayHelper");
                    displayHelper = null;
                }
                displayHelper.detach();
                SwapChain swapChain = ModelViewer.this.swapChain;
                if (swapChain == null) break block1;
                SwapChain swapChain2 = swapChain;
                ModelViewer modelViewer = ModelViewer.this;
                SwapChain it = swapChain2;
                boolean bl = false;
                modelViewer.getEngine().destroySwapChain(it);
                modelViewer.getEngine().flushAndWait();
                modelViewer.swapChain = null;
            }
        }

        public void onResized(int width, int height) {
            ModelViewer.this.getView().setViewport(new Viewport(0, 0, width, height));
            Manipulator manipulator = ModelViewer.this.cameraManipulator;
            if (manipulator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraManipulator");
                manipulator = null;
            }
            manipulator.setViewport(width, height);
            ModelViewer.this.updateCameraProjection();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/android/filament/utils/ModelViewer$Companion;", "", "()V", "kDefaultObjectPosition", "Lcom/google/android/filament/utils/Float3;", "filament-utils-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

