/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import com.google.android.filament.utils.Bool4;
import com.google.android.filament.utils.Float3;
import com.google.android.filament.utils.Float4;
import com.google.android.filament.utils.Mat4;
import com.google.android.filament.utils.MatrixKt;
import com.google.android.filament.utils.QuaternionComponent;
import com.google.android.filament.utils.QuaternionKt;
import com.google.android.filament.utils.RotationsOrder;
import com.google.android.filament.utils.VectorKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 O2\u00020\u0001:\u0001OB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\nB-\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010)\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010*\u001a\u00020\u0005H\u0086\bJ\u001b\u0010)\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00052\b\b\u0002\u0010*\u001a\u00020\u0005H\u0086\bJ\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J1\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0011\u00100\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\nJ\u001b\u00101\u001a\u0002022\u0006\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010*\u001a\u00020\u0005H\u0086\bJ\u0013\u00101\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001b\u00101\u001a\u0002022\u0006\u0010\u0002\u001a\u00020\u00052\b\b\u0002\u0010*\u001a\u00020\u0005H\u0086\bJ\u0011\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u000207H\u0086\u0002J!\u00105\u001a\u00020\u00032\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u000207H\u0086\u0002J)\u00105\u001a\u00020\u00002\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u000207H\u0086\u0002J\u0011\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020<H\u0086\u0002J!\u00105\u001a\u00020\u00032\u0006\u00108\u001a\u00020<2\u0006\u00109\u001a\u00020<2\u0006\u0010:\u001a\u00020<H\u0086\u0002J)\u00105\u001a\u00020\u00002\u0006\u00108\u001a\u00020<2\u0006\u00109\u001a\u00020<2\u0006\u0010:\u001a\u00020<2\u0006\u0010;\u001a\u00020<H\u0086\u0002J\t\u0010=\u001a\u00020<H\u00d6\u0001J\u0011\u0010>\u001a\u00020\u00052\u0006\u00106\u001a\u00020<H\u0086\nJ\u0011\u0010?\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0086\nJ\u0011\u0010?\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\nJ\u0011\u0010@\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0086\nJ\u0011\u0010@\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\nJ1\u0010A\u001a\u00020B2\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\u0006\u0010;\u001a\u0002072\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\u0002J)\u0010A\u001a\u00020B2\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\u0002J!\u0010A\u001a\u00020B2\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u0002072\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\u0002J\u0019\u0010A\u001a\u00020B2\u0006\u00106\u001a\u0002072\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\u0002J\u0019\u0010A\u001a\u00020B2\u0006\u00106\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\u0002J!\u0010A\u001a\u00020B2\u0006\u00108\u001a\u00020<2\u0006\u00109\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\u0002J)\u0010A\u001a\u00020B2\u0006\u00108\u001a\u00020<2\u0006\u00109\u001a\u00020<2\u0006\u0010:\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\u0002J1\u0010A\u001a\u00020B2\u0006\u00108\u001a\u00020<2\u0006\u00109\u001a\u00020<2\u0006\u0010:\u001a\u00020<2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010C\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\nJ\u0011\u0010C\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0086\nJ\u0011\u0010C\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0005H\u0086\nJ\u0006\u0010D\u001a\u00020\u0003J\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u00020HJ\t\u0010I\u001a\u00020JH\u00d6\u0001J \u0010K\u001a\u00020\u00002\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050MH\u0086\b\u00f8\u0001\u0000J\t\u0010N\u001a\u00020\u0000H\u0086\u0002R&\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00058\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R&\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00038\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R&\u0010!\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0017\"\u0004\b&\u0010\u0019R\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0017\"\u0004\b(\u0010\u0019\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006P"}, d2={"Lcom/google/android/filament/utils/Quaternion;", "", "v", "Lcom/google/android/filament/utils/Float3;", "w", "", "(Lcom/google/android/filament/utils/Float3;F)V", "Lcom/google/android/filament/utils/Float4;", "(Lcom/google/android/filament/utils/Float4;)V", "q", "(Lcom/google/android/filament/utils/Quaternion;)V", "x", "y", "z", "(FFFF)V", "value", "imaginary", "getImaginary", "()Lcom/google/android/filament/utils/Float3;", "setImaginary", "(Lcom/google/android/filament/utils/Float3;)V", "real", "getReal", "()F", "setReal", "(F)V", "getW", "setW", "getX", "setX", "xyz", "getXyz", "setXyz", "xyzw", "getXyzw", "()Lcom/google/android/filament/utils/Float4;", "setXyzw", "getY", "setY", "getZ", "setZ", "compareTo", "delta", "component1", "component2", "component3", "component4", "copy", "div", "equals", "Lcom/google/android/filament/utils/Bool4;", "", "other", "get", "index", "Lcom/google/android/filament/utils/QuaternionComponent;", "index1", "index2", "index3", "index4", "", "hashCode", "invoke", "minus", "plus", "set", "", "times", "toEulerAngles", "toFloatArray", "", "toMatrix", "Lcom/google/android/filament/utils/Mat4;", "toString", "", "transform", "block", "Lkotlin/Function1;", "unaryMinus", "Companion", "filament-utils-android_release"})
@SourceDebugExtension(value={"SMAP\nQuaternion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quaternion.kt\ncom/google/android/filament/utils/Quaternion\n+ 2 Vector.kt\ncom/google/android/filament/utils/VectorKt\n*L\n1#1,509:1\n137#1:510\n285#1,6:561\n137#1:567\n617#2,6:511\n617#2,6:517\n617#2,6:523\n617#2,6:529\n617#2,6:535\n617#2,6:541\n617#2,6:547\n622#2:553\n622#2:554\n622#2:555\n622#2:556\n622#2:557\n622#2:558\n622#2:559\n622#2:560\n617#2,6:568\n617#2,6:574\n617#2,6:580\n617#2,6:586\n617#2,6:592\n617#2,6:598\n617#2,6:604\n617#2,6:610\n622#2:616\n622#2:617\n622#2:618\n622#2:619\n622#2:620\n622#2:621\n622#2:622\n622#2:623\n*S KotlinDebug\n*F\n+ 1 Quaternion.kt\ncom/google/android/filament/utils/Quaternion\n*L\n145#1:510\n281#1:561,6\n281#1:567\n268#1:511,6\n269#1:517,6\n270#1:523,6\n271#1:529,6\n269#1:535,6\n270#1:541,6\n271#1:547,6\n275#1:553\n276#1:554\n277#1:555\n278#1:556\n275#1:557\n276#1:558\n277#1:559\n278#1:560\n293#1:568,6\n294#1:574,6\n295#1:580,6\n296#1:586,6\n293#1:592,6\n294#1:598,6\n295#1:604,6\n296#1:610,6\n300#1:616\n301#1:617\n302#1:618\n303#1:619\n300#1:620\n301#1:621\n302#1:622\n303#1:623\n*E\n"})
public final class Quaternion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float x;
    private float y;
    private float z;
    private float w;

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public /* synthetic */ Quaternion(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float f) {
        this.x = f;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float f) {
        this.y = f;
    }

    public final float getZ() {
        return this.z;
    }

    public final void setZ(float f) {
        this.z = f;
    }

    public final float getW() {
        return this.w;
    }

    public final void setW(float f) {
        this.w = f;
    }

    public Quaternion(@NotNull Float3 v, float w) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this(v.getX(), v.getY(), v.getZ(), w);
    }

    public /* synthetic */ Quaternion(Float3 float3, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        this(float3, f);
    }

    public Quaternion(@NotNull Float4 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public Quaternion(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this(q.x, q.y, q.z, q.w);
    }

    @NotNull
    public final Float3 getXyz() {
        boolean $i$f$getXyz = false;
        return new Float3(this.getX(), this.getY(), this.getZ());
    }

    public final void setXyz(@NotNull Float3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setXyz = false;
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
    }

    @NotNull
    public final Float3 getImaginary() {
        boolean $i$f$getImaginary = false;
        Quaternion this_$iv = this;
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    public final void setImaginary(@NotNull Float3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setImaginary = false;
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
    }

    public final float getReal() {
        boolean $i$f$getReal = false;
        return this.getW();
    }

    public final void setReal(float value) {
        boolean $i$f$setReal = false;
        this.setW(value);
    }

    @NotNull
    public final Float4 getXyzw() {
        boolean $i$f$getXyzw = false;
        return new Float4(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    public final void setXyzw(@NotNull Float4 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setXyzw = false;
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
        this.setW(value.getW());
    }

    public final float get(@NotNull QuaternionComponent index) {
        Intrinsics.checkNotNullParameter((Object)((Object)index), (String)"index");
        return switch (WhenMappings.$EnumSwitchMapping$0[index.ordinal()]) {
            case 1 -> this.x;
            case 2 -> this.y;
            case 3 -> this.z;
            case 4 -> this.w;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Float3 get(@NotNull QuaternionComponent index1, @NotNull QuaternionComponent index2, @NotNull QuaternionComponent index3) {
        Intrinsics.checkNotNullParameter((Object)((Object)index1), (String)"index1");
        Intrinsics.checkNotNullParameter((Object)((Object)index2), (String)"index2");
        Intrinsics.checkNotNullParameter((Object)((Object)index3), (String)"index3");
        return new Float3(this.get(index1), this.get(index2), this.get(index3));
    }

    @NotNull
    public final Quaternion get(@NotNull QuaternionComponent index1, @NotNull QuaternionComponent index2, @NotNull QuaternionComponent index3, @NotNull QuaternionComponent index4) {
        Intrinsics.checkNotNullParameter((Object)((Object)index1), (String)"index1");
        Intrinsics.checkNotNullParameter((Object)((Object)index2), (String)"index2");
        Intrinsics.checkNotNullParameter((Object)((Object)index3), (String)"index3");
        Intrinsics.checkNotNullParameter((Object)((Object)index4), (String)"index4");
        return new Quaternion(this.get(index1), this.get(index2), this.get(index3), this.get(index4));
    }

    public final float get(int index) {
        return switch (index) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            case 3 -> this.w;
            default -> throw new IllegalArgumentException("index must be in 0..3");
        };
    }

    @NotNull
    public final Float3 get(int index1, int index2, int index3) {
        return new Float3(this.get(index1), this.get(index2), this.get(index3));
    }

    @NotNull
    public final Quaternion get(int index1, int index2, int index3, int index4) {
        return new Quaternion(this.get(index1), this.get(index2), this.get(index3), this.get(index4));
    }

    public final float invoke(int index) {
        boolean $i$f$invoke = false;
        return this.get(index - 1);
    }

    public final void set(int index, float v) {
        switch (index) {
            case 0: {
                this.x = v;
                break;
            }
            case 1: {
                this.y = v;
                break;
            }
            case 2: {
                this.z = v;
                break;
            }
            case 3: {
                this.w = v;
                break;
            }
            default: {
                throw new IllegalArgumentException("index must be in 0..3");
            }
        }
    }

    public final void set(int index1, int index2, float v) {
        this.set(index1, v);
        this.set(index2, v);
    }

    public final void set(int index1, int index2, int index3, float v) {
        this.set(index1, v);
        this.set(index2, v);
        this.set(index3, v);
    }

    public final void set(int index1, int index2, int index3, int index4, float v) {
        this.set(index1, v);
        this.set(index2, v);
        this.set(index3, v);
        this.set(index4, v);
    }

    public final void set(@NotNull QuaternionComponent index, float v) {
        Intrinsics.checkNotNullParameter((Object)((Object)index), (String)"index");
        switch (WhenMappings.$EnumSwitchMapping$0[index.ordinal()]) {
            case 1: {
                this.x = v;
                break;
            }
            case 2: {
                this.y = v;
                break;
            }
            case 3: {
                this.z = v;
                break;
            }
            case 4: {
                this.w = v;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void set(@NotNull QuaternionComponent index1, @NotNull QuaternionComponent index2, float v) {
        Intrinsics.checkNotNullParameter((Object)((Object)index1), (String)"index1");
        Intrinsics.checkNotNullParameter((Object)((Object)index2), (String)"index2");
        this.set(index1, v);
        this.set(index2, v);
    }

    public final void set(@NotNull QuaternionComponent index1, @NotNull QuaternionComponent index2, @NotNull QuaternionComponent index3, float v) {
        Intrinsics.checkNotNullParameter((Object)((Object)index1), (String)"index1");
        Intrinsics.checkNotNullParameter((Object)((Object)index2), (String)"index2");
        Intrinsics.checkNotNullParameter((Object)((Object)index3), (String)"index3");
        this.set(index1, v);
        this.set(index2, v);
        this.set(index3, v);
    }

    public final void set(@NotNull QuaternionComponent index1, @NotNull QuaternionComponent index2, @NotNull QuaternionComponent index3, @NotNull QuaternionComponent index4, float v) {
        Intrinsics.checkNotNullParameter((Object)((Object)index1), (String)"index1");
        Intrinsics.checkNotNullParameter((Object)((Object)index2), (String)"index2");
        Intrinsics.checkNotNullParameter((Object)((Object)index3), (String)"index3");
        Intrinsics.checkNotNullParameter((Object)((Object)index4), (String)"index4");
        this.set(index1, v);
        this.set(index2, v);
        this.set(index3, v);
        this.set(index4, v);
    }

    @NotNull
    public final Quaternion unaryMinus() {
        return new Quaternion(-this.x, -this.y, -this.z, -this.w);
    }

    @NotNull
    public final Quaternion plus(float v) {
        boolean $i$f$plus = false;
        return new Quaternion(this.getX() + v, this.getY() + v, this.getZ() + v, this.getW() + v);
    }

    @NotNull
    public final Quaternion minus(float v) {
        boolean $i$f$minus = false;
        return new Quaternion(this.getX() - v, this.getY() - v, this.getZ() - v, this.getW() - v);
    }

    @NotNull
    public final Quaternion times(float v) {
        boolean $i$f$times = false;
        return new Quaternion(this.getX() * v, this.getY() * v, this.getZ() * v, this.getW() * v);
    }

    @NotNull
    public final Quaternion div(float v) {
        boolean $i$f$div = false;
        return new Quaternion(this.getX() / v, this.getY() / v, this.getZ() / v, this.getW() / v);
    }

    @NotNull
    public final Float4 compareTo(float v, float delta) {
        boolean $i$f$compareTo = false;
        float $this$compareTo$iv = this.getX();
        boolean $i$f$compareTo2 = false;
        float $this$equals$iv$iv = $this$compareTo$iv;
        boolean $i$f$equals = false;
        float f = Math.abs($this$equals$iv$iv - v) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v);
        $this$compareTo$iv = this.getY();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        float f2 = Math.abs($this$equals$iv$iv - v) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v);
        $this$compareTo$iv = this.getZ();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        float f3 = Math.abs($this$equals$iv$iv - v) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v);
        $this$compareTo$iv = this.getW();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        return new Float4(f, f2, f3, Math.abs($this$equals$iv$iv - v) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v));
    }

    public static /* synthetic */ Float4 compareTo$default(Quaternion $this, float v, float delta, int n, Object object) {
        if ((n & 2) != 0) {
            delta = 0.0f;
        }
        boolean $i$f$compareTo = false;
        float $this$compareTo$iv = $this.getX();
        boolean $i$f$compareTo2 = false;
        float $this$equals$iv$iv = $this$compareTo$iv;
        boolean $i$f$equals = false;
        float f = Math.abs($this$equals$iv$iv - v) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v);
        $this$compareTo$iv = $this.getY();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        float f2 = Math.abs($this$equals$iv$iv - v) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v);
        $this$compareTo$iv = $this.getZ();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        float f3 = Math.abs($this$equals$iv$iv - v) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v);
        $this$compareTo$iv = $this.getW();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        return new Float4(f, f2, f3, Math.abs($this$equals$iv$iv - v) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v));
    }

    @NotNull
    public final Bool4 equals(float v, float delta) {
        boolean $i$f$equals = false;
        float $this$equals$iv = this.getX();
        boolean $i$f$equals2 = false;
        boolean bl = Math.abs($this$equals$iv - v) < delta;
        $this$equals$iv = this.getY();
        $i$f$equals2 = false;
        boolean bl2 = Math.abs($this$equals$iv - v) < delta;
        $this$equals$iv = this.getZ();
        $i$f$equals2 = false;
        boolean bl3 = Math.abs($this$equals$iv - v) < delta;
        $this$equals$iv = this.getW();
        $i$f$equals2 = false;
        return new Bool4(bl, bl2, bl3, Math.abs($this$equals$iv - v) < delta);
    }

    public static /* synthetic */ Bool4 equals$default(Quaternion $this, float v, float delta, int n, Object object) {
        if ((n & 2) != 0) {
            delta = 0.0f;
        }
        boolean $i$f$equals = false;
        float $this$equals$iv = $this.getX();
        boolean $i$f$equals2 = false;
        boolean bl = Math.abs($this$equals$iv - v) < delta;
        $this$equals$iv = $this.getY();
        $i$f$equals2 = false;
        boolean bl2 = Math.abs($this$equals$iv - v) < delta;
        $this$equals$iv = $this.getZ();
        $i$f$equals2 = false;
        boolean bl3 = Math.abs($this$equals$iv - v) < delta;
        $this$equals$iv = $this.getW();
        $i$f$equals2 = false;
        return new Bool4(bl, bl2, bl3, Math.abs($this$equals$iv - v) < delta);
    }

    @NotNull
    public final Float3 times(@NotNull Float3 v) {
        Quaternion this_$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        boolean $i$f$times = false;
        Quaternion quaternion = this;
        Quaternion q$iv = new Quaternion(v, 0.0f);
        boolean $i$f$times2 = false;
        this_$iv = new Quaternion(this_$iv.getW() * q$iv.getX() + this_$iv.getX() * q$iv.getW() + this_$iv.getY() * q$iv.getZ() - this_$iv.getZ() * q$iv.getY(), this_$iv.getW() * q$iv.getY() - this_$iv.getX() * q$iv.getZ() + this_$iv.getY() * q$iv.getW() + this_$iv.getZ() * q$iv.getX(), this_$iv.getW() * q$iv.getZ() + this_$iv.getX() * q$iv.getY() - this_$iv.getY() * q$iv.getX() + this_$iv.getZ() * q$iv.getW(), this_$iv.getW() * q$iv.getW() - this_$iv.getX() * q$iv.getX() - this_$iv.getY() * q$iv.getY() - this_$iv.getZ() * q$iv.getZ());
        q$iv = QuaternionKt.inverse(this);
        $i$f$times2 = false;
        this_$iv = new Quaternion(this_$iv.getW() * q$iv.getX() + this_$iv.getX() * q$iv.getW() + this_$iv.getY() * q$iv.getZ() - this_$iv.getZ() * q$iv.getY(), this_$iv.getW() * q$iv.getY() - this_$iv.getX() * q$iv.getZ() + this_$iv.getY() * q$iv.getW() + this_$iv.getZ() * q$iv.getX(), this_$iv.getW() * q$iv.getZ() + this_$iv.getX() * q$iv.getY() - this_$iv.getY() * q$iv.getX() + this_$iv.getZ() * q$iv.getW(), this_$iv.getW() * q$iv.getW() - this_$iv.getX() * q$iv.getX() - this_$iv.getY() * q$iv.getY() - this_$iv.getZ() * q$iv.getZ());
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    @NotNull
    public final Quaternion plus(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$plus = false;
        return new Quaternion(this.getX() + q.getX(), this.getY() + q.getY(), this.getZ() + q.getZ(), this.getW() + q.getW());
    }

    @NotNull
    public final Quaternion minus(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$minus = false;
        return new Quaternion(this.getX() - q.getX(), this.getY() - q.getY(), this.getZ() - q.getZ(), this.getW() - q.getW());
    }

    @NotNull
    public final Quaternion times(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$times = false;
        return new Quaternion(this.getW() * q.getX() + this.getX() * q.getW() + this.getY() * q.getZ() - this.getZ() * q.getY(), this.getW() * q.getY() - this.getX() * q.getZ() + this.getY() * q.getW() + this.getZ() * q.getX(), this.getW() * q.getZ() + this.getX() * q.getY() - this.getY() * q.getX() + this.getZ() * q.getW(), this.getW() * q.getW() - this.getX() * q.getX() - this.getY() * q.getY() - this.getZ() * q.getZ());
    }

    @NotNull
    public final Float4 compareTo(@NotNull Float4 v, float delta) {
        float $this$compareTo$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        boolean $i$f$compareTo = false;
        float f = this.getX();
        float v$iv = v.getX();
        boolean $i$f$compareTo2 = false;
        float $this$equals$iv$iv = $this$compareTo$iv;
        boolean $i$f$equals = false;
        float f2 = Math.abs((float)($this$equals$iv$iv - v$iv)) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v$iv);
        $this$compareTo$iv = this.getY();
        v$iv = v.getY();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        float f3 = Math.abs($this$equals$iv$iv - v$iv) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v$iv);
        $this$compareTo$iv = this.getZ();
        v$iv = v.getZ();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        float f4 = Math.abs($this$equals$iv$iv - v$iv) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v$iv);
        $this$compareTo$iv = this.getW();
        v$iv = v.getW();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        return new Float4(f2, f3, f4, Math.abs($this$equals$iv$iv - v$iv) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v$iv));
    }

    public static /* synthetic */ Float4 compareTo$default(Quaternion $this, Float4 v, float delta, int n, Object object) {
        float $this$compareTo$iv;
        if ((n & 2) != 0) {
            delta = 0.0f;
        }
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        boolean $i$f$compareTo = false;
        float f = $this.getX();
        float v$iv = v.getX();
        boolean $i$f$compareTo2 = false;
        float $this$equals$iv$iv = $this$compareTo$iv;
        boolean $i$f$equals = false;
        float f2 = Math.abs((float)($this$equals$iv$iv - v$iv)) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v$iv);
        $this$compareTo$iv = $this.getY();
        v$iv = v.getY();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        float f3 = Math.abs($this$equals$iv$iv - v$iv) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v$iv);
        $this$compareTo$iv = $this.getZ();
        v$iv = v.getZ();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        float f4 = Math.abs($this$equals$iv$iv - v$iv) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v$iv);
        $this$compareTo$iv = $this.getW();
        v$iv = v.getW();
        $i$f$compareTo2 = false;
        $this$equals$iv$iv = $this$compareTo$iv;
        $i$f$equals = false;
        return new Float4(f2, f3, f4, Math.abs($this$equals$iv$iv - v$iv) < delta ? 0.0f : (float)Float.compare($this$compareTo$iv, v$iv));
    }

    @NotNull
    public final Bool4 equals(@NotNull Float4 v, float delta) {
        float $this$equals$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        boolean $i$f$equals = false;
        float f = this.getX();
        float v$iv = v.getX();
        boolean $i$f$equals2 = false;
        boolean bl = Math.abs((float)($this$equals$iv - v$iv)) < delta;
        $this$equals$iv = this.getY();
        v$iv = v.getY();
        $i$f$equals2 = false;
        boolean bl2 = Math.abs($this$equals$iv - v$iv) < delta;
        $this$equals$iv = this.getZ();
        v$iv = v.getZ();
        $i$f$equals2 = false;
        boolean bl3 = Math.abs($this$equals$iv - v$iv) < delta;
        $this$equals$iv = this.getW();
        v$iv = v.getW();
        $i$f$equals2 = false;
        return new Bool4(bl, bl2, bl3, Math.abs($this$equals$iv - v$iv) < delta);
    }

    public static /* synthetic */ Bool4 equals$default(Quaternion $this, Float4 v, float delta, int n, Object object) {
        float $this$equals$iv;
        if ((n & 2) != 0) {
            delta = 0.0f;
        }
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        boolean $i$f$equals = false;
        float f = $this.getX();
        float v$iv = v.getX();
        boolean $i$f$equals2 = false;
        boolean bl = Math.abs((float)($this$equals$iv - v$iv)) < delta;
        $this$equals$iv = $this.getY();
        v$iv = v.getY();
        $i$f$equals2 = false;
        boolean bl2 = Math.abs($this$equals$iv - v$iv) < delta;
        $this$equals$iv = $this.getZ();
        v$iv = v.getZ();
        $i$f$equals2 = false;
        boolean bl3 = Math.abs($this$equals$iv - v$iv) < delta;
        $this$equals$iv = $this.getW();
        v$iv = v.getW();
        $i$f$equals2 = false;
        return new Bool4(bl, bl2, bl3, Math.abs($this$equals$iv - v$iv) < delta);
    }

    @NotNull
    public final Quaternion transform(@NotNull Function1<? super Float, Float> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$transform = false;
        this.setX(((Number)block.invoke((Object)Float.valueOf(this.getX()))).floatValue());
        this.setY(((Number)block.invoke((Object)Float.valueOf(this.getY()))).floatValue());
        this.setZ(((Number)block.invoke((Object)Float.valueOf(this.getZ()))).floatValue());
        this.setW(((Number)block.invoke((Object)Float.valueOf(this.getW()))).floatValue());
        return this;
    }

    @NotNull
    public final Float3 toEulerAngles() {
        return QuaternionKt.eulerAngles$default(this, null, 2, null);
    }

    @NotNull
    public final Mat4 toMatrix() {
        return MatrixKt.rotation(this);
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] fArray = new float[]{this.x, this.y, this.z, this.w};
        return fArray;
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    public final float component4() {
        return this.w;
    }

    @NotNull
    public final Quaternion copy(float x, float y, float z, float w) {
        return new Quaternion(x, y, z, w);
    }

    public static /* synthetic */ Quaternion copy$default(Quaternion quaternion, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = quaternion.x;
        }
        if ((n & 2) != 0) {
            f2 = quaternion.y;
        }
        if ((n & 4) != 0) {
            f3 = quaternion.z;
        }
        if ((n & 8) != 0) {
            f4 = quaternion.w;
        }
        return quaternion.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "Quaternion(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = result * 31 + Float.hashCode(this.y);
        result = result * 31 + Float.hashCode(this.z);
        result = result * 31 + Float.hashCode(this.w);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quaternion)) {
            return false;
        }
        Quaternion quaternion = (Quaternion)other;
        if (Float.compare(this.x, quaternion.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, quaternion.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, quaternion.z) != 0) {
            return false;
        }
        return Float.compare(this.w, quaternion.w) == 0;
    }

    public Quaternion() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fJ.\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"Lcom/google/android/filament/utils/Quaternion$Companion;", "", "()V", "fromAxisAngle", "Lcom/google/android/filament/utils/Quaternion;", "axis", "Lcom/google/android/filament/utils/Float3;", "angle", "", "fromEuler", "d", "order", "Lcom/google/android/filament/utils/RotationsOrder;", "yaw", "pitch", "roll", "filament-utils-android_release"})
    @SourceDebugExtension(value={"SMAP\nQuaternion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quaternion.kt\ncom/google/android/filament/utils/Quaternion$Companion\n+ 2 Scalar.kt\ncom/google/android/filament/utils/ScalarKt\n+ 3 Vector.kt\ncom/google/android/filament/utils/VectorKt\n+ 4 Vector.kt\ncom/google/android/filament/utils/Float3\n*L\n1#1,509:1\n48#2:510\n48#2:514\n726#3:511\n794#3:512\n336#4:513\n337#4,3:515\n*S KotlinDebug\n*F\n+ 1 Quaternion.kt\ncom/google/android/filament/utils/Quaternion$Companion\n*L\n50#1:510\n70#1:514\n51#1:511\n70#1:512\n70#1:513\n70#1:515,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Quaternion fromAxisAngle(@NotNull Float3 axis, float angle) {
            void $this$times$iv;
            Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
            boolean $i$f$radians22 = false;
            float r = angle * ((float)Math.PI / 180);
            float $i$f$radians22 = (float)Math.sin(r * 0.5f);
            Float3 v$iv = VectorKt.normalize(axis);
            boolean $i$f$times = false;
            return new Quaternion(new Float3((float)($this$times$iv * v$iv.getX()), (float)($this$times$iv * v$iv.getY()), (float)($this$times$iv * v$iv.getZ())), (float)Math.cos(r * 0.5f));
        }

        @NotNull
        public final Quaternion fromEuler(@NotNull Float3 d, @NotNull RotationsOrder order) {
            float p0;
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
            boolean $i$f$transform = false;
            Float3 this_$iv$iv = Float3.copy$default(d, 0.0f, 0.0f, 0.0f, 7, null);
            boolean $i$f$transform2 = false;
            float f = this_$iv$iv.getX();
            Float3 float3 = this_$iv$iv;
            boolean bl = false;
            boolean $i$f$radians = false;
            float f2 = p0 * ((float)Math.PI / 180);
            float3.setX(f2);
            p0 = this_$iv$iv.getY();
            float3 = this_$iv$iv;
            bl = false;
            $i$f$radians = false;
            f2 = p0 * ((float)Math.PI / 180);
            float3.setY(f2);
            p0 = this_$iv$iv.getZ();
            float3 = this_$iv$iv;
            bl = false;
            $i$f$radians = false;
            f2 = p0 * ((float)Math.PI / 180);
            float3.setZ(f2);
            Float3 r = this_$iv$iv;
            return this.fromEuler(r.get(order.getYaw()), r.get(order.getPitch()), r.get(order.getRoll()), order);
        }

        public static /* synthetic */ Quaternion fromEuler$default(Companion companion, Float3 float3, RotationsOrder rotationsOrder, int n, Object object) {
            if ((n & 2) != 0) {
                rotationsOrder = RotationsOrder.ZYX;
            }
            return companion.fromEuler(float3, rotationsOrder);
        }

        @NotNull
        public final Quaternion fromEuler(float yaw, float pitch, float roll, @NotNull RotationsOrder order) {
            Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
            float c1 = (float)Math.cos(yaw * 0.5f);
            float s1 = (float)Math.sin(yaw * 0.5f);
            float c2 = (float)Math.cos(pitch * 0.5f);
            float s2 = (float)Math.sin(pitch * 0.5f);
            float c3 = (float)Math.cos(roll * 0.5f);
            float s3 = (float)Math.sin(roll * 0.5f);
            return switch (WhenMappings.$EnumSwitchMapping$0[order.ordinal()]) {
                case 1 -> new Quaternion(s1 * c2 * c3 - c1 * s2 * s3, c1 * c2 * s3 - s1 * s2 * c3, s1 * c2 * s3 + c1 * s2 * c3, s1 * s2 * s3 + c1 * c2 * c3);
                case 2 -> new Quaternion(s1 * c2 * c3 + s2 * s3 * c1, s2 * c1 * c3 - s1 * s3 * c2, s1 * s2 * c3 + s3 * c1 * c2, c1 * c2 * c3 - s1 * s2 * s3);
                case 3 -> new Quaternion(s1 * c2 * s3 + c1 * s2 * c3, s1 * c2 * c3 - c1 * s2 * s3, c1 * c2 * s3 - s1 * s2 * c3, s1 * s2 * s3 + c1 * c2 * c3);
                case 4 -> new Quaternion(s1 * s2 * c3 + c1 * c2 * s3, s1 * c2 * c3 + c1 * s2 * s3, c1 * s2 * c3 - s1 * c2 * s3, c1 * c2 * c3 - s1 * s2 * s3);
                case 5 -> new Quaternion(c1 * c2 * s3 - s1 * s2 * c3, s1 * c2 * s3 + c1 * s2 * c3, s1 * c2 * c3 - c1 * s2 * s3, s1 * s2 * s3 + c1 * c2 * c3);
                case 6 -> new Quaternion(c1 * s2 * c3 - s1 * c2 * s3, s1 * s2 * c3 + c1 * c2 * s3, s1 * c2 * c3 + c1 * s2 * s3, c1 * c2 * c3 - s1 * s2 * s3);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static /* synthetic */ Quaternion fromEuler$default(Companion companion, float f, float f2, float f3, RotationsOrder rotationsOrder, int n, Object object) {
            if ((n & 1) != 0) {
                f = 0.0f;
            }
            if ((n & 2) != 0) {
                f2 = 0.0f;
            }
            if ((n & 4) != 0) {
                f3 = 0.0f;
            }
            if ((n & 8) != 0) {
                rotationsOrder = RotationsOrder.ZYX;
            }
            return companion.fromEuler(f, f2, f3, rotationsOrder);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RotationsOrder.values().length];
                try {
                    nArray[RotationsOrder.XZY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RotationsOrder.XYZ.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RotationsOrder.YXZ.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RotationsOrder.YZX.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RotationsOrder.ZYX.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RotationsOrder.ZXY.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QuaternionComponent.values().length];
            try {
                nArray[QuaternionComponent.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuaternionComponent.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuaternionComponent.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuaternionComponent.W.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

