/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import android.view.MotionEvent;
import android.view.View;
import com.google.android.filament.utils.Float2;
import com.google.android.filament.utils.Manipulator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/google/android/filament/utils/GestureDetector;", "", "view", "Landroid/view/View;", "manipulator", "Lcom/google/android/filament/utils/Manipulator;", "(Landroid/view/View;Lcom/google/android/filament/utils/Manipulator;)V", "currentGesture", "Lcom/google/android/filament/utils/GestureDetector$Gesture;", "kGestureConfidenceCount", "", "kPanConfidenceDistance", "kZoomConfidenceDistance", "kZoomSpeed", "", "previousTouch", "Lcom/google/android/filament/utils/GestureDetector$TouchPair;", "tentativeOrbitEvents", "Ljava/util/ArrayList;", "tentativePanEvents", "tentativeZoomEvents", "endGesture", "", "isOrbitGesture", "", "isPanGesture", "isZoomGesture", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "Gesture", "TouchPair", "filament-utils-android_release"})
@SourceDebugExtension(value={"SMAP\nGestureDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GestureDetector.kt\ncom/google/android/filament/utils/GestureDetector\n+ 2 Vector.kt\ncom/google/android/filament/utils/VectorKt\n+ 3 Vector.kt\ncom/google/android/filament/utils/Float2\n*L\n1#1,155:1\n626#2:156\n624#2:158\n137#3:157\n*S KotlinDebug\n*F\n+ 1 GestureDetector.kt\ncom/google/android/filament/utils/GestureDetector\n*L\n143#1:156\n143#1:158\n143#1:157\n*E\n"})
public final class GestureDetector {
    @NotNull
    private final View view;
    @NotNull
    private final Manipulator manipulator;
    @NotNull
    private Gesture currentGesture;
    @NotNull
    private TouchPair previousTouch;
    @NotNull
    private final ArrayList<TouchPair> tentativePanEvents;
    @NotNull
    private final ArrayList<TouchPair> tentativeOrbitEvents;
    @NotNull
    private final ArrayList<TouchPair> tentativeZoomEvents;
    private final int kGestureConfidenceCount;
    private final int kPanConfidenceDistance;
    private final int kZoomConfidenceDistance;
    private final float kZoomSpeed;

    public GestureDetector(@NotNull View view, @NotNull Manipulator manipulator) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)manipulator, (String)"manipulator");
        this.view = view;
        this.manipulator = manipulator;
        this.currentGesture = Gesture.NONE;
        this.previousTouch = new TouchPair();
        this.tentativePanEvents = new ArrayList();
        this.tentativeOrbitEvents = new ArrayList();
        this.tentativeZoomEvents = new ArrayList();
        this.kGestureConfidenceCount = 2;
        this.kPanConfidenceDistance = 4;
        this.kZoomConfidenceDistance = 10;
        this.kZoomSpeed = 0.1f;
    }

    public final void onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TouchPair touch = new TouchPair(event, this.view.getHeight());
        switch (event.getActionMasked()) {
            case 2: {
                if (event.getPointerCount() != 1 && this.currentGesture == Gesture.ORBIT || event.getPointerCount() != 2 && this.currentGesture == Gesture.PAN || event.getPointerCount() != 2 && this.currentGesture == Gesture.ZOOM) {
                    this.endGesture();
                    return;
                }
                if (this.currentGesture == Gesture.ZOOM) {
                    float d0 = this.previousTouch.getSeparation();
                    float d1 = touch.getSeparation();
                    this.manipulator.scroll(touch.getX(), touch.getY(), (d0 - d1) * this.kZoomSpeed);
                    this.previousTouch = touch;
                    return;
                }
                if (this.currentGesture != Gesture.NONE) {
                    this.manipulator.grabUpdate(touch.getX(), touch.getY());
                    return;
                }
                if (event.getPointerCount() == 1) {
                    this.tentativeOrbitEvents.add(touch);
                }
                if (event.getPointerCount() == 2) {
                    this.tentativePanEvents.add(touch);
                    this.tentativeZoomEvents.add(touch);
                }
                if (this.isOrbitGesture()) {
                    this.manipulator.grabBegin(touch.getX(), touch.getY(), false);
                    this.currentGesture = Gesture.ORBIT;
                    return;
                }
                if (this.isZoomGesture()) {
                    this.currentGesture = Gesture.ZOOM;
                    this.previousTouch = touch;
                    return;
                }
                if (!this.isPanGesture()) break;
                this.manipulator.grabBegin(touch.getX(), touch.getY(), true);
                this.currentGesture = Gesture.PAN;
                return;
            }
            case 1: 
            case 3: {
                this.endGesture();
            }
        }
    }

    private final void endGesture() {
        this.tentativePanEvents.clear();
        this.tentativeOrbitEvents.clear();
        this.tentativeZoomEvents.clear();
        this.currentGesture = Gesture.NONE;
        this.manipulator.grabEnd();
    }

    private final boolean isOrbitGesture() {
        return this.tentativeOrbitEvents.size() > this.kGestureConfidenceCount;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPanGesture() {
        void v$iv$iv;
        if (this.tentativePanEvents.size() <= this.kGestureConfidenceCount) {
            return false;
        }
        Float2 oldest = ((TouchPair)CollectionsKt.first((List)this.tentativePanEvents)).getMidpoint();
        Float2 newest = ((TouchPair)CollectionsKt.last((List)this.tentativePanEvents)).getMidpoint();
        boolean $i$f$distance = false;
        Float2 this_$iv$iv = oldest;
        boolean $i$f$minus = false;
        this_$iv$iv = new Float2(this_$iv$iv.getX() - newest.getX(), this_$iv$iv.getY() - newest.getY());
        boolean $i$f$length = false;
        return (float)Math.sqrt(v$iv$iv.getX() * v$iv$iv.getX() + v$iv$iv.getY() * v$iv$iv.getY()) > (float)this.kPanConfidenceDistance;
    }

    private final boolean isZoomGesture() {
        if (this.tentativeZoomEvents.size() <= this.kGestureConfidenceCount) {
            return false;
        }
        float oldest = ((TouchPair)CollectionsKt.first((List)this.tentativeZoomEvents)).getSeparation();
        float newest = ((TouchPair)CollectionsKt.last((List)this.tentativeZoomEvents)).getSeparation();
        return Math.abs(newest - oldest) > (float)this.kZoomConfidenceDistance;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/android/filament/utils/GestureDetector$Gesture;", "", "(Ljava/lang/String;I)V", "NONE", "ORBIT", "PAN", "ZOOM", "filament-utils-android_release"})
    private static final class Gesture
    extends Enum<Gesture> {
        public static final /* enum */ Gesture NONE = new Gesture();
        public static final /* enum */ Gesture ORBIT = new Gesture();
        public static final /* enum */ Gesture PAN = new Gesture();
        public static final /* enum */ Gesture ZOOM = new Gesture();
        private static final /* synthetic */ Gesture[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Gesture[] values() {
            return (Gesture[])$VALUES.clone();
        }

        public static Gesture valueOf(String value) {
            return Enum.valueOf(Gesture.class, value);
        }

        @NotNull
        public static EnumEntries<Gesture> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = gestureArray = new Gesture[]{Gesture.NONE, Gesture.ORBIT, Gesture.PAN, Gesture.ZOOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J'\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0013\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000eR\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000e\u00a8\u0006+"}, d2={"Lcom/google/android/filament/utils/GestureDetector$TouchPair;", "", "()V", "me", "Landroid/view/MotionEvent;", "height", "", "(Landroid/view/MotionEvent;I)V", "pt0", "Lcom/google/android/filament/utils/Float2;", "pt1", "count", "(Lcom/google/android/filament/utils/Float2;Lcom/google/android/filament/utils/Float2;I)V", "getCount", "()I", "setCount", "(I)V", "midpoint", "getMidpoint", "()Lcom/google/android/filament/utils/Float2;", "getPt0", "setPt0", "(Lcom/google/android/filament/utils/Float2;)V", "getPt1", "setPt1", "separation", "", "getSeparation", "()F", "x", "getX", "y", "getY", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "filament-utils-android_release"})
    @SourceDebugExtension(value={"SMAP\nGestureDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GestureDetector.kt\ncom/google/android/filament/utils/GestureDetector$TouchPair\n+ 2 Vector.kt\ncom/google/android/filament/utils/VectorKt\n+ 3 Vector.kt\ncom/google/android/filament/utils/Float2\n+ 4 Scalar.kt\ncom/google/android/filament/utils/ScalarKt\n*L\n1#1,155:1\n626#2:156\n624#2:158\n660#2,2:159\n662#2:162\n137#3:157\n42#4:161\n*S KotlinDebug\n*F\n+ 1 GestureDetector.kt\ncom/google/android/filament/utils/GestureDetector$TouchPair\n*L\n44#1:156\n44#1:158\n45#1:159,2\n45#1:162\n44#1:157\n45#1:161\n*E\n"})
    private static final class TouchPair {
        @NotNull
        private Float2 pt0;
        @NotNull
        private Float2 pt1;
        private int count;

        public TouchPair(@NotNull Float2 pt0, @NotNull Float2 pt1, int count) {
            Intrinsics.checkNotNullParameter((Object)pt0, (String)"pt0");
            Intrinsics.checkNotNullParameter((Object)pt1, (String)"pt1");
            this.pt0 = pt0;
            this.pt1 = pt1;
            this.count = count;
        }

        @NotNull
        public final Float2 getPt0() {
            return this.pt0;
        }

        public final void setPt0(@NotNull Float2 float2) {
            Intrinsics.checkNotNullParameter((Object)float2, (String)"<set-?>");
            this.pt0 = float2;
        }

        @NotNull
        public final Float2 getPt1() {
            return this.pt1;
        }

        public final void setPt1(@NotNull Float2 float2) {
            Intrinsics.checkNotNullParameter((Object)float2, (String)"<set-?>");
            this.pt1 = float2;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public TouchPair() {
            this(new Float2(0.0f), new Float2(0.0f), 0);
        }

        public TouchPair(@NotNull MotionEvent me, int height) {
            int n;
            Intrinsics.checkNotNullParameter((Object)me, (String)"me");
            this();
            if (me.getPointerCount() >= 1) {
                this.pt1 = this.pt0 = new Float2(me.getX(0), (float)height - me.getY(0));
                n = this.count;
                this.count = n + 1;
            }
            if (me.getPointerCount() >= 2) {
                this.pt1 = new Float2(me.getX(1), (float)height - me.getY(1));
                n = this.count;
                this.count = n + 1;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final float getSeparation() {
            void v$iv$iv;
            void a$iv;
            Float2 float2 = this.pt0;
            Float2 b$iv = this.pt1;
            boolean $i$f$distance = false;
            Float2 this_$iv$iv = a$iv;
            boolean $i$f$minus = false;
            this_$iv$iv = new Float2(this_$iv$iv.getX() - b$iv.getX(), this_$iv$iv.getY() - b$iv.getY());
            boolean $i$f$length = false;
            return (float)Math.sqrt(v$iv$iv.getX() * v$iv$iv.getX() + v$iv$iv.getY() * v$iv$iv.getY());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Float2 getMidpoint() {
            float a$iv$iv;
            void b$iv;
            void a$iv;
            Float2 float2 = this.pt0;
            Float2 float22 = this.pt1;
            float x$iv = 0.5f;
            boolean $i$f$mix = false;
            float f = a$iv.getX();
            float b$iv$iv = b$iv.getX();
            boolean $i$f$mix2 = false;
            void v0 = a$iv$iv * (1.0f - x$iv) + b$iv$iv * x$iv;
            a$iv$iv = a$iv.getY();
            b$iv$iv = b$iv.getY();
            $i$f$mix2 = false;
            return new Float2((float)v0, a$iv$iv * (1.0f - x$iv) + b$iv$iv * x$iv);
        }

        public final int getX() {
            return (int)this.getMidpoint().getX();
        }

        public final int getY() {
            return (int)this.getMidpoint().getY();
        }

        @NotNull
        public final Float2 component1() {
            return this.pt0;
        }

        @NotNull
        public final Float2 component2() {
            return this.pt1;
        }

        public final int component3() {
            return this.count;
        }

        @NotNull
        public final TouchPair copy(@NotNull Float2 pt0, @NotNull Float2 pt1, int count) {
            Intrinsics.checkNotNullParameter((Object)pt0, (String)"pt0");
            Intrinsics.checkNotNullParameter((Object)pt1, (String)"pt1");
            return new TouchPair(pt0, pt1, count);
        }

        public static /* synthetic */ TouchPair copy$default(TouchPair touchPair, Float2 float2, Float2 float22, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                float2 = touchPair.pt0;
            }
            if ((n2 & 2) != 0) {
                float22 = touchPair.pt1;
            }
            if ((n2 & 4) != 0) {
                n = touchPair.count;
            }
            return touchPair.copy(float2, float22, n);
        }

        @NotNull
        public String toString() {
            return "TouchPair(pt0=" + this.pt0 + ", pt1=" + this.pt1 + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = this.pt0.hashCode();
            result = result * 31 + this.pt1.hashCode();
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TouchPair)) {
                return false;
            }
            TouchPair touchPair = (TouchPair)other;
            if (!Intrinsics.areEqual((Object)this.pt0, (Object)touchPair.pt0)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pt1, (Object)touchPair.pt1)) {
                return false;
            }
            return this.count == touchPair.count;
        }
    }
}

