/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import androidx.annotation.NonNull;
import com.google.android.filament.ColorGrading;
import com.google.android.filament.Engine;
import com.google.android.filament.Entity;
import com.google.android.filament.IndirectLight;
import com.google.android.filament.LightManager;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.Renderer;
import com.google.android.filament.Scene;
import com.google.android.filament.View;

public class AutomationEngine {
    private final long mNativeObject;
    private ColorGrading mColorGrading;

    public AutomationEngine(@NonNull String jsonSpec) {
        this.mNativeObject = AutomationEngine.nCreateAutomationEngine(jsonSpec);
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Couldn't create AutomationEngine");
        }
    }

    public AutomationEngine() {
        this.mNativeObject = AutomationEngine.nCreateDefaultAutomationEngine();
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Couldn't create AutomationEngine");
        }
    }

    public void setOptions(@NonNull Options options) {
        AutomationEngine.nSetOptions(this.mNativeObject, options.sleepDuration, options.minFrameCount, options.verbose);
    }

    public void startRunning() {
        AutomationEngine.nStartRunning(this.mNativeObject);
    }

    public void startBatchMode() {
        AutomationEngine.nStartBatchMode(this.mNativeObject);
    }

    public void tick(@NonNull Engine engine, @NonNull ViewerContent content, float deltaTime) {
        if (content.view == null || content.renderer == null) {
            throw new IllegalStateException("Must provide a View and Renderer");
        }
        long[] nativeMaterialInstances = null;
        if (content.materials != null) {
            nativeMaterialInstances = new long[content.materials.length];
            for (int i = 0; i < nativeMaterialInstances.length; ++i) {
                nativeMaterialInstances[i] = content.materials[i].getNativeObject();
            }
        }
        long nativeView = content.view.getNativeObject();
        long nativeRenderer = content.renderer.getNativeObject();
        AutomationEngine.nTick(this.mNativeObject, engine.getNativeObject(), nativeView, nativeMaterialInstances, nativeRenderer, deltaTime);
    }

    public void applySettings(@NonNull Engine engine, @NonNull String settingsJson, @NonNull ViewerContent content) {
        if (content.view == null || content.renderer == null) {
            throw new IllegalStateException("Must provide a View and Renderer");
        }
        long[] nativeMaterialInstances = null;
        if (content.lightManager == null || content.scene == null) {
            throw new IllegalStateException("Must provide a LightManager and Scene");
        }
        if (content.materials != null) {
            nativeMaterialInstances = new long[content.materials.length];
            for (int i = 0; i < nativeMaterialInstances.length; ++i) {
                nativeMaterialInstances[i] = content.materials[i].getNativeObject();
            }
        }
        long nativeView = content.view.getNativeObject();
        long nativeIbl = content.indirectLight == null ? 0L : content.indirectLight.getNativeObject();
        long nativeLm = content.lightManager.getNativeObject();
        long nativeScene = content.scene.getNativeObject();
        long nativeRenderer = content.renderer.getNativeObject();
        AutomationEngine.nApplySettings(this.mNativeObject, engine.getNativeObject(), settingsJson, nativeView, nativeMaterialInstances, nativeIbl, content.sunlight, content.assetLights, nativeLm, nativeScene, nativeRenderer);
    }

    @NonNull
    public ViewerOptions getViewerOptions() {
        ViewerOptions result = new ViewerOptions();
        AutomationEngine.nGetViewerOptions(this.mNativeObject, result);
        return result;
    }

    @NonNull
    public ColorGrading getColorGrading(@NonNull Engine engine) {
        long nativeCg = AutomationEngine.nGetColorGrading(this.mNativeObject, engine.getNativeObject());
        if (this.mColorGrading == null || this.mColorGrading.getNativeObject() != nativeCg) {
            this.mColorGrading = nativeCg == 0L ? null : new ColorGrading(nativeCg);
        }
        return this.mColorGrading;
    }

    public void signalBatchMode() {
        AutomationEngine.nSignalBatchMode(this.mNativeObject);
    }

    public void stopRunning() {
        AutomationEngine.nStopRunning(this.mNativeObject);
    }

    public boolean shouldClose() {
        return AutomationEngine.nShouldClose(this.mNativeObject);
    }

    protected void finalize() throws Throwable {
        AutomationEngine.nDestroy(this.mNativeObject);
        super.finalize();
    }

    private static native long nCreateAutomationEngine(String var0);

    private static native long nCreateDefaultAutomationEngine();

    private static native void nSetOptions(long var0, float var2, int var3, boolean var4);

    private static native void nStartRunning(long var0);

    private static native void nStartBatchMode(long var0);

    private static native void nTick(long var0, long var2, long var4, long[] var6, long var7, float var9);

    private static native void nApplySettings(long var0, long var2, String var4, long var5, long[] var7, long var8, int var10, int[] var11, long var12, long var14, long var16);

    private static native void nGetViewerOptions(long var0, Object var2);

    private static native long nGetColorGrading(long var0, long var2);

    private static native void nSignalBatchMode(long var0);

    private static native void nStopRunning(long var0);

    private static native boolean nShouldClose(long var0);

    private static native void nDestroy(long var0);

    public static class Options {
        public float sleepDuration = 0.2f;
        public int minFrameCount = 2;
        public boolean verbose = true;
    }

    public static class ViewerContent {
        public View view;
        public Renderer renderer;
        public MaterialInstance[] materials;
        public LightManager lightManager;
        public Scene scene;
        public IndirectLight indirectLight;
        @Entity
        public int sunlight;
        @Entity
        public int[] assetLights;
    }

    public static class ViewerOptions {
        public float cameraAperture = 16.0f;
        public float cameraSpeed = 125.0f;
        public float cameraISO = 100.0f;
        public float cameraNear = 0.1f;
        public float cameraFar = 100.0f;
        public float groundShadowStrength = 0.75f;
        public boolean groundPlaneEnabled = false;
        public boolean skyboxEnabled = true;
        public float cameraFocalLength = 28.0f;
        public float cameraFocusDistance = 0.0f;
        public boolean autoScaleEnabled = true;
        public boolean autoInstancingEnabled = false;
    }
}

