/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import com.google.android.filament.Engine;
import com.google.android.filament.Texture;
import java.nio.Buffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0082 \u00a8\u0006\u0013"}, d2={"Lcom/google/android/filament/utils/HDRLoader;", "", "<init>", "()V", "createTexture", "Lcom/google/android/filament/Texture;", "engine", "Lcom/google/android/filament/Engine;", "buffer", "Ljava/nio/Buffer;", "options", "Lcom/google/android/filament/utils/HDRLoader$Options;", "nCreateHDRTexture", "", "nativeEngine", "remaining", "", "format", "Options", "filament-utils-android_release"})
public final class HDRLoader {
    @NotNull
    public static final HDRLoader INSTANCE = new HDRLoader();

    private HDRLoader() {
    }

    @Nullable
    public final Texture createTexture(@NotNull Engine engine, @NotNull Buffer buffer, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long nativeEngine = engine.getNativeObject();
        long nativeTexture = this.nCreateHDRTexture(nativeEngine, buffer, buffer.remaining(), options.getDesiredFormat().ordinal());
        if (nativeTexture == 0L) {
            return null;
        }
        return new Texture(nativeTexture);
    }

    public static /* synthetic */ Texture createTexture$default(HDRLoader hDRLoader, Engine engine, Buffer buffer, Options options, int n, Object object) {
        if ((n & 4) != 0) {
            options = new Options();
        }
        return hDRLoader.createTexture(engine, buffer, options);
    }

    private final native long nCreateHDRTexture(long var1, Buffer var3, int var4, int var5);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/google/android/filament/utils/HDRLoader$Options;", "", "<init>", "()V", "desiredFormat", "Lcom/google/android/filament/Texture$InternalFormat;", "getDesiredFormat", "()Lcom/google/android/filament/Texture$InternalFormat;", "setDesiredFormat", "(Lcom/google/android/filament/Texture$InternalFormat;)V", "filament-utils-android_release"})
    public static final class Options {
        @NotNull
        private Texture.InternalFormat desiredFormat = Texture.InternalFormat.RGB16F;

        @NotNull
        public final Texture.InternalFormat getDesiredFormat() {
            return this.desiredFormat;
        }

        public final void setDesiredFormat(@NotNull Texture.InternalFormat internalFormat) {
            Intrinsics.checkNotNullParameter((Object)internalFormat, (String)"<set-?>");
            this.desiredFormat = internalFormat;
        }
    }
}

