/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import com.google.android.filament.Engine;
import com.google.android.filament.IndirectLight;
import com.google.android.filament.Skybox;
import com.google.android.filament.Texture;
import java.nio.Buffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tJ)\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0082 J)\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0082 J!\u0010\u001a\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0011H\u0082 J)\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0082 \u00a8\u0006\u001e"}, d2={"Lcom/google/android/filament/utils/KTX1Loader;", "", "<init>", "()V", "createTexture", "Lcom/google/android/filament/Texture;", "engine", "Lcom/google/android/filament/Engine;", "buffer", "Ljava/nio/Buffer;", "options", "Lcom/google/android/filament/utils/KTX1Loader$Options;", "createIndirectLight", "Lcom/google/android/filament/IndirectLight;", "createSkybox", "Lcom/google/android/filament/Skybox;", "getSphericalHarmonics", "", "nCreateKTXTexture", "", "nativeEngine", "remaining", "", "srgb", "", "nCreateIndirectLight", "nGetSphericalHarmonics", "outSphericalHarmonics", "nCreateSkybox", "Options", "filament-utils-android_release"})
public final class KTX1Loader {
    @NotNull
    public static final KTX1Loader INSTANCE = new KTX1Loader();

    private KTX1Loader() {
    }

    @NotNull
    public final Texture createTexture(@NotNull Engine engine, @NotNull Buffer buffer, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long nativeEngine = engine.getNativeObject();
        long nativeTexture = this.nCreateKTXTexture(nativeEngine, buffer, buffer.remaining(), options.getSrgb());
        return new Texture(nativeTexture);
    }

    public static /* synthetic */ Texture createTexture$default(KTX1Loader kTX1Loader, Engine engine, Buffer buffer, Options options, int n, Object object) {
        if ((n & 4) != 0) {
            options = new Options();
        }
        return kTX1Loader.createTexture(engine, buffer, options);
    }

    @NotNull
    public final IndirectLight createIndirectLight(@NotNull Engine engine, @NotNull Buffer buffer, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long nativeEngine = engine.getNativeObject();
        long nativeIndirectLight = this.nCreateIndirectLight(nativeEngine, buffer, buffer.remaining(), options.getSrgb());
        return new IndirectLight(nativeIndirectLight);
    }

    public static /* synthetic */ IndirectLight createIndirectLight$default(KTX1Loader kTX1Loader, Engine engine, Buffer buffer, Options options, int n, Object object) {
        if ((n & 4) != 0) {
            options = new Options();
        }
        return kTX1Loader.createIndirectLight(engine, buffer, options);
    }

    @NotNull
    public final Skybox createSkybox(@NotNull Engine engine, @NotNull Buffer buffer, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long nativeEngine = engine.getNativeObject();
        long nativeSkybox = this.nCreateSkybox(nativeEngine, buffer, buffer.remaining(), options.getSrgb());
        return new Skybox(nativeSkybox);
    }

    public static /* synthetic */ Skybox createSkybox$default(KTX1Loader kTX1Loader, Engine engine, Buffer buffer, Options options, int n, Object object) {
        if ((n & 4) != 0) {
            options = new Options();
        }
        return kTX1Loader.createSkybox(engine, buffer, options);
    }

    @Nullable
    public final float[] getSphericalHarmonics(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        float[] sphericalHarmonics = new float[27];
        boolean success = this.nGetSphericalHarmonics(buffer, buffer.remaining(), sphericalHarmonics);
        return (float[])(success ? sphericalHarmonics : null);
    }

    private final native long nCreateKTXTexture(long var1, Buffer var3, int var4, boolean var5);

    private final native long nCreateIndirectLight(long var1, Buffer var3, int var4, boolean var5);

    private final native boolean nGetSphericalHarmonics(Buffer var1, int var2, float[] var3);

    private final native long nCreateSkybox(long var1, Buffer var3, int var4, boolean var5);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/google/android/filament/utils/KTX1Loader$Options;", "", "<init>", "()V", "srgb", "", "getSrgb", "()Z", "setSrgb", "(Z)V", "filament-utils-android_release"})
    public static final class Options {
        private boolean srgb;

        public final boolean getSrgb() {
            return this.srgb;
        }

        public final void setSrgb(boolean bl) {
            this.srgb = bl;
        }
    }
}

