/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.google.android.filament.Engine;
import com.google.android.filament.Texture;
import com.google.android.filament.android.TextureHelper;
import com.google.android.filament.utils.TextureType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"SKIP_BITMAP_COPY", "", "loadTexture", "Lcom/google/android/filament/Texture;", "engine", "Lcom/google/android/filament/Engine;", "resources", "Landroid/content/res/Resources;", "resourceId", "", "type", "Lcom/google/android/filament/utils/TextureType;", "internalFormat", "Lcom/google/android/filament/Texture$InternalFormat;", "format", "Lcom/google/android/filament/Texture$Format;", "bitmap", "Landroid/graphics/Bitmap;", "Lcom/google/android/filament/Texture$Type;", "filament-utils-android_release"})
public final class TextureLoaderKt {
    public static final boolean SKIP_BITMAP_COPY = true;

    @NotNull
    public static final Texture loadTexture(@NotNull Engine engine, @NotNull Resources resources, int resourceId, @NotNull TextureType type) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPremultiplied = type == TextureType.COLOR;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)options);
        Texture texture = new Texture.Builder().width(bitmap.getWidth()).height(bitmap.getHeight()).sampler(Texture.Sampler.SAMPLER_2D).format(TextureLoaderKt.internalFormat(type)).levels(255).build(engine);
        Intrinsics.checkNotNullExpressionValue((Object)texture, (String)"build(...)");
        Texture texture2 = texture;
        TextureHelper.setBitmap((Engine)engine, (Texture)texture2, (int)0, (Bitmap)bitmap);
        texture2.generateMipmaps(engine);
        return texture2;
    }

    private static final Texture.InternalFormat internalFormat(TextureType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> Texture.InternalFormat.SRGB8_A8;
            case 2 -> Texture.InternalFormat.RGBA8;
            case 3 -> Texture.InternalFormat.RGBA8;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Texture.Format format(Bitmap bitmap) {
        return switch (bitmap.getConfig().name()) {
            case "ALPHA_8" -> Texture.Format.ALPHA;
            case "RGB_565" -> Texture.Format.RGB;
            case "ARGB_8888" -> Texture.Format.RGBA;
            case "RGBA_F16" -> Texture.Format.RGBA;
            default -> throw new IllegalArgumentException("Unknown bitmap configuration");
        };
    }

    private static final Texture.Type type(Bitmap bitmap) {
        return switch (bitmap.getConfig().name()) {
            case "ALPHA_8" -> Texture.Type.USHORT;
            case "RGB_565" -> Texture.Type.USHORT_565;
            case "ARGB_8888" -> Texture.Type.UBYTE;
            case "RGBA_F16" -> Texture.Type.HALF;
            default -> throw new IllegalArgumentException("Unsupported bitmap configuration");
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextureType.values().length];
            try {
                nArray[TextureType.COLOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextureType.NORMAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextureType.DATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

