/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.gltfio;

import androidx.annotation.NonNull;
import com.google.android.filament.Entity;
import com.google.android.filament.gltfio.Animator;
import com.google.android.filament.gltfio.FilamentAsset;

public class FilamentInstance {
    private FilamentAsset mAsset;
    private long mNativeObject;
    private Animator mAnimator;

    FilamentInstance(FilamentAsset asset, long nativeObject) {
        this.mAsset = asset;
        this.mNativeObject = nativeObject;
        this.mAnimator = null;
    }

    long getNativeObject() {
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    @NonNull
    public FilamentAsset getAsset() {
        return this.mAsset;
    }

    @Entity
    public int getRoot() {
        return FilamentInstance.nGetRoot(this.mNativeObject);
    }

    @NonNull
    @Entity
    public int[] getEntities() {
        int[] result = new int[FilamentInstance.nGetEntityCount(this.mNativeObject)];
        FilamentInstance.nGetEntities(this.mNativeObject, result);
        return result;
    }

    @NonNull
    public Animator getAnimator() {
        if (this.mAnimator != null) {
            return this.mAnimator;
        }
        this.mAnimator = new Animator(FilamentInstance.nGetAnimator(this.mNativeObject));
        return this.mAnimator;
    }

    private static native int nGetRoot(long var0);

    private static native int nGetEntityCount(long var0);

    private static native void nGetEntities(long var0, int[] var2);

    private static native long nGetAnimator(long var0);
}

