/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.gltfio;

import androidx.annotation.NonNull;
import com.google.android.filament.Engine;
import com.google.android.filament.gltfio.FilamentAsset;
import java.nio.Buffer;

public class ResourceLoader {
    private final long mNativeObject;
    private final long mNativeStbProvider;
    private final long mNativeKtx2Provider;

    public ResourceLoader(@NonNull Engine engine) {
        long nativeEngine = engine.getNativeObject();
        this.mNativeObject = ResourceLoader.nCreateResourceLoader(nativeEngine, false);
        this.mNativeStbProvider = ResourceLoader.nCreateStbProvider(nativeEngine);
        this.mNativeKtx2Provider = ResourceLoader.nCreateKtx2Provider(nativeEngine);
        ResourceLoader.nAddTextureProvider(this.mNativeObject, "image/jpeg", this.mNativeStbProvider);
        ResourceLoader.nAddTextureProvider(this.mNativeObject, "image/png", this.mNativeStbProvider);
        ResourceLoader.nAddTextureProvider(this.mNativeObject, "image/ktx2", this.mNativeKtx2Provider);
    }

    public ResourceLoader(@NonNull Engine engine, boolean normalizeSkinningWeights) {
        long nativeEngine = engine.getNativeObject();
        this.mNativeObject = ResourceLoader.nCreateResourceLoader(nativeEngine, normalizeSkinningWeights);
        this.mNativeStbProvider = ResourceLoader.nCreateStbProvider(nativeEngine);
        this.mNativeKtx2Provider = ResourceLoader.nCreateKtx2Provider(nativeEngine);
        ResourceLoader.nAddTextureProvider(this.mNativeObject, "image/jpeg", this.mNativeStbProvider);
        ResourceLoader.nAddTextureProvider(this.mNativeObject, "image/png", this.mNativeStbProvider);
        ResourceLoader.nAddTextureProvider(this.mNativeObject, "image/ktx2", this.mNativeKtx2Provider);
    }

    public void destroy() {
        ResourceLoader.nDestroyResourceLoader(this.mNativeObject);
        ResourceLoader.nDestroyTextureProvider(this.mNativeStbProvider);
        ResourceLoader.nDestroyTextureProvider(this.mNativeKtx2Provider);
    }

    @NonNull
    public ResourceLoader addResourceData(@NonNull String uri, @NonNull Buffer buffer) {
        ResourceLoader.nAddResourceData(this.mNativeObject, uri, buffer, buffer.remaining());
        return this;
    }

    public boolean hasResourceData(@NonNull String uri) {
        return ResourceLoader.nHasResourceData(this.mNativeObject, uri);
    }

    public void evictResourceData() {
        ResourceLoader.nEvictResourceData(this.mNativeObject);
    }

    @NonNull
    public ResourceLoader loadResources(@NonNull FilamentAsset asset) {
        ResourceLoader.nLoadResources(this.mNativeObject, asset.getNativeObject());
        return this;
    }

    public boolean asyncBeginLoad(@NonNull FilamentAsset asset) {
        return ResourceLoader.nAsyncBeginLoad(this.mNativeObject, asset.getNativeObject());
    }

    public float asyncGetLoadProgress() {
        return ResourceLoader.nAsyncGetLoadProgress(this.mNativeObject);
    }

    public void asyncUpdateLoad() {
        ResourceLoader.nAsyncUpdateLoad(this.mNativeObject);
    }

    public void asyncCancelLoad() {
        ResourceLoader.nAsyncCancelLoad(this.mNativeObject);
    }

    private static native long nCreateResourceLoader(long var0, boolean var2);

    private static native void nDestroyResourceLoader(long var0);

    private static native void nAddResourceData(long var0, String var2, Buffer var3, int var4);

    private static native void nEvictResourceData(long var0);

    private static native boolean nHasResourceData(long var0, String var2);

    private static native void nLoadResources(long var0, long var2);

    private static native boolean nAsyncBeginLoad(long var0, long var2);

    private static native float nAsyncGetLoadProgress(long var0);

    private static native void nAsyncUpdateLoad(long var0);

    private static native void nAsyncCancelLoad(long var0);

    private static native long nCreateStbProvider(long var0);

    private static native long nCreateKtx2Provider(long var0);

    private static native void nAddTextureProvider(long var0, String var2, long var3);

    private static native void nDestroyTextureProvider(long var0);
}

