/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.gltfio;

import androidx.annotation.IntRange;

public class Animator {
    private long mNativeObject;

    Animator(long nativeObject) {
        this.mNativeObject = nativeObject;
    }

    public void applyAnimation(@IntRange(from=0L) int animationIndex, float time) {
        Animator.nApplyAnimation(this.getNativeObject(), animationIndex, time);
    }

    public void updateBoneMatrices() {
        Animator.nUpdateBoneMatrices(this.getNativeObject());
    }

    public void applyCrossFade(int previousAnimIndex, float previousAnimTime, float alpha) {
        Animator.nApplyCrossFade(this.getNativeObject(), previousAnimIndex, previousAnimTime, alpha);
    }

    public void resetBoneMatrices() {
        Animator.nResetBoneMatrices(this.getNativeObject());
    }

    public int getAnimationCount() {
        return Animator.nGetAnimationCount(this.getNativeObject());
    }

    public float getAnimationDuration(@IntRange(from=0L) int animationIndex) {
        return Animator.nGetAnimationDuration(this.getNativeObject(), animationIndex);
    }

    public String getAnimationName(@IntRange(from=0L) int animationIndex) {
        return Animator.nGetAnimationName(this.getNativeObject(), animationIndex);
    }

    long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Using Animator on destroyed asset");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nApplyAnimation(long var0, int var2, float var3);

    private static native void nUpdateBoneMatrices(long var0);

    private static native void nApplyCrossFade(long var0, int var2, float var3, float var4);

    private static native void nResetBoneMatrices(long var0);

    private static native int nGetAnimationCount(long var0);

    private static native float nGetAnimationDuration(long var0, int var2);

    private static native String nGetAnimationName(long var0, int var2);
}

