/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.gltfio;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.filament.Engine;
import com.google.android.filament.EntityManager;
import com.google.android.filament.gltfio.FilamentAsset;
import com.google.android.filament.gltfio.FilamentInstance;
import com.google.android.filament.gltfio.MaterialProvider;
import java.nio.Buffer;

public class AssetLoader {
    private long mNativeObject;
    private Engine mEngine;
    private MaterialProvider mMaterialCache;

    public AssetLoader(@NonNull Engine engine, @NonNull MaterialProvider provider, @NonNull EntityManager entities) {
        long nativeEngine = engine.getNativeObject();
        long nativeEntities = entities.getNativeObject();
        this.mNativeObject = AssetLoader.nCreateAssetLoader(nativeEngine, provider, nativeEntities);
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Unable to parse glTF asset.");
        }
        this.mEngine = engine;
        this.mMaterialCache = provider;
    }

    public void destroy() {
        AssetLoader.nDestroyAssetLoader(this.mNativeObject);
        this.mNativeObject = 0L;
    }

    @Nullable
    public FilamentAsset createAsset(@NonNull Buffer buffer) {
        long nativeAsset = AssetLoader.nCreateAsset(this.mNativeObject, buffer, buffer.remaining());
        return nativeAsset != 0L ? new FilamentAsset(this.mEngine, nativeAsset) : null;
    }

    @Nullable
    public FilamentAsset createInstancedAsset(@NonNull Buffer buffer, @NonNull FilamentInstance[] instances) {
        long[] nativeInstances = new long[instances.length];
        long nativeAsset = AssetLoader.nCreateInstancedAsset(this.mNativeObject, buffer, buffer.remaining(), nativeInstances);
        if (nativeAsset == 0L) {
            return null;
        }
        FilamentAsset asset = new FilamentAsset(this.mEngine, nativeAsset);
        for (int i = 0; i < nativeInstances.length; ++i) {
            instances[i] = new FilamentInstance(asset, nativeInstances[i]);
        }
        return asset;
    }

    @Nullable
    public FilamentInstance createInstance(@NonNull FilamentAsset asset) {
        long nativeInstance = AssetLoader.nCreateInstance(this.mNativeObject, asset.getNativeObject());
        if (nativeInstance == 0L) {
            return null;
        }
        return new FilamentInstance(asset, nativeInstance);
    }

    public void enableDiagnostics(boolean enable) {
        AssetLoader.nEnableDiagnostics(this.mNativeObject, enable);
    }

    public void destroyAsset(@NonNull FilamentAsset asset) {
        AssetLoader.nDestroyAsset(this.mNativeObject, asset.getNativeObject());
        asset.clearNativeObject();
    }

    private static native long nCreateAssetLoader(long var0, Object var2, long var3);

    private static native void nDestroyAssetLoader(long var0);

    private static native long nCreateAsset(long var0, Buffer var2, int var3);

    private static native long nCreateInstancedAsset(long var0, Buffer var2, int var3, long[] var4);

    private static native long nCreateInstance(long var0, long var2);

    private static native void nEnableDiagnostics(long var0, boolean var2);

    private static native void nDestroyAsset(long var0, long var2);
}

