/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.gltfio;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.google.android.filament.Engine;
import com.google.android.filament.Entity;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.gltfio.Animator;
import com.google.android.filament.gltfio.FilamentAsset;

public class FilamentInstance {
    private FilamentAsset mAsset;
    private long mNativeObject;
    private Animator mAnimator;

    FilamentInstance(FilamentAsset asset, long nativeObject) {
        this.mAsset = asset;
        this.mNativeObject = nativeObject;
        this.mAnimator = null;
    }

    long getNativeObject() {
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    @NonNull
    public FilamentAsset getAsset() {
        return this.mAsset;
    }

    @Entity
    public int getRoot() {
        return FilamentInstance.nGetRoot(this.mNativeObject);
    }

    @NonNull
    @Entity
    public int[] getEntities() {
        int[] result = new int[FilamentInstance.nGetEntityCount(this.mNativeObject)];
        FilamentInstance.nGetEntities(this.mNativeObject, result);
        return result;
    }

    @NonNull
    public Animator getAnimator() {
        if (this.mAnimator != null) {
            return this.mAnimator;
        }
        this.mAnimator = new Animator(FilamentInstance.nGetAnimator(this.mNativeObject));
        return this.mAnimator;
    }

    public int getSkinCount() {
        return FilamentInstance.nGetSkinCount(this.getNativeObject());
    }

    @NonNull
    public String[] getSkinNames() {
        String[] result = new String[this.getSkinCount()];
        FilamentInstance.nGetSkinNames(this.getNativeObject(), result);
        return result;
    }

    public void attachSkin(@IntRange(from=0L) int skinIndex, @Entity int target) {
        FilamentInstance.nAttachSkin(this.getNativeObject(), skinIndex, target);
    }

    public void detachSkin(@IntRange(from=0L) int skinIndex, @Entity int target) {
        FilamentInstance.nDetachSkin(this.getNativeObject(), skinIndex, target);
    }

    public int getJointCountAt(@IntRange(from=0L) int skinIndex) {
        return FilamentInstance.nGetJointCountAt(this.getNativeObject(), skinIndex);
    }

    @NonNull
    @Entity
    public int[] getJointsAt(@IntRange(from=0L) int skinIndex) {
        int[] result = new int[this.getJointCountAt(skinIndex)];
        FilamentInstance.nGetJointsAt(this.getNativeObject(), skinIndex, result);
        return result;
    }

    public void applyMaterialVariant(@IntRange(from=0L) int variantIndex) {
        FilamentInstance.nApplyMaterialVariant(this.mNativeObject, variantIndex);
    }

    @NonNull
    public MaterialInstance[] getMaterialInstances() {
        int count = FilamentInstance.nGetMaterialInstanceCount(this.mNativeObject);
        MaterialInstance[] result = new MaterialInstance[count];
        long[] natives = new long[count];
        FilamentInstance.nGetMaterialInstances(this.mNativeObject, natives);
        Engine engine = this.mAsset.getEngine();
        for (int i = 0; i < count; ++i) {
            result[i] = new MaterialInstance(engine, natives[i]);
        }
        return result;
    }

    @NonNull
    public String[] getMaterialVariantNames() {
        String[] names = new String[FilamentInstance.nGetMaterialVariantCount(this.mNativeObject)];
        FilamentInstance.nGetMaterialVariantNames(this.mNativeObject, names);
        return names;
    }

    private static native int nGetRoot(long var0);

    private static native int nGetEntityCount(long var0);

    private static native void nGetEntities(long var0, int[] var2);

    private static native long nGetAnimator(long var0);

    private static native int nGetMaterialInstanceCount(long var0);

    private static native void nGetMaterialInstances(long var0, long[] var2);

    private static native void nApplyMaterialVariant(long var0, int var2);

    private static native int nGetMaterialVariantCount(long var0);

    private static native void nGetMaterialVariantNames(long var0, String[] var2);

    private static native void nGetJointsAt(long var0, int var2, int[] var3);

    private static native int nGetSkinCount(long var0);

    private static native void nGetSkinNames(long var0, String[] var2);

    private static native int nGetJointCountAt(long var0, int var2);

    private static native void nAttachSkin(long var0, int var2, int var3);

    private static native void nDetachSkin(long var0, int var2, int var3);
}

