/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.gltfio;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.Engine;
import com.google.android.filament.Material;
import com.google.android.filament.MaterialInstance;
import com.google.android.filament.VertexBuffer;
import com.google.android.filament.gltfio.MaterialProvider;
import com.google.android.filament.proguard.UsedByNative;

public class UbershaderProvider
implements MaterialProvider {
    private static final VertexBuffer.VertexAttribute[] sVertexAttributesValues = VertexBuffer.VertexAttribute.values();
    private long mNativeObject;

    public UbershaderProvider(Engine engine) {
        long nativeEngine = engine.getNativeObject();
        this.mNativeObject = UbershaderProvider.nCreateUbershaderProvider(nativeEngine);
    }

    @Override
    public void destroy() {
        UbershaderProvider.nDestroyUbershaderProvider(this.mNativeObject);
        this.mNativeObject = 0L;
    }

    @Override
    @Nullable
    public MaterialInstance createMaterialInstance(MaterialProvider.MaterialKey config, @NonNull @Size(min=8L) int[] uvmap, @Nullable String label, @Nullable String extras) {
        long nativeMaterialInstance = UbershaderProvider.nCreateMaterialInstance(this.mNativeObject, config, uvmap, label, extras);
        return nativeMaterialInstance == 0L ? null : new MaterialInstance(null, nativeMaterialInstance);
    }

    @Override
    @Nullable
    public Material getMaterial(MaterialProvider.MaterialKey config, @NonNull @Size(min=8L) int[] uvmap, @Nullable String label) {
        long nativeMaterial = UbershaderProvider.nGetMaterial(this.mNativeObject, config, uvmap, label);
        return nativeMaterial == 0L ? null : new Material(nativeMaterial);
    }

    @Override
    @NonNull
    public Material[] getMaterials() {
        int count = UbershaderProvider.nGetMaterialCount(this.mNativeObject);
        Material[] result = new Material[count];
        long[] natives = new long[count];
        UbershaderProvider.nGetMaterials(this.mNativeObject, natives);
        for (int i = 0; i < count; ++i) {
            result[i] = new Material(natives[i]);
        }
        return result;
    }

    @Override
    public boolean needsDummyData(int attrib) {
        VertexBuffer.VertexAttribute vattrib = sVertexAttributesValues[attrib];
        switch (vattrib) {
            case UV0: 
            case UV1: 
            case COLOR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void destroyMaterials() {
        UbershaderProvider.nDestroyMaterials(this.mNativeObject);
    }

    @UsedByNative(value="AssetLoader.cpp")
    public long getNativeObject() {
        return this.mNativeObject;
    }

    private static native long nCreateUbershaderProvider(long var0);

    private static native void nDestroyUbershaderProvider(long var0);

    private static native void nDestroyMaterials(long var0);

    private static native long nCreateMaterialInstance(long var0, MaterialProvider.MaterialKey var2, int[] var3, String var4, String var5);

    private static native long nGetMaterial(long var0, MaterialProvider.MaterialKey var2, int[] var3, String var4);

    private static native int nGetMaterialCount(long var0);

    private static native void nGetMaterials(long var0, long[] var2);
}

