// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.api.ads.common.lib.soap.axis.testing.mocks.v201611;

import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;

import java.net.URL;
import java.rmi.Remote;

import javax.xml.rpc.ServiceException;

/**
 * Mock implementation of MockAxisService that extends Axis Service. Mirrors the structure of
 * ServiceLocator types generated by WSDL2Java.
 */
public class MockAxisServiceLocator extends Service implements MockAxisService {

  @SuppressWarnings("unused")
  public MockAxisServiceLocator() {
    // Required for reflective call to this constructor made by AxisHandler.createSoapClient.
  }
  
  @SuppressWarnings("unused")
  public MockAxisServiceLocator(EngineConfiguration engineConfiguration) {
    // Required for reflective call to this constructor made by AxisHandler.createSoapClient.
  }
  
  @Override
  public Remote getPort(@SuppressWarnings("rawtypes") Class proxyInterface)
      throws javax.xml.rpc.ServiceException {
    return getMockServiceInterfacePort();
  }

  @Override
  public MockAxisServiceInterface getMockServiceInterfacePort() throws ServiceException {
    return new MockAxisServiceSoapBindingStub(this);
  }

  @Override
  public MockAxisServiceInterface getMockServiceInterfacePort(URL portAddress)
      throws ServiceException {
    return getMockServiceInterfacePort();
  }

  @Override
  public String getMockServiceInterfacePortAddress() {
    return "https://ads.google.com/api/mock/v201611/MockAxisService";
  }
}