/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.jaxws;

import com.google.api.ads.adwords.lib.client.AdWordsServiceDescriptor;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.conf.AdWordsApiConfiguration;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.jaxws.JaxWsHandler;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.BindingProvider;

public class AdWordsJaxWsHeaderHandler
implements HeaderHandler<AdWordsSession, AdWordsServiceDescriptor> {
    static final String REQUEST_HEADER_LOCAL_PART = "RequestHeader";
    private final JaxWsHandler soapClientHandler;
    private final AdWordsApiConfiguration adWordsApiConfiguration;
    private final AdsLibConfiguration adsLibConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;

    @Inject
    public AdWordsJaxWsHeaderHandler(JaxWsHandler soapClientHandler, AdWordsApiConfiguration adWordsApiConfiguration, AdsLibConfiguration adsLibConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.adWordsApiConfiguration = adWordsApiConfiguration;
        this.adsLibConfiguration = adsLibConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, AdWordsSession adWordsSession, AdWordsServiceDescriptor adWordsServiceDescriptor) throws AuthenticationException, ServiceException {
        Preconditions.checkArgument((boolean)(soapClient instanceof BindingProvider), (String)"soapClient must be BindingProvider but was: %s", (Object)soapClient);
        BindingProvider bindingProvider = (BindingProvider)soapClient;
        Map<String, Object> headerData = this.readHeaderElements(adWordsSession);
        this.setAuthenticationHeaders(soapClient, headerData, adWordsSession);
        this.soapClientHandler.setHeader(bindingProvider, null, null, (Object)this.constructSoapHeader(headerData, adWordsServiceDescriptor));
        this.soapClientHandler.setCompression(bindingProvider, this.adsLibConfiguration.isCompressionEnabled());
        this.soapClientHandler.setRequestTimeout(bindingProvider, this.adsLibConfiguration.getSoapRequestTimeout());
    }

    @VisibleForTesting
    void setAuthenticationHeaders(Object soapClient, Map<String, Object> headerElements, AdWordsSession adWordsSession) throws AuthenticationException {
        this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)adWordsSession);
    }

    private Map<String, Object> readHeaderElements(AdWordsSession adWordsSession) {
        LinkedHashMap mapToFill = Maps.newLinkedHashMap();
        mapToFill.put("clientCustomerId", adWordsSession.getClientCustomerId());
        mapToFill.put("developerToken", adWordsSession.getDeveloperToken());
        mapToFill.put("userAgent", this.userAgentCombiner.getUserAgent(adWordsSession.getUserAgent()));
        mapToFill.put("validateOnly", adWordsSession.isValidateOnly());
        mapToFill.put("partialFailure", adWordsSession.isPartialFailure());
        return mapToFill;
    }

    private SOAPElement constructSoapHeader(Map<String, Object> headerData, AdWordsServiceDescriptor adWordsServiceDescriptor) {
        String requestHeaderNamespace = this.adWordsApiConfiguration.getNamespacePrefix() + "/" + adWordsServiceDescriptor.getPackageGroup() + "/" + adWordsServiceDescriptor.getVersion();
        String requestElementsNamespace = this.adWordsApiConfiguration.getNamespacePrefix() + "/cm/" + adWordsServiceDescriptor.getVersion();
        try {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            SOAPElement requestHeader = soapFactory.createElement(new QName(requestHeaderNamespace, REQUEST_HEADER_LOCAL_PART));
            for (String headerElementName : headerData.keySet()) {
                if (headerData.get(headerElementName) == null) continue;
                SOAPElement newElement = requestHeader.addChildElement(headerElementName, null, requestElementsNamespace);
                newElement.addTextNode(headerData.get(headerElementName).toString());
            }
            return requestHeader;
        }
        catch (SOAPException e) {
            throw new ServiceException("Unexpected exception constructing SOAP header for: " + adWordsServiceDescriptor, (Throwable)e);
        }
    }
}

