/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.jaxws.utils.v201809.batchjob;

import com.google.api.ads.adwords.jaxws.utils.JaxWsBatchJobResponseDeserializer;
import com.google.api.ads.adwords.jaxws.utils.v201809.batchjob.BatchJobMutateRequest;
import com.google.api.ads.adwords.jaxws.utils.v201809.batchjob.BatchJobMutateResponse;
import com.google.api.ads.adwords.jaxws.utils.v201809.batchjob.MutateResult;
import com.google.api.ads.adwords.jaxws.v201809.cm.ApiError;
import com.google.api.ads.adwords.jaxws.v201809.cm.Operand;
import com.google.api.ads.adwords.jaxws.v201809.cm.Operation;
import com.google.api.ads.adwords.lib.utils.BatchJobException;
import com.google.api.ads.adwords.lib.utils.BatchJobHelperInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateRequestInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobMutateResponseInterface;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadResponse;
import com.google.api.ads.adwords.lib.utils.BatchJobUploadStatus;
import com.google.api.ads.adwords.lib.utils.BatchJobUploader;
import com.google.api.ads.adwords.lib.utils.logging.BatchJobLogger;
import com.google.inject.Inject;
import java.net.URI;
import java.net.URL;

class BatchJobHelperImpl
implements BatchJobHelperInterface<Operation, Operand, ApiError, MutateResult, BatchJobMutateResponse> {
    private final BatchJobUploader uploader;
    private final BatchJobLogger batchJobLogger;
    private final JaxWsBatchJobResponseDeserializer deserializer;

    @Inject
    BatchJobHelperImpl(BatchJobUploader uploader, BatchJobLogger batchJobLogger, JaxWsBatchJobResponseDeserializer deserializer) {
        this.uploader = uploader;
        this.batchJobLogger = batchJobLogger;
        this.deserializer = deserializer;
    }

    public BatchJobUploadResponse uploadBatchJobOperations(Iterable<Operation> operations, String uploadUrl) throws BatchJobException {
        return this.uploadIncrementalBatchJobOperations(operations, true, new BatchJobUploadStatus(0L, URI.create(uploadUrl)));
    }

    public BatchJobUploadResponse uploadIncrementalBatchJobOperations(Iterable<? extends Operation> operations, boolean isLastRequest, BatchJobUploadStatus batchJobUploadStatus) throws BatchJobException {
        BatchJobMutateRequest request = new BatchJobMutateRequest();
        request.addOperations(operations);
        return this.uploader.uploadIncrementalBatchJobOperations((BatchJobMutateRequestInterface)request, isLastRequest, batchJobUploadStatus);
    }

    public BatchJobMutateResponse downloadBatchJobMutateResponse(String downloadUrl) throws BatchJobException {
        return this.downloadBatchJobMutateResponse(downloadUrl, 0, Integer.MAX_VALUE);
    }

    public BatchJobMutateResponse downloadBatchJobMutateResponse(String downloadUrl, int startIndex, int numberResults) throws BatchJobException {
        try {
            BatchJobMutateResponse response = this.deserializer.deserializeBatchJobMutateResults(BatchJobMutateResponse.class, new URL(downloadUrl), startIndex, numberResults);
            this.batchJobLogger.logDownload(downloadUrl, (BatchJobMutateResponseInterface)response, null);
            return response;
        }
        catch (Exception e) {
            this.batchJobLogger.logDownload(downloadUrl, null, (Throwable)e);
            throw new BatchJobException("Failed to download batch job mutate response from URL: " + downloadUrl, (Throwable)e);
        }
    }
}

